/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.wrap;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ModifyObjectJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.List;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.DialogPane;
import javafx.scene.layout.BorderPane;

public class WrapJobUtils {
    WrapJobUtils() {
    }

    static PropertyName getContainerPropertyName(FXOMInstance container, List<FXOMObject> children) {
        PropertyName result;
        DesignHierarchyMask mask = new DesignHierarchyMask(container);
        if (container.getSceneGraphObject() instanceof BorderPane) {
            assert (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.TOP));
            assert (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.LEFT));
            assert (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.CENTER));
            assert (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.RIGHT));
            assert (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.BOTTOM));
            assert (children != null && children.size() == 1);
            FXOMObject child = children.iterator().next();
            FXOMObject top = mask.getAccessory(DesignHierarchyMask.Accessory.TOP);
            FXOMObject left = mask.getAccessory(DesignHierarchyMask.Accessory.LEFT);
            FXOMObject center = mask.getAccessory(DesignHierarchyMask.Accessory.CENTER);
            FXOMObject right = mask.getAccessory(DesignHierarchyMask.Accessory.RIGHT);
            FXOMObject bottom = mask.getAccessory(DesignHierarchyMask.Accessory.BOTTOM);
            if (child.equals(top)) {
                result = mask.getPropertyNameForAccessory(DesignHierarchyMask.Accessory.TOP);
            } else if (child.equals(bottom)) {
                result = mask.getPropertyNameForAccessory(DesignHierarchyMask.Accessory.BOTTOM);
            } else if (child.equals(center)) {
                result = mask.getPropertyNameForAccessory(DesignHierarchyMask.Accessory.CENTER);
            } else if (child.equals(left)) {
                result = mask.getPropertyNameForAccessory(DesignHierarchyMask.Accessory.LEFT);
            } else if (child.equals(right)) {
                result = mask.getPropertyNameForAccessory(DesignHierarchyMask.Accessory.RIGHT);
            } else {
                assert (false);
                result = null;
            }
        } else if (container.getSceneGraphObject() instanceof DialogPane) {
            assert (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.DP_CONTENT));
            assert (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.DP_GRAPHIC));
            assert (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.EXPANDABLE_CONTENT));
            assert (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.HEADER));
            assert (children != null && children.size() == 1);
            FXOMObject child = children.iterator().next();
            FXOMObject content = mask.getAccessory(DesignHierarchyMask.Accessory.DP_CONTENT);
            FXOMObject graphic = mask.getAccessory(DesignHierarchyMask.Accessory.DP_GRAPHIC);
            FXOMObject expandableContent = mask.getAccessory(DesignHierarchyMask.Accessory.EXPANDABLE_CONTENT);
            FXOMObject header = mask.getAccessory(DesignHierarchyMask.Accessory.HEADER);
            if (child.equals(content)) {
                result = mask.getPropertyNameForAccessory(DesignHierarchyMask.Accessory.DP_CONTENT);
            } else if (child.equals(graphic)) {
                result = mask.getPropertyNameForAccessory(DesignHierarchyMask.Accessory.DP_GRAPHIC);
            } else if (child.equals(expandableContent)) {
                result = mask.getPropertyNameForAccessory(DesignHierarchyMask.Accessory.EXPANDABLE_CONTENT);
            } else if (child.equals(header)) {
                result = mask.getPropertyNameForAccessory(DesignHierarchyMask.Accessory.HEADER);
            } else {
                assert (false);
                result = null;
            }
        } else if (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.SCENE)) {
            result = mask.getPropertyNameForAccessory(DesignHierarchyMask.Accessory.SCENE);
        } else if (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.ROOT)) {
            result = mask.getPropertyNameForAccessory(DesignHierarchyMask.Accessory.ROOT);
        } else if (mask.isAcceptingSubComponent()) {
            result = mask.getSubComponentPropertyName();
        } else {
            assert (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.CONTENT) || mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.GRAPHIC));
            assert (children != null && children.size() == 1);
            FXOMObject child = children.iterator().next();
            if (!mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.GRAPHIC)) {
                assert (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.CONTENT));
                result = mask.getPropertyNameForAccessory(DesignHierarchyMask.Accessory.CONTENT);
            } else if (!mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.CONTENT)) {
                assert (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.GRAPHIC));
                result = mask.getPropertyNameForAccessory(DesignHierarchyMask.Accessory.GRAPHIC);
            } else {
                FXOMObject content = mask.getAccessory(DesignHierarchyMask.Accessory.CONTENT);
                FXOMObject graphic = mask.getAccessory(DesignHierarchyMask.Accessory.GRAPHIC);
                if (child.equals(content)) {
                    result = mask.getPropertyNameForAccessory(DesignHierarchyMask.Accessory.CONTENT);
                } else if (child.equals(graphic)) {
                    result = mask.getPropertyNameForAccessory(DesignHierarchyMask.Accessory.GRAPHIC);
                } else {
                    assert (false);
                    result = null;
                }
            }
        }
        return result;
    }

    static Bounds getUnionOfBounds(List<FXOMObject> fxomObjects) {
        assert (fxomObjects != null && !fxomObjects.isEmpty());
        Bounds result = null;
        for (FXOMObject fxomObject : fxomObjects) {
            Object scenegraphObject = fxomObject.getSceneGraphObject();
            assert (scenegraphObject instanceof Node);
            Node node = (Node)scenegraphObject;
            if (result == null) {
                result = node.getBoundsInParent();
                continue;
            }
            result = WrapJobUtils.getUnionOfBounds(result, node.getBoundsInParent());
        }
        return result;
    }

    static ModifyObjectJob modifyObjectJob(FXOMInstance instance, Class<?> clazz, String name, Object value, EditorController controller) {
        PropertyName pn = new PropertyName(name, clazz);
        ValuePropertyMetadata vpm = Metadata.getMetadata().queryValueProperty(instance, pn);
        ModifyObjectJob job = new ModifyObjectJob(instance, vpm, value, controller);
        return job;
    }

    static ModifyObjectJob modifyObjectJob(FXOMInstance instance, String name, Object value, EditorController controller) {
        return WrapJobUtils.modifyObjectJob(instance, null, name, value, controller);
    }

    private static Bounds getUnionOfBounds(Bounds ... bounds) {
        if (bounds == null || bounds.length == 0) {
            return new BoundingBox(0.0, 0.0, 0.0, 0.0);
        }
        if (bounds.length == 1) {
            return bounds[0];
        }
        Bounds b0 = bounds[0];
        for (int i = 1; i < bounds.length; ++i) {
            Bounds bi = bounds[i];
            if (bi == null) continue;
            b0 = WrapJobUtils.union(b0, bi);
        }
        return b0;
    }

    private static Bounds union(Bounds b1, Bounds b2) {
        double minX = Math.min(b1.getMinX(), b2.getMinX());
        double minY = Math.min(b1.getMinY(), b2.getMinY());
        double minZ = Math.min(b1.getMinZ(), b2.getMinZ());
        double maxX = Math.max(b1.getMaxX(), b2.getMaxX());
        double maxY = Math.max(b1.getMaxY(), b2.getMaxY());
        double maxZ = Math.max(b1.getMaxZ(), b2.getMaxZ());
        return new BoundingBox(minX, minY, minZ, maxX - minX, maxY - minY, maxZ - minZ);
    }
}

