/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.messagelog;

import com.oracle.javafx.scenebuilder.kit.editor.messagelog.MessageLogEntry;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;

public class MessageLog {
    private final List<MessageLogEntry> entries = new ArrayList<MessageLogEntry>();
    private final SimpleIntegerProperty revision = new SimpleIntegerProperty();
    private final SimpleIntegerProperty numOfWarningMessages = new SimpleIntegerProperty();
    private static final String TIMESTAMP_PATTERN = "h:mm a EEEEEEEEE d MMM. yyyy";
    private static SimpleDateFormat TIMESTAMP_DATE_FORMAT;

    public void logInfoMessage(String infoKey, ResourceBundle bundle, Object ... arguments) {
        this.logMessage(MessageLogEntry.Type.INFO, bundle, infoKey, arguments);
    }

    public void logWarningMessage(String warningKey, ResourceBundle bundle, Object ... arguments) {
        this.logMessage(MessageLogEntry.Type.WARNING, bundle, warningKey, arguments);
    }

    public void logInfoMessage(String infoKey, Object ... arguments) {
        this.logInfoMessage(infoKey, I18N.getBundle(), arguments);
    }

    public void logWarningMessage(String warningKey, Object ... arguments) {
        this.logWarningMessage(warningKey, I18N.getBundle(), arguments);
    }

    public IntegerProperty revisionProperty() {
        return this.revision;
    }

    public IntegerProperty numOfWarningMessagesProperty() {
        return this.numOfWarningMessages;
    }

    public List<MessageLogEntry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public MessageLogEntry getYoungestEntry() {
        return this.entries.isEmpty() ? null : this.entries.get(0);
    }

    public int getEntryCount() {
        return this.entries.size();
    }

    public int getWarningEntryCount() {
        int count = 0;
        for (MessageLogEntry entry : this.entries) {
            if (entry.getType() != MessageLogEntry.Type.WARNING) continue;
            ++count;
        }
        return count;
    }

    public void clear() {
        if (!this.entries.isEmpty()) {
            this.entries.clear();
            this.incrementRevision();
            this.resetNumOfWarningMessages();
        }
    }

    public void clearEntry(MessageLogEntry entry) {
        assert (entry != null);
        assert (this.entries.contains(entry));
        this.entries.remove(entry);
        this.incrementRevision();
        if (entry.getType().equals((Object)MessageLogEntry.Type.WARNING)) {
            this.decrementNumOfWarningMessages();
        }
    }

    private synchronized String getTimeStamp() {
        if (TIMESTAMP_DATE_FORMAT == null) {
            TIMESTAMP_DATE_FORMAT = new SimpleDateFormat(TIMESTAMP_PATTERN);
        }
        return TIMESTAMP_DATE_FORMAT.format(new Date());
    }

    private void logMessage(MessageLogEntry.Type messageType, ResourceBundle bundle, String messageKey, Object ... arguments) {
        String messageText = MessageFormat.format(bundle.getString(messageKey), arguments);
        MessageLogEntry entry = new MessageLogEntry(messageType, messageText, this.getTimeStamp());
        this.entries.add(0, entry);
        this.incrementRevision();
        if (messageType.equals((Object)MessageLogEntry.Type.WARNING)) {
            this.incrementNumOfWarningMessages();
        }
    }

    private void incrementRevision() {
        this.revision.set(this.revision.get() + 1);
    }

    private void incrementNumOfWarningMessages() {
        this.numOfWarningMessages.set(this.numOfWarningMessages.get() + 1);
    }

    private void decrementNumOfWarningMessages() {
        this.numOfWarningMessages.set(this.numOfWarningMessages.get() - 1);
    }

    private void resetNumOfWarningMessages() {
        this.numOfWarningMessages.set(0);
    }
}

