/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.util.CardinalPoint;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.util.LineEquation;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlPopupController;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.stage.WindowEvent;

public class HudWindowController
extends AbstractFxmlPopupController {
    @FXML
    private GridPane gridPane;
    @FXML
    private RowConstraints rowConstraint0;
    private int rowCount;
    private CardinalPoint relativePosition = CardinalPoint.SE;

    public HudWindowController() {
        super(HudWindowController.class.getResource("HudWindow.fxml"));
    }

    public CardinalPoint getRelativePosition() {
        return this.relativePosition;
    }

    public void setRelativePosition(CardinalPoint relativePosition) {
        this.relativePosition = relativePosition;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.getRoot();
        assert (this.gridPane != null);
        this.rowCount = rowCount;
        this.reconfigureGridPane();
    }

    public void setNameAtRowIndex(String name, int rowIndex) {
        assert (0 <= rowIndex);
        assert (rowIndex < this.gridPane.getRowConstraints().size());
        int nameChildIndex = rowIndex * 2;
        Label nameLabel = (Label)this.gridPane.getChildren().get(nameChildIndex);
        nameLabel.setText(name);
    }

    public void setValueAtRowIndex(String value, int rowIndex) {
        assert (0 <= rowIndex);
        assert (rowIndex < this.gridPane.getRowConstraints().size());
        int valueChildIndex = rowIndex * 2 + 1;
        Label valueLabel = (Label)this.gridPane.getChildren().get(valueChildIndex);
        valueLabel.setText(value);
    }

    @Override
    protected void controllerDidLoadFxml() {
        assert (this.gridPane != null);
        assert (this.rowConstraint0 != null);
        this.getRoot().setMouseTransparent(true);
        assert (this.rowCount == 0);
        this.gridPane.getRowConstraints().clear();
        this.gridPane.getChildren().clear();
        this.reconfigureGridPane();
    }

    @Override
    protected void controllerDidCreatePopup() {
        this.getPopup().setAutoFix(false);
        this.getPopup().setAutoHide(false);
        this.getPopup().setConsumeAutoHidingEvents(false);
    }

    @Override
    protected void onHidden(WindowEvent event) {
    }

    @Override
    protected void anchorBoundsDidChange() {
        this.updatePopupLocation();
    }

    @Override
    protected void anchorTransformDidChange() {
        this.updatePopupLocation();
    }

    @Override
    protected void anchorXYDidChange() {
        this.updatePopupLocation();
    }

    @Override
    public void updatePopupLocation() {
        if (this.getAnchor() != null && this.getAnchor().getScene() != null) {
            Point2D popupLocation = this.computePopupLocation();
            this.getPopup().setX(popupLocation.getX());
            this.getPopup().setY(popupLocation.getY());
        }
    }

    private Point2D computePopupLocation() {
        double ox;
        Bounds anchorBounds = this.getAnchor().getLayoutBounds();
        Bounds usefulBounds = HudWindowController.clampBounds(anchorBounds, 1.0, 1.0);
        assert (usefulBounds.getWidth() > 0.0);
        assert (usefulBounds.getHeight() > 0.0);
        Point2D p0 = this.relativePosition.getPosition(usefulBounds);
        Point2D p1 = this.relativePosition.getOpposite().getPosition(usefulBounds);
        Point2D sp0 = this.getAnchor().localToScreen(p0);
        Point2D sp1 = this.getAnchor().localToScreen(p1);
        assert (sp0 != null);
        assert (sp1 != null);
        LineEquation leq = new LineEquation(sp0, sp1);
        Point2D k = leq.pointAtOffset(-30.0);
        Bounds popupBounds = this.getRoot().getLayoutBounds();
        return new Point2D(ox, switch (this.relativePosition) {
            case CardinalPoint.N -> {
                ox = k.getX() - popupBounds.getWidth() / 2.0;
                yield k.getY() - popupBounds.getHeight();
            }
            case CardinalPoint.NE -> {
                ox = k.getX();
                yield k.getY() - popupBounds.getHeight();
            }
            case CardinalPoint.E -> {
                ox = k.getX();
                yield k.getY() - popupBounds.getHeight() / 2.0;
            }
            case CardinalPoint.SE -> {
                ox = k.getX();
                yield k.getY();
            }
            case CardinalPoint.S -> {
                ox = k.getX() - popupBounds.getWidth() / 2.0;
                yield k.getY();
            }
            case CardinalPoint.SW -> {
                ox = k.getX() - popupBounds.getWidth();
                yield k.getY();
            }
            case CardinalPoint.W -> {
                ox = k.getX() - popupBounds.getWidth();
                yield k.getY() - popupBounds.getHeight() / 2.0;
            }
            case CardinalPoint.NW -> {
                ox = k.getX() - popupBounds.getWidth();
                yield k.getY() - popupBounds.getHeight();
            }
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("unexpected cardinal point:" + String.valueOf(this)));
                }
                ox = k.getX();
                yield k.getY();
            }
        });
    }

    private void reconfigureGridPane() {
        ObservableList rowConstraints = this.gridPane.getRowConstraints();
        if (this.rowCount < rowConstraints.size()) {
            while (this.rowCount < rowConstraints.size()) {
                this.removeLastRow();
            }
        } else {
            while (this.rowCount > rowConstraints.size()) {
                this.appendRow();
            }
        }
    }

    private void appendRow() {
        int newRowIndex = this.gridPane.getRowConstraints().size();
        RowConstraints rc = new RowConstraints();
        rc.setFillHeight(this.rowConstraint0.isFillHeight());
        rc.setMaxHeight(this.rowConstraint0.getMaxHeight());
        rc.setMinHeight(this.rowConstraint0.getMinHeight());
        rc.setPercentHeight(this.rowConstraint0.getPercentHeight());
        rc.setPrefHeight(this.rowConstraint0.getPrefHeight());
        rc.setValignment(this.rowConstraint0.getValignment());
        rc.setVgrow(this.rowConstraint0.getVgrow());
        this.gridPane.getRowConstraints().add((Object)rc);
        Label nameLabel = new Label();
        Label valueLabel = new Label();
        nameLabel.getStyleClass().add((Object)"hud-property-label");
        valueLabel.getStyleClass().add((Object)"hud-value-label");
        this.gridPane.getChildren().add((Object)nameLabel);
        this.gridPane.getChildren().add((Object)valueLabel);
        GridPane.setRowIndex((Node)nameLabel, (Integer)newRowIndex);
        GridPane.setRowIndex((Node)valueLabel, (Integer)newRowIndex);
        GridPane.setColumnIndex((Node)nameLabel, (Integer)0);
        GridPane.setColumnIndex((Node)valueLabel, (Integer)1);
    }

    private void removeLastRow() {
        assert (this.gridPane.getRowConstraints().size() >= 1);
        assert (this.gridPane.getChildren().size() >= 2);
        int lastRowIndex = this.gridPane.getRowConstraints().size() - 1;
        this.gridPane.getRowConstraints().remove(lastRowIndex);
        this.gridPane.getChildren().remove(lastRowIndex * 2 + 1);
        this.gridPane.getChildren().remove(lastRowIndex * 2 + 0);
    }

    private static Bounds clampBounds(Bounds b, double minWidth, double minHeight) {
        Bounds result;
        assert (b != null);
        assert (minWidth > 0.0);
        assert (minHeight > 0.0);
        if (b.getWidth() >= minWidth && b.getHeight() >= minHeight) {
            result = b;
        } else {
            double height;
            double minY;
            double width;
            double minX;
            if (b.getWidth() >= minWidth) {
                minX = b.getMinX();
                width = b.getWidth();
            } else {
                minX = b.getMinX() - minWidth / 2.0;
                width = minWidth;
            }
            if (b.getHeight() >= minHeight) {
                minY = b.getMinY();
                height = b.getHeight();
            } else {
                minY = b.getMinY() - minHeight / 2.0;
                height = minHeight;
            }
            result = new BoundingBox(minX, minY, width, height);
        }
        return result;
    }
}

