/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver;

import com.oracle.javafx.scenebuilder.kit.editor.drag.target.AbstractDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.AccessoryDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.AbstractNodeDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.tring.AbstractTring;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.tring.BorderPaneTring;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.layout.BorderPane;

public class BorderPaneDriver
extends AbstractNodeDriver {
    public BorderPaneDriver(ContentPanelController contentPanelController) {
        super(contentPanelController);
    }

    @Override
    public AbstractDropTarget makeDropTarget(FXOMObject fxomObject, double sceneX, double sceneY) {
        assert (fxomObject.getSceneGraphObject() instanceof BorderPane);
        assert (fxomObject instanceof FXOMInstance);
        FXOMInstance fxomInstance = (FXOMInstance)fxomObject;
        BorderPane borderPane = (BorderPane)fxomInstance.getSceneGraphObject();
        Point2D hitPoint = borderPane.sceneToLocal(sceneX, sceneY, true);
        double hitX = hitPoint.getX();
        double hitY = hitPoint.getY();
        Bounds layoutBounds = borderPane.getLayoutBounds();
        Bounds centerBounds = BorderPaneTring.computeCenterBounds(borderPane);
        Bounds topBounds = BorderPaneTring.computeAreaBounds(layoutBounds, centerBounds, DesignHierarchyMask.Accessory.TOP);
        Bounds bottomBounds = BorderPaneTring.computeAreaBounds(layoutBounds, centerBounds, DesignHierarchyMask.Accessory.BOTTOM);
        Bounds leftBounds = BorderPaneTring.computeAreaBounds(layoutBounds, centerBounds, DesignHierarchyMask.Accessory.LEFT);
        Bounds rightBounds = BorderPaneTring.computeAreaBounds(layoutBounds, centerBounds, DesignHierarchyMask.Accessory.RIGHT);
        DesignHierarchyMask.Accessory targetAccessory = centerBounds.contains(hitX, hitY) ? DesignHierarchyMask.Accessory.CENTER : (topBounds.contains(hitX, hitY) ? DesignHierarchyMask.Accessory.TOP : (bottomBounds.contains(hitX, hitY) ? DesignHierarchyMask.Accessory.BOTTOM : (leftBounds.contains(hitX, hitY) ? DesignHierarchyMask.Accessory.LEFT : (rightBounds.contains(hitX, hitY) ? DesignHierarchyMask.Accessory.RIGHT : DesignHierarchyMask.Accessory.CENTER))));
        return new AccessoryDropTarget(fxomInstance, targetAccessory);
    }

    @Override
    public AbstractTring<?> makeTring(AbstractDropTarget dropTarget) {
        assert (dropTarget instanceof AccessoryDropTarget);
        if (!(dropTarget instanceof AccessoryDropTarget)) {
            return null;
        }
        AccessoryDropTarget accessoryDropTarget = (AccessoryDropTarget)dropTarget;
        return new BorderPaneTring(this.contentPanelController, (FXOMInstance)dropTarget.getTargetObject(), accessoryDropTarget.getAccessory());
    }
}

