/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver;

import com.oracle.javafx.scenebuilder.kit.util.Deprecation;
import java.util.Iterator;
import java.util.Set;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;

public class TabPaneDesignInfoX {
    public Node getTabNode(TabPane tabPane, Tab tab) {
        assert (tabPane != null);
        assert (tabPane.getTabs().contains((Object)tab));
        Set set = tabPane.lookupAll(".tab");
        Node result = null;
        Iterator it = set.iterator();
        while (result == null && it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getProperties().get(Tab.class) != tab) continue;
            result = n;
        }
        return result;
    }

    public Node getContentNode(TabPane tabPane) {
        assert (tabPane != null);
        Tab selectedTab = (Tab)tabPane.getSelectionModel().getSelectedItem();
        Node result = selectedTab != null ? selectedTab.getContent() : null;
        return result;
    }

    public Node getControlMenuNode(TabPane tabPane) {
        assert (tabPane != null);
        return tabPane.lookup(".control-buttons-tab");
    }

    public Tab lookupTab(TabPane tabPane, double sceneX, double sceneY) {
        boolean insideControlMenu;
        Tab result = null;
        Node controlMenuNode = this.getControlMenuNode(tabPane);
        if (controlMenuNode == null) {
            insideControlMenu = false;
        } else {
            Point2D p = controlMenuNode.sceneToLocal(sceneX, sceneY, true);
            insideControlMenu = controlMenuNode.contains(p);
        }
        if (!insideControlMenu) {
            Point2D p;
            Node contentNode;
            Iterator it = tabPane.getTabs().iterator();
            while (result == null && it.hasNext()) {
                Tab tab = (Tab)it.next();
                Node tabNode = this.getTabNode(tabPane, tab);
                assert (tabNode != null);
                Point2D p2 = tabNode.sceneToLocal(sceneX, sceneY, true);
                if (!tabNode.contains(p2)) continue;
                result = tab;
            }
            if (result == null && (contentNode = this.getContentNode(tabPane)) != null && contentNode.contains(p = contentNode.sceneToLocal(sceneX, sceneY, true))) {
                result = (Tab)tabPane.getSelectionModel().getSelectedItem();
            }
        }
        return result;
    }

    public Bounds computeTabBounds(TabPane tabPane, Tab tab) {
        Node tabNode = this.getTabNode(tabPane, tab);
        Bounds b = tabNode.getLayoutBounds();
        Point2D min = Deprecation.localToLocal(tabNode, b.getMinX(), b.getMinY(), (Node)tabPane);
        Point2D max = Deprecation.localToLocal(tabNode, b.getMaxX(), b.getMaxY(), (Node)tabPane);
        return TabPaneDesignInfoX.makeBoundingBox(min, max);
    }

    public Bounds computeContentAreaBounds(TabPane tabPane) {
        Node contentNode = this.getContentNode(tabPane);
        assert (contentNode != null);
        Bounds b = contentNode.getLayoutBounds();
        Point2D min = Deprecation.localToLocal(contentNode, b.getMinX(), b.getMinY(), (Node)tabPane);
        Point2D max = Deprecation.localToLocal(contentNode, b.getMaxX(), b.getMaxY(), (Node)tabPane);
        return TabPaneDesignInfoX.makeBoundingBox(min, max);
    }

    private static BoundingBox makeBoundingBox(Point2D p1, Point2D p2) {
        return new BoundingBox(Math.min(p1.getX(), p2.getX()), Math.min(p1.getY(), p2.getY()), Math.abs(p2.getX() - p1.getX()), Math.abs(p2.getY() - p1.getY()));
    }
}

