/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.curve;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.curve.AbstractCurveEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.EditCurveGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.EditCurveGuideController;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.Point2D;
import javafx.scene.shape.CubicCurve;

public class CubicCurveEditor
extends AbstractCurveEditor<CubicCurve> {
    private final double originalStartX;
    private final double originalStartY;
    private final double originalControlX1;
    private final double originalControlY1;
    private final double originalControlX2;
    private final double originalControlY2;
    private final double originalEndX;
    private final double originalEndY;
    private final PropertyName startXName = new PropertyName("startX");
    private final PropertyName startYName = new PropertyName("startY");
    private final PropertyName controlX1Name = new PropertyName("controlX1");
    private final PropertyName controlY1Name = new PropertyName("controlY1");
    private final PropertyName controlX2Name = new PropertyName("controlX2");
    private final PropertyName controlY2Name = new PropertyName("controlY2");
    private final PropertyName endXName = new PropertyName("endX");
    private final PropertyName endYName = new PropertyName("endY");
    private final List<PropertyName> propertyNames = new ArrayList<PropertyName>();

    public CubicCurveEditor(CubicCurve sceneGraphObject) {
        super(sceneGraphObject);
        this.originalStartX = sceneGraphObject.getStartX();
        this.originalStartY = sceneGraphObject.getStartY();
        this.originalControlX1 = sceneGraphObject.getControlX1();
        this.originalControlY1 = sceneGraphObject.getControlY1();
        this.originalControlX2 = sceneGraphObject.getControlX2();
        this.originalControlY2 = sceneGraphObject.getControlY2();
        this.originalEndX = sceneGraphObject.getEndX();
        this.originalEndY = sceneGraphObject.getEndY();
        this.propertyNames.add(this.startXName);
        this.propertyNames.add(this.startYName);
        this.propertyNames.add(this.controlX1Name);
        this.propertyNames.add(this.controlY1Name);
        this.propertyNames.add(this.controlX2Name);
        this.propertyNames.add(this.controlY2Name);
        this.propertyNames.add(this.endXName);
        this.propertyNames.add(this.endYName);
    }

    @Override
    public EditCurveGuideController createController(EnumMap<EditCurveGesture.Tunable, Integer> tunableMap) {
        EditCurveGuideController result;
        if (tunableMap.containsKey((Object)EditCurveGesture.Tunable.START)) {
            result = new EditCurveGuideController();
            Point2D point = ((CubicCurve)this.sceneGraphObject).localToScene(((CubicCurve)this.sceneGraphObject).getControlX1(), ((CubicCurve)this.sceneGraphObject).getControlY1(), true);
            result.addCurvePoint(point);
            point = ((CubicCurve)this.sceneGraphObject).localToScene(((CubicCurve)this.sceneGraphObject).getControlX2(), ((CubicCurve)this.sceneGraphObject).getControlY2(), true);
            result.addCurvePoint(point);
            point = ((CubicCurve)this.sceneGraphObject).localToScene(((CubicCurve)this.sceneGraphObject).getEndX(), ((CubicCurve)this.sceneGraphObject).getEndY(), true);
            result.addCurvePoint(point);
        } else if (tunableMap.containsKey((Object)EditCurveGesture.Tunable.CONTROL1)) {
            result = new EditCurveGuideController();
            Point2D point = ((CubicCurve)this.sceneGraphObject).localToScene(((CubicCurve)this.sceneGraphObject).getStartX(), ((CubicCurve)this.sceneGraphObject).getStartY(), true);
            result.addCurvePoint(point);
            point = ((CubicCurve)this.sceneGraphObject).localToScene(((CubicCurve)this.sceneGraphObject).getControlX2(), ((CubicCurve)this.sceneGraphObject).getControlY2(), true);
            result.addCurvePoint(point);
            point = ((CubicCurve)this.sceneGraphObject).localToScene(((CubicCurve)this.sceneGraphObject).getEndX(), ((CubicCurve)this.sceneGraphObject).getEndY(), true);
            result.addCurvePoint(point);
        } else if (tunableMap.containsKey((Object)EditCurveGesture.Tunable.CONTROL2)) {
            result = new EditCurveGuideController();
            Point2D point = ((CubicCurve)this.sceneGraphObject).localToScene(((CubicCurve)this.sceneGraphObject).getStartX(), ((CubicCurve)this.sceneGraphObject).getStartY(), true);
            result.addCurvePoint(point);
            point = ((CubicCurve)this.sceneGraphObject).localToScene(((CubicCurve)this.sceneGraphObject).getControlX1(), ((CubicCurve)this.sceneGraphObject).getControlY1(), true);
            result.addCurvePoint(point);
            point = ((CubicCurve)this.sceneGraphObject).localToScene(((CubicCurve)this.sceneGraphObject).getEndX(), ((CubicCurve)this.sceneGraphObject).getEndY(), true);
            result.addCurvePoint(point);
        } else if (tunableMap.containsKey((Object)EditCurveGesture.Tunable.END)) {
            result = new EditCurveGuideController();
            Point2D point = ((CubicCurve)this.sceneGraphObject).localToScene(((CubicCurve)this.sceneGraphObject).getStartX(), ((CubicCurve)this.sceneGraphObject).getStartY(), true);
            result.addCurvePoint(point);
            point = ((CubicCurve)this.sceneGraphObject).localToScene(((CubicCurve)this.sceneGraphObject).getControlX1(), ((CubicCurve)this.sceneGraphObject).getControlY1(), true);
            result.addCurvePoint(point);
            point = ((CubicCurve)this.sceneGraphObject).localToScene(((CubicCurve)this.sceneGraphObject).getControlX2(), ((CubicCurve)this.sceneGraphObject).getControlY2(), true);
            result.addCurvePoint(point);
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public void moveTunable(EnumMap<EditCurveGesture.Tunable, Integer> tunableMap, double newX, double newY) {
        if (tunableMap.containsKey((Object)EditCurveGesture.Tunable.START)) {
            ((CubicCurve)this.sceneGraphObject).setStartX(newX);
            ((CubicCurve)this.sceneGraphObject).setStartY(newY);
        } else if (tunableMap.containsKey((Object)EditCurveGesture.Tunable.CONTROL1)) {
            ((CubicCurve)this.sceneGraphObject).setControlX1(newX);
            ((CubicCurve)this.sceneGraphObject).setControlY1(newY);
        } else if (tunableMap.containsKey((Object)EditCurveGesture.Tunable.CONTROL2)) {
            ((CubicCurve)this.sceneGraphObject).setControlX2(newX);
            ((CubicCurve)this.sceneGraphObject).setControlY2(newY);
        } else if (tunableMap.containsKey((Object)EditCurveGesture.Tunable.END)) {
            ((CubicCurve)this.sceneGraphObject).setEndX(newX);
            ((CubicCurve)this.sceneGraphObject).setEndY(newY);
        }
    }

    @Override
    public void revertToOriginalState() {
        ((CubicCurve)this.sceneGraphObject).setStartX(this.originalStartX);
        ((CubicCurve)this.sceneGraphObject).setStartY(this.originalStartY);
        ((CubicCurve)this.sceneGraphObject).setControlX1(this.originalControlX1);
        ((CubicCurve)this.sceneGraphObject).setControlY1(this.originalControlY1);
        ((CubicCurve)this.sceneGraphObject).setControlX2(this.originalControlX2);
        ((CubicCurve)this.sceneGraphObject).setControlY2(this.originalControlY2);
        ((CubicCurve)this.sceneGraphObject).setEndX(this.originalEndX);
        ((CubicCurve)this.sceneGraphObject).setEndY(this.originalEndY);
    }

    @Override
    public List<PropertyName> getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public Object getValue(PropertyName propertyName) {
        assert (propertyName != null);
        assert (this.propertyNames.contains(propertyName));
        Double result = propertyName.equals(this.startXName) ? Double.valueOf(((CubicCurve)this.sceneGraphObject).getStartX()) : (propertyName.equals(this.startYName) ? Double.valueOf(((CubicCurve)this.sceneGraphObject).getStartY()) : (propertyName.equals(this.controlX1Name) ? Double.valueOf(((CubicCurve)this.sceneGraphObject).getControlX1()) : (propertyName.equals(this.controlY1Name) ? Double.valueOf(((CubicCurve)this.sceneGraphObject).getControlY1()) : (propertyName.equals(this.controlX2Name) ? Double.valueOf(((CubicCurve)this.sceneGraphObject).getControlX2()) : (propertyName.equals(this.controlY2Name) ? Double.valueOf(((CubicCurve)this.sceneGraphObject).getControlY2()) : (propertyName.equals(this.endXName) ? Double.valueOf(((CubicCurve)this.sceneGraphObject).getEndX()) : (propertyName.equals(this.endYName) ? Double.valueOf(((CubicCurve)this.sceneGraphObject).getEndY()) : null)))))));
        return result;
    }

    @Override
    public Map<PropertyName, Object> getChangeMap() {
        HashMap<PropertyName, Object> result = new HashMap<PropertyName, Object>();
        if (!MathUtils.equals(((CubicCurve)this.sceneGraphObject).getStartX(), this.originalStartX)) {
            result.put(this.startXName, ((CubicCurve)this.sceneGraphObject).getStartX());
        }
        if (!MathUtils.equals(((CubicCurve)this.sceneGraphObject).getStartY(), this.originalStartY)) {
            result.put(this.startYName, ((CubicCurve)this.sceneGraphObject).getStartY());
        }
        if (!MathUtils.equals(((CubicCurve)this.sceneGraphObject).getControlX1(), this.originalControlX1)) {
            result.put(this.controlX1Name, ((CubicCurve)this.sceneGraphObject).getControlX1());
        }
        if (!MathUtils.equals(((CubicCurve)this.sceneGraphObject).getControlY1(), this.originalControlY1)) {
            result.put(this.controlY1Name, ((CubicCurve)this.sceneGraphObject).getControlY1());
        }
        if (!MathUtils.equals(((CubicCurve)this.sceneGraphObject).getControlX2(), this.originalControlX2)) {
            result.put(this.controlX2Name, ((CubicCurve)this.sceneGraphObject).getControlX2());
        }
        if (!MathUtils.equals(((CubicCurve)this.sceneGraphObject).getControlY2(), this.originalControlY2)) {
            result.put(this.controlY2Name, ((CubicCurve)this.sceneGraphObject).getControlY2());
        }
        if (!MathUtils.equals(((CubicCurve)this.sceneGraphObject).getEndX(), this.originalEndX)) {
            result.put(this.endXName, ((CubicCurve)this.sceneGraphObject).getEndX());
        }
        if (!MathUtils.equals(((CubicCurve)this.sceneGraphObject).getEndY(), this.originalEndY)) {
            result.put(this.endYName, ((CubicCurve)this.sceneGraphObject).getEndY());
        }
        return result;
    }

    @Override
    public List<Double> getPoints() {
        return null;
    }

    @Override
    public void addPoint(EnumMap<EditCurveGesture.Tunable, Integer> tunableMap, double newX, double newY) {
    }

    @Override
    public void removePoint(EnumMap<EditCurveGesture.Tunable, Integer> tunableMap) {
    }
}

