/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.curve;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.curve.AbstractCurveEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.EditCurveGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.EditCurveGuideController;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.Point2D;
import javafx.scene.shape.Line;

public class LineEditor
extends AbstractCurveEditor<Line> {
    private final double originalStartX;
    private final double originalStartY;
    private final double originalEndX;
    private final double originalEndY;
    private final PropertyName startXName = new PropertyName("startX");
    private final PropertyName startYName = new PropertyName("startY");
    private final PropertyName endXName = new PropertyName("endX");
    private final PropertyName endYName = new PropertyName("endY");
    private final List<PropertyName> propertyNames = new ArrayList<PropertyName>();

    public LineEditor(Line sceneGraphObject) {
        super(sceneGraphObject);
        this.originalStartX = sceneGraphObject.getStartX();
        this.originalStartY = sceneGraphObject.getStartY();
        this.originalEndX = sceneGraphObject.getEndX();
        this.originalEndY = sceneGraphObject.getEndY();
        this.propertyNames.add(this.startXName);
        this.propertyNames.add(this.startYName);
        this.propertyNames.add(this.endXName);
        this.propertyNames.add(this.endYName);
    }

    @Override
    public EditCurveGuideController createController(EnumMap<EditCurveGesture.Tunable, Integer> tunableMap) {
        EditCurveGuideController result;
        if (tunableMap.containsKey((Object)EditCurveGesture.Tunable.START)) {
            result = new EditCurveGuideController();
            Point2D point = ((Line)this.sceneGraphObject).localToScene(((Line)this.sceneGraphObject).getEndX(), ((Line)this.sceneGraphObject).getEndY(), true);
            result.addCurvePoint(point);
        } else if (tunableMap.containsKey((Object)EditCurveGesture.Tunable.END)) {
            result = new EditCurveGuideController();
            Point2D point = ((Line)this.sceneGraphObject).localToScene(((Line)this.sceneGraphObject).getStartX(), ((Line)this.sceneGraphObject).getStartY(), true);
            result.addCurvePoint(point);
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public void moveTunable(EnumMap<EditCurveGesture.Tunable, Integer> tunableMap, double newX, double newY) {
        if (tunableMap.containsKey((Object)EditCurveGesture.Tunable.START)) {
            ((Line)this.sceneGraphObject).setStartX(newX);
            ((Line)this.sceneGraphObject).setStartY(newY);
        } else if (tunableMap.containsKey((Object)EditCurveGesture.Tunable.END)) {
            ((Line)this.sceneGraphObject).setEndX(newX);
            ((Line)this.sceneGraphObject).setEndY(newY);
        }
    }

    @Override
    public void revertToOriginalState() {
        ((Line)this.sceneGraphObject).setStartX(this.originalStartX);
        ((Line)this.sceneGraphObject).setStartY(this.originalStartY);
        ((Line)this.sceneGraphObject).setEndX(this.originalEndX);
        ((Line)this.sceneGraphObject).setEndY(this.originalEndY);
    }

    @Override
    public List<PropertyName> getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public Object getValue(PropertyName propertyName) {
        assert (propertyName != null);
        assert (this.propertyNames.contains(propertyName));
        Double result = propertyName.equals(this.startXName) ? Double.valueOf(((Line)this.sceneGraphObject).getStartX()) : (propertyName.equals(this.startYName) ? Double.valueOf(((Line)this.sceneGraphObject).getStartY()) : (propertyName.equals(this.endXName) ? Double.valueOf(((Line)this.sceneGraphObject).getEndX()) : (propertyName.equals(this.endYName) ? Double.valueOf(((Line)this.sceneGraphObject).getEndY()) : null)));
        return result;
    }

    @Override
    public Map<PropertyName, Object> getChangeMap() {
        HashMap<PropertyName, Object> result = new HashMap<PropertyName, Object>();
        if (!MathUtils.equals(((Line)this.sceneGraphObject).getStartX(), this.originalStartX)) {
            result.put(this.startXName, ((Line)this.sceneGraphObject).getStartX());
        }
        if (!MathUtils.equals(((Line)this.sceneGraphObject).getStartY(), this.originalStartY)) {
            result.put(this.startYName, ((Line)this.sceneGraphObject).getStartY());
        }
        if (!MathUtils.equals(((Line)this.sceneGraphObject).getEndX(), this.originalEndX)) {
            result.put(this.endXName, ((Line)this.sceneGraphObject).getEndX());
        }
        if (!MathUtils.equals(((Line)this.sceneGraphObject).getEndY(), this.originalEndY)) {
            result.put(this.endYName, ((Line)this.sceneGraphObject).getEndY());
        }
        return result;
    }

    @Override
    public List<Double> getPoints() {
        return null;
    }

    @Override
    public void addPoint(EnumMap<EditCurveGesture.Tunable, Integer> tunableMap, double newX, double newY) {
    }

    @Override
    public void removePoint(EnumMap<EditCurveGesture.Tunable, Integer> tunableMap) {
    }
}

