/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.curve;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.curve.AbstractCurveEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.EditCurveGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.EditCurveGuideController;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javafx.collections.ObservableList;
import javafx.scene.shape.Polygon;

public class PolygonEditor
extends AbstractCurveEditor<Polygon> {
    private final List<Double> originalPoints;
    private final List<PropertyName> propertyNames = new ArrayList<PropertyName>();
    private int vertexIndex = -1;

    public PolygonEditor(Polygon sceneGraphObject) {
        super(sceneGraphObject);
        this.originalPoints = new ArrayList<Double>((Collection<Double>)sceneGraphObject.getPoints());
    }

    @Override
    public EditCurveGuideController createController(EnumMap<EditCurveGesture.Tunable, Integer> tunableMap) {
        EditCurveGuideController result = new EditCurveGuideController();
        this.vertexIndex = -1;
        if (tunableMap.containsKey((Object)EditCurveGesture.Tunable.VERTEX)) {
            this.vertexIndex = tunableMap.get((Object)EditCurveGesture.Tunable.VERTEX);
        }
        ObservableList points = ((Polygon)this.sceneGraphObject).getPoints();
        IntStream.range(0, points.size() / 2).filter(i -> i != this.vertexIndex).mapToObj(i -> points.subList(i * 2, 2 * (i + 1))).map(list -> ((Polygon)this.sceneGraphObject).localToScene(((Double)list.get(0)).doubleValue(), ((Double)list.get(1)).doubleValue(), true)).forEach(result::addCurvePoint);
        return result;
    }

    @Override
    public void moveTunable(EnumMap<EditCurveGesture.Tunable, Integer> tunableMap, double newX, double newY) {
        Integer index = tunableMap.get((Object)EditCurveGesture.Tunable.VERTEX);
        if (index != null && index > -1 && index < ((Polygon)this.sceneGraphObject).getPoints().size() / 2) {
            ((Polygon)this.sceneGraphObject).getPoints().set(2 * index, (Object)newX);
            ((Polygon)this.sceneGraphObject).getPoints().set(2 * index + 1, (Object)newY);
        }
    }

    @Override
    public void revertToOriginalState() {
        ((Polygon)this.sceneGraphObject).getPoints().setAll(this.originalPoints);
    }

    @Override
    public List<PropertyName> getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public Object getValue(PropertyName propertyName) {
        assert (propertyName != null);
        assert (this.propertyNames.contains(propertyName));
        return null;
    }

    @Override
    public Map<PropertyName, Object> getChangeMap() {
        return new HashMap<PropertyName, Object>();
    }

    @Override
    public List<Double> getPoints() {
        return ((Polygon)this.sceneGraphObject).getPoints();
    }

    @Override
    public void addPoint(EnumMap<EditCurveGesture.Tunable, Integer> tunableMap, double newX, double newY) {
        Integer index = tunableMap.get((Object)EditCurveGesture.Tunable.SIDE);
        if (index != null && (index = Integer.valueOf(index + 1)) > -1 && index <= ((Polygon)this.sceneGraphObject).getPoints().size() / 2) {
            ((Polygon)this.sceneGraphObject).getPoints().add(2 * index, (Object)newY);
            ((Polygon)this.sceneGraphObject).getPoints().add(2 * index, (Object)newX);
        }
    }

    @Override
    public void removePoint(EnumMap<EditCurveGesture.Tunable, Integer> tunableMap) {
        Integer index = tunableMap.get((Object)EditCurveGesture.Tunable.VERTEX);
        if (index != null && index > -1 && index < ((Polygon)this.sceneGraphObject).getPoints().size() / 2) {
            ((Polygon)this.sceneGraphObject).getPoints().remove(2 * index + 1);
            ((Polygon)this.sceneGraphObject).getPoints().remove(2 * index);
        }
    }
}

