/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.curve;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.curve.AbstractCurveEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.EditCurveGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.EditCurveGuideController;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.Point2D;
import javafx.scene.shape.QuadCurve;

public class QuadCurveEditor
extends AbstractCurveEditor<QuadCurve> {
    private final double originalStartX;
    private final double originalStartY;
    private final double originalControlX;
    private final double originalControlY;
    private final double originalEndX;
    private final double originalEndY;
    private final PropertyName startXName = new PropertyName("startX");
    private final PropertyName startYName = new PropertyName("startY");
    private final PropertyName controlXName = new PropertyName("controlX");
    private final PropertyName controlYName = new PropertyName("controlY");
    private final PropertyName endXName = new PropertyName("endX");
    private final PropertyName endYName = new PropertyName("endY");
    private final List<PropertyName> propertyNames = new ArrayList<PropertyName>();

    public QuadCurveEditor(QuadCurve sceneGraphObject) {
        super(sceneGraphObject);
        this.originalStartX = sceneGraphObject.getStartX();
        this.originalStartY = sceneGraphObject.getStartY();
        this.originalControlX = sceneGraphObject.getControlX();
        this.originalControlY = sceneGraphObject.getControlY();
        this.originalEndX = sceneGraphObject.getEndX();
        this.originalEndY = sceneGraphObject.getEndY();
        this.propertyNames.add(this.startXName);
        this.propertyNames.add(this.startYName);
        this.propertyNames.add(this.controlXName);
        this.propertyNames.add(this.controlYName);
        this.propertyNames.add(this.endXName);
        this.propertyNames.add(this.endYName);
    }

    @Override
    public EditCurveGuideController createController(EnumMap<EditCurveGesture.Tunable, Integer> tunableMap) {
        EditCurveGuideController result;
        if (tunableMap.containsKey((Object)EditCurveGesture.Tunable.START)) {
            result = new EditCurveGuideController();
            Point2D point = ((QuadCurve)this.sceneGraphObject).localToScene(((QuadCurve)this.sceneGraphObject).getControlX(), ((QuadCurve)this.sceneGraphObject).getControlY(), true);
            result.addCurvePoint(point);
            point = ((QuadCurve)this.sceneGraphObject).localToScene(((QuadCurve)this.sceneGraphObject).getEndX(), ((QuadCurve)this.sceneGraphObject).getEndY(), true);
            result.addCurvePoint(point);
        } else if (tunableMap.containsKey((Object)EditCurveGesture.Tunable.CONTROL1)) {
            result = new EditCurveGuideController();
            Point2D point = ((QuadCurve)this.sceneGraphObject).localToScene(((QuadCurve)this.sceneGraphObject).getStartX(), ((QuadCurve)this.sceneGraphObject).getStartY(), true);
            result.addCurvePoint(point);
            point = ((QuadCurve)this.sceneGraphObject).localToScene(((QuadCurve)this.sceneGraphObject).getEndX(), ((QuadCurve)this.sceneGraphObject).getEndY(), true);
            result.addCurvePoint(point);
        } else if (tunableMap.containsKey((Object)EditCurveGesture.Tunable.END)) {
            result = new EditCurveGuideController();
            Point2D point = ((QuadCurve)this.sceneGraphObject).localToScene(((QuadCurve)this.sceneGraphObject).getStartX(), ((QuadCurve)this.sceneGraphObject).getStartY(), true);
            result.addCurvePoint(point);
            point = ((QuadCurve)this.sceneGraphObject).localToScene(((QuadCurve)this.sceneGraphObject).getControlX(), ((QuadCurve)this.sceneGraphObject).getControlY(), true);
            result.addCurvePoint(point);
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public void moveTunable(EnumMap<EditCurveGesture.Tunable, Integer> tunableMap, double newX, double newY) {
        if (tunableMap.containsKey((Object)EditCurveGesture.Tunable.START)) {
            ((QuadCurve)this.sceneGraphObject).setStartX(newX);
            ((QuadCurve)this.sceneGraphObject).setStartY(newY);
        } else if (tunableMap.containsKey((Object)EditCurveGesture.Tunable.CONTROL1)) {
            ((QuadCurve)this.sceneGraphObject).setControlX(newX);
            ((QuadCurve)this.sceneGraphObject).setControlY(newY);
        } else if (tunableMap.containsKey((Object)EditCurveGesture.Tunable.END)) {
            ((QuadCurve)this.sceneGraphObject).setEndX(newX);
            ((QuadCurve)this.sceneGraphObject).setEndY(newY);
        }
    }

    @Override
    public void revertToOriginalState() {
        ((QuadCurve)this.sceneGraphObject).setStartX(this.originalStartX);
        ((QuadCurve)this.sceneGraphObject).setStartY(this.originalStartY);
        ((QuadCurve)this.sceneGraphObject).setControlX(this.originalControlX);
        ((QuadCurve)this.sceneGraphObject).setControlY(this.originalControlY);
        ((QuadCurve)this.sceneGraphObject).setEndX(this.originalEndX);
        ((QuadCurve)this.sceneGraphObject).setEndY(this.originalEndY);
    }

    @Override
    public List<PropertyName> getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public Object getValue(PropertyName propertyName) {
        assert (propertyName != null);
        assert (this.propertyNames.contains(propertyName));
        Double result = propertyName.equals(this.startXName) ? Double.valueOf(((QuadCurve)this.sceneGraphObject).getStartX()) : (propertyName.equals(this.startYName) ? Double.valueOf(((QuadCurve)this.sceneGraphObject).getStartY()) : (propertyName.equals(this.controlXName) ? Double.valueOf(((QuadCurve)this.sceneGraphObject).getControlX()) : (propertyName.equals(this.controlYName) ? Double.valueOf(((QuadCurve)this.sceneGraphObject).getControlY()) : (propertyName.equals(this.endXName) ? Double.valueOf(((QuadCurve)this.sceneGraphObject).getEndX()) : (propertyName.equals(this.endYName) ? Double.valueOf(((QuadCurve)this.sceneGraphObject).getEndY()) : null)))));
        return result;
    }

    @Override
    public Map<PropertyName, Object> getChangeMap() {
        HashMap<PropertyName, Object> result = new HashMap<PropertyName, Object>();
        if (!MathUtils.equals(((QuadCurve)this.sceneGraphObject).getStartX(), this.originalStartX)) {
            result.put(this.startXName, ((QuadCurve)this.sceneGraphObject).getStartX());
        }
        if (!MathUtils.equals(((QuadCurve)this.sceneGraphObject).getStartY(), this.originalStartY)) {
            result.put(this.startYName, ((QuadCurve)this.sceneGraphObject).getStartY());
        }
        if (!MathUtils.equals(((QuadCurve)this.sceneGraphObject).getControlX(), this.originalControlX)) {
            result.put(this.controlXName, ((QuadCurve)this.sceneGraphObject).getControlX());
        }
        if (!MathUtils.equals(((QuadCurve)this.sceneGraphObject).getControlY(), this.originalControlY)) {
            result.put(this.controlYName, ((QuadCurve)this.sceneGraphObject).getControlY());
        }
        if (!MathUtils.equals(((QuadCurve)this.sceneGraphObject).getEndX(), this.originalEndX)) {
            result.put(this.endXName, ((QuadCurve)this.sceneGraphObject).getEndX());
        }
        if (!MathUtils.equals(((QuadCurve)this.sceneGraphObject).getEndY(), this.originalEndY)) {
            result.put(this.endYName, ((QuadCurve)this.sceneGraphObject).getEndY());
        }
        return result;
    }

    @Override
    public List<Double> getPoints() {
        return null;
    }

    @Override
    public void addPoint(EnumMap<EditCurveGesture.Tunable, Integer> tunableMap, double newX, double newY) {
    }

    @Override
    public void removePoint(EnumMap<EditCurveGesture.Tunable, Integer> tunableMap) {
    }
}

