/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.AbstractDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles.AbstractHandles;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.AbstractGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.AbstractMouseGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.DiscardGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.ResizeGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.util.CardinalPoint;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;

public abstract class AbstractGenericHandles<T>
extends AbstractHandles<T> {
    private final ImageView handleNW = new ImageView();
    private final ImageView handleNE = new ImageView();
    private final ImageView handleSE = new ImageView();
    private final ImageView handleSW = new ImageView();
    private final ImageView handleNN = new ImageView();
    private final ImageView handleEE = new ImageView();
    private final ImageView handleSS = new ImageView();
    private final ImageView handleWW = new ImageView();
    private final MoveTo moveTo0 = new MoveTo();
    private final LineTo lineTo1 = new LineTo();
    private final LineTo lineTo2 = new LineTo();
    private final LineTo lineTo3 = new LineTo();

    public AbstractGenericHandles(ContentPanelController contentPanelController, FXOMObject fxomObject, Class<T> sceneGraphObjectClass) {
        super(contentPanelController, fxomObject, sceneGraphObjectClass);
        Path shadow = new Path();
        ObservableList shadowElements = shadow.getElements();
        shadowElements.add(this.moveTo0);
        shadowElements.add(this.lineTo1);
        shadowElements.add(this.lineTo2);
        shadowElements.add(this.lineTo3);
        shadowElements.add(new ClosePath());
        shadow.getStyleClass().add((Object)"selection-rect");
        shadow.setMouseTransparent(true);
        this.setupHandleImages();
        this.handleNW.setPickOnBounds(true);
        this.handleNE.setPickOnBounds(true);
        this.handleSE.setPickOnBounds(true);
        this.handleSW.setPickOnBounds(true);
        this.handleNN.setPickOnBounds(true);
        this.handleEE.setPickOnBounds(true);
        this.handleSS.setPickOnBounds(true);
        this.handleWW.setPickOnBounds(true);
        this.attachHandles((Node)this.handleNW);
        this.attachHandles((Node)this.handleNE);
        this.attachHandles((Node)this.handleSE);
        this.attachHandles((Node)this.handleSW);
        this.attachHandles((Node)this.handleNN);
        this.attachHandles((Node)this.handleEE);
        this.attachHandles((Node)this.handleSS);
        this.attachHandles((Node)this.handleWW);
        ObservableList rootNodeChildren = this.getRootNode().getChildren();
        rootNodeChildren.add(shadow);
        rootNodeChildren.add(this.handleNW);
        rootNodeChildren.add(this.handleNE);
        rootNodeChildren.add(this.handleSE);
        rootNodeChildren.add(this.handleSW);
        rootNodeChildren.add(this.handleNN);
        rootNodeChildren.add(this.handleEE);
        rootNodeChildren.add(this.handleSS);
        rootNodeChildren.add(this.handleWW);
    }

    public Node getHandleNode(CardinalPoint cp) {
        return switch (cp) {
            case CardinalPoint.N -> this.handleNN;
            case CardinalPoint.S -> this.handleSS;
            case CardinalPoint.E -> this.handleEE;
            case CardinalPoint.W -> this.handleWW;
            case CardinalPoint.NW -> this.handleNW;
            case CardinalPoint.NE -> this.handleNE;
            case CardinalPoint.SW -> this.handleSW;
            case CardinalPoint.SE -> this.handleSE;
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                yield null;
            }
        };
    }

    @Override
    protected void layoutDecoration() {
        Point2D pNW;
        Point2D pNE;
        Point2D pSE;
        Point2D pSW;
        Point2D pNN;
        Point2D pEE;
        Point2D pSS;
        Point2D pWW;
        Bounds b = this.getSceneGraphObjectBounds();
        double minX = b.getMinX();
        double minY = b.getMinY();
        double maxX = b.getMaxX();
        double maxY = b.getMaxY();
        double midX = (minX + maxX) / 2.0;
        double midY = (minY + maxY) / 2.0;
        boolean zeroWidth = MathUtils.equals(minX, maxX);
        boolean zeroHeight = MathUtils.equals(minY, maxY);
        boolean snapToPixel = true;
        if (zeroWidth && zeroHeight) {
            pSS = pWW = this.sceneGraphObjectToDecoration(minX, minY, true);
            pEE = pWW;
            pNN = pWW;
            pSW = pWW;
            pSE = pWW;
            pNE = pWW;
            pNW = pWW;
        } else if (zeroWidth) {
            pNN = pNE = this.sceneGraphObjectToDecoration(minX, minY, true);
            pNW = pNE;
            pSS = pSE = this.sceneGraphObjectToDecoration(minX, maxY, true);
            pSW = pSE;
            pEE = pWW = this.sceneGraphObjectToDecoration(minX, midY, true);
        } else if (b.getHeight() == 0.0) {
            pWW = pSW = this.sceneGraphObjectToDecoration(minX, minY, true);
            pNW = pSW;
            pEE = pSE = this.sceneGraphObjectToDecoration(maxX, minY, true);
            pNE = pSE;
            pNN = pSS = this.sceneGraphObjectToDecoration(midX, minY, true);
        } else {
            pNW = this.sceneGraphObjectToDecoration(minX, minY, true);
            pNE = this.sceneGraphObjectToDecoration(maxX, minY, true);
            pSE = this.sceneGraphObjectToDecoration(maxX, maxY, true);
            pSW = this.sceneGraphObjectToDecoration(minX, maxY, true);
            pNN = this.sceneGraphObjectToDecoration(midX, minY, true);
            pEE = this.sceneGraphObjectToDecoration(maxX, midY, true);
            pSS = this.sceneGraphObjectToDecoration(midX, maxY, true);
            pWW = this.sceneGraphObjectToDecoration(minX, midY, true);
        }
        this.moveTo0.setX(pNW.getX());
        this.moveTo0.setY(pNW.getY());
        this.lineTo1.setX(pNE.getX());
        this.lineTo1.setY(pNE.getY());
        this.lineTo2.setX(pSE.getX());
        this.lineTo2.setY(pSE.getY());
        this.lineTo3.setX(pSW.getX());
        this.lineTo3.setY(pSW.getY());
        this.handleNW.setLayoutX(pNW.getX());
        this.handleNW.setLayoutY(pNW.getY());
        this.handleNE.setLayoutX(pNE.getX());
        this.handleNE.setLayoutY(pNE.getY());
        this.handleSE.setLayoutX(pSE.getX());
        this.handleSE.setLayoutY(pSE.getY());
        this.handleSW.setLayoutX(pSW.getX());
        this.handleSW.setLayoutY(pSW.getY());
        this.handleNN.setLayoutX(pNN.getX());
        this.handleNN.setLayoutY(pNN.getY());
        this.handleEE.setLayoutX(pEE.getX());
        this.handleEE.setLayoutY(pEE.getY());
        this.handleSS.setLayoutX(pSS.getX());
        this.handleSS.setLayoutY(pSS.getY());
        this.handleWW.setLayoutX(pWW.getX());
        this.handleWW.setLayoutY(pWW.getY());
        Bounds handlesBounds = this.computeBounds(pNW, pNE, pSE, pSW);
        int rotation = this.computeNWHandleRotation(pNW, handlesBounds);
        this.setupCornerHandle(this.handleNW, rotation + 0);
        this.setupCornerHandle(this.handleNE, rotation + 90);
        this.setupCornerHandle(this.handleSE, rotation + 180);
        this.setupCornerHandle(this.handleSW, rotation + 270);
        this.setupSideHandle(this.handleNN, rotation + 0);
        this.setupSideHandle(this.handleEE, rotation + 90);
        this.setupSideHandle(this.handleSS, rotation + 180);
        this.setupSideHandle(this.handleWW, rotation + 270);
        this.showHideSideHandle(this.handleNN, pNW, pNE);
        this.showHideSideHandle(this.handleEE, pNE, pSE);
        this.showHideSideHandle(this.handleSS, pSW, pSE);
        this.showHideSideHandle(this.handleWW, pNW, pSW);
    }

    @Override
    public AbstractGesture findGesture(Node node) {
        AbstractMouseGesture result;
        if (!this.isResizable()) {
            result = new DiscardGesture(this.getContentPanelController());
        } else {
            assert (this.getFxomObject() instanceof FXOMInstance);
            FXOMInstance fxomInstance = (FXOMInstance)this.getFxomObject();
            result = node == this.handleNW ? new ResizeGesture(this.getContentPanelController(), fxomInstance, CardinalPoint.NW) : (node == this.handleNE ? new ResizeGesture(this.getContentPanelController(), fxomInstance, CardinalPoint.NE) : (node == this.handleSE ? new ResizeGesture(this.getContentPanelController(), fxomInstance, CardinalPoint.SE) : (node == this.handleSW ? new ResizeGesture(this.getContentPanelController(), fxomInstance, CardinalPoint.SW) : (node == this.handleNN ? new ResizeGesture(this.getContentPanelController(), fxomInstance, CardinalPoint.N) : (node == this.handleEE ? new ResizeGesture(this.getContentPanelController(), fxomInstance, CardinalPoint.E) : (node == this.handleSS ? new ResizeGesture(this.getContentPanelController(), fxomInstance, CardinalPoint.S) : (node == this.handleWW ? new ResizeGesture(this.getContentPanelController(), fxomInstance, CardinalPoint.W) : null)))))));
        }
        return result;
    }

    @Override
    public void enabledDidChange() {
        this.setupHandleImages();
    }

    private Bounds computeBounds(Point2D p0, Point2D p1, Point2D p2, Point2D p3) {
        double minX = Math.min(Math.min(p0.getX(), p1.getX()), Math.min(p2.getX(), p3.getX()));
        double minY = Math.min(Math.min(p0.getY(), p1.getY()), Math.min(p2.getY(), p3.getY()));
        double maxX = Math.max(Math.max(p0.getX(), p1.getX()), Math.max(p2.getX(), p3.getX()));
        double maxY = Math.max(Math.max(p0.getY(), p1.getY()), Math.max(p2.getY(), p3.getY()));
        return new BoundingBox(minX, minY, maxX - minX, maxY - minY);
    }

    private void setupCornerHandle(ImageView handle, int rotation) {
        double dy;
        double dx;
        rotation = (rotation % 360 + 360) % 360;
        double handleWidth = handle.getLayoutBounds().getWidth();
        if (rotation == 0) {
            dx = 0.0;
            dy = 0.0;
        } else if (rotation == 90) {
            dx = -handleWidth;
            dy = 0.0;
        } else if (rotation == 180) {
            dx = -handleWidth;
            dy = -handleWidth;
        } else if (rotation == 270) {
            dx = 0.0;
            dy = -handleWidth;
        } else {
            assert (false) : "rotation=" + rotation;
            dx = 0.0;
            dy = 0.0;
        }
        handle.setRotate((double)rotation);
        handle.setTranslateX(dx);
        handle.setTranslateY(dy);
    }

    private void setupSideHandle(ImageView handle, int rotation) {
        double dy;
        double dx;
        rotation = (rotation % 360 + 360) % 360;
        double w = handle.getLayoutBounds().getWidth() / 2.0;
        double h = handle.getLayoutBounds().getHeight() / 2.0;
        double k0 = 1.0;
        if (rotation == 0) {
            dx = -w;
            dy = 0.0;
        } else if (rotation == 90) {
            dx = -w - h;
            dy = -h - 1.0;
        } else if (rotation == 180) {
            dx = -w + 1.0;
            dy = -h * 2.0;
        } else if (rotation == 270) {
            dx = -w + h;
            dy = -h;
        } else {
            assert (false) : "rotation=" + rotation;
            dx = 0.0;
            dy = 0.0;
        }
        handle.setRotate((double)rotation);
        handle.setTranslateX(dx);
        handle.setTranslateY(dy);
    }

    private int computeNWHandleRotation(Point2D handlePos, Bounds handlesBounds) {
        int result;
        assert (handlePos != null);
        assert (handlesBounds != null);
        assert (handlesBounds.contains(handlePos));
        if (handlesBounds.getWidth() == 0.0 || handlesBounds.getHeight() == 0.0) {
            result = 180;
        } else {
            double x0 = handlesBounds.getMinX();
            double x1 = handlesBounds.getMaxX();
            double xm = (x0 + x1) / 2.0;
            double y0 = handlesBounds.getMinY();
            double y1 = handlesBounds.getMaxY();
            double ym = (y0 + y1) / 2.0;
            double x = handlePos.getX();
            double y = handlePos.getY();
            result = x <= xm ? (y <= ym ? 180 : 90) : (y <= ym ? 270 : 0);
        }
        return result;
    }

    private void showHideSideHandle(ImageView handle, Point2D p0, Point2D p1) {
        double sideHandleHeight;
        double dx = p1.getX() - p0.getX();
        double dy = p1.getY() - p0.getY();
        double d01 = Math.sqrt(dx * dx + dy * dy);
        double sideHandleWidth = AbstractGenericHandles.getSideHandleImage().getWidth();
        double sideHandleSize = Math.max(sideHandleWidth, sideHandleHeight = AbstractGenericHandles.getSideHandleImage().getHeight());
        boolean handleVisible = sideHandleSize < d01;
        handle.setVisible(handleVisible);
        handle.setMouseTransparent(!handleVisible);
    }

    private void setupHandleImages() {
        Image sideHandleImage;
        Image handleImage;
        if (this.isEnabled() && this.isResizable()) {
            this.handleNW.setCursor(Cursor.NW_RESIZE);
            this.handleNE.setCursor(Cursor.NE_RESIZE);
            this.handleSE.setCursor(Cursor.SE_RESIZE);
            this.handleSW.setCursor(Cursor.SW_RESIZE);
            this.handleNN.setCursor(Cursor.N_RESIZE);
            this.handleEE.setCursor(Cursor.E_RESIZE);
            this.handleSS.setCursor(Cursor.S_RESIZE);
            this.handleWW.setCursor(Cursor.W_RESIZE);
            handleImage = AbstractGenericHandles.getCornerHandleImage();
            sideHandleImage = AbstractGenericHandles.getSideHandleImage();
        } else {
            this.handleNW.setCursor(Cursor.DEFAULT);
            this.handleNE.setCursor(Cursor.DEFAULT);
            this.handleSE.setCursor(Cursor.DEFAULT);
            this.handleSW.setCursor(Cursor.DEFAULT);
            this.handleNN.setCursor(Cursor.DEFAULT);
            this.handleEE.setCursor(Cursor.DEFAULT);
            this.handleSS.setCursor(Cursor.DEFAULT);
            this.handleWW.setCursor(Cursor.DEFAULT);
            handleImage = AbstractGenericHandles.getCornerHandleDimImage();
            sideHandleImage = AbstractGenericHandles.getSideHandleDimImage();
        }
        this.handleNW.setImage(handleImage);
        this.handleNE.setImage(handleImage);
        this.handleSE.setImage(handleImage);
        this.handleSW.setImage(handleImage);
        this.handleNN.setImage(sideHandleImage);
        this.handleEE.setImage(sideHandleImage);
        this.handleSS.setImage(sideHandleImage);
        this.handleWW.setImage(sideHandleImage);
    }

    private boolean isResizable() {
        AbstractDriver driver = this.getContentPanelController().lookupDriver(this.getFxomObject());
        return driver.makeResizer(this.getFxomObject()) != null;
    }

    private void attachHandles(Node node) {
        AbstractGenericHandles.attachHandles(node, this);
    }
}

