/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles.AbstractCurveHandles;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.AbstractGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.EditCurveGesture;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.shape.Circle;
import javafx.scene.shape.CubicCurve;
import javafx.scene.shape.Line;

public class CubicCurveHandles
extends AbstractCurveHandles<CubicCurve> {
    private final Circle startHandle = new Circle(5.0);
    private final Circle control1Handle = new Circle(3.3333333333333335);
    private final Circle control2Handle = new Circle(3.3333333333333335);
    private final Circle endHandle = new Circle(5.0);
    private final Line leftHandle = new Line();
    private final Line centerHandle = new Line();
    private final Line rightHandle = new Line();

    public CubicCurveHandles(ContentPanelController contentPanelController, FXOMInstance fxomInstance) {
        super(contentPanelController, fxomInstance, CubicCurve.class);
        this.setupHandleState(this.startHandle);
        this.setupHandleState(this.control1Handle);
        this.setupHandleState(this.control2Handle);
        this.setupHandleState(this.endHandle);
        this.leftHandle.getStyleClass().add((Object)"selection-wire");
        this.centerHandle.getStyleClass().add((Object)"selection-wire");
        this.rightHandle.getStyleClass().add((Object)"selection-wire");
        this.setupHandles((Node)this.startHandle);
        this.setupHandles((Node)this.control1Handle);
        this.setupHandles((Node)this.control2Handle);
        this.setupHandles((Node)this.endHandle);
        this.setupHandles((Node)this.leftHandle);
        this.setupHandles((Node)this.centerHandle);
        this.setupHandles((Node)this.rightHandle);
        ObservableList rootNodeChildren = this.getRootNode().getChildren();
        rootNodeChildren.add(this.leftHandle);
        rootNodeChildren.add(this.centerHandle);
        rootNodeChildren.add(this.rightHandle);
        rootNodeChildren.add(this.startHandle);
        rootNodeChildren.add(this.control1Handle);
        rootNodeChildren.add(this.control2Handle);
        rootNodeChildren.add(this.endHandle);
    }

    public FXOMInstance getFxomInstance() {
        return (FXOMInstance)this.getFxomObject();
    }

    @Override
    protected void layoutDecoration() {
        CubicCurve l = (CubicCurve)this.getSceneGraphObject();
        boolean snapToPixel = true;
        Point2D s = this.sceneGraphObjectToDecoration(l.getStartX(), l.getStartY(), true);
        Point2D c1 = this.sceneGraphObjectToDecoration(l.getControlX1(), l.getControlY1(), true);
        Point2D c2 = this.sceneGraphObjectToDecoration(l.getControlX2(), l.getControlY2(), true);
        Point2D e = this.sceneGraphObjectToDecoration(l.getEndX(), l.getEndY(), true);
        this.startHandle.setCenterX(s.getX());
        this.startHandle.setCenterY(s.getY());
        this.control1Handle.setCenterX(c1.getX());
        this.control1Handle.setCenterY(c1.getY());
        this.control2Handle.setCenterX(c2.getX());
        this.control2Handle.setCenterY(c2.getY());
        this.endHandle.setCenterX(e.getX());
        this.endHandle.setCenterY(e.getY());
        this.leftHandle.setStartX(s.getX());
        this.leftHandle.setStartY(s.getY());
        this.leftHandle.setEndX(c1.getX());
        this.leftHandle.setEndY(c1.getY());
        this.centerHandle.setStartX(c1.getX());
        this.centerHandle.setStartY(c1.getY());
        this.centerHandle.setEndX(c2.getX());
        this.centerHandle.setEndY(c2.getY());
        this.rightHandle.setStartX(c2.getX());
        this.rightHandle.setStartY(c2.getY());
        this.rightHandle.setEndX(e.getX());
        this.rightHandle.setEndY(e.getY());
    }

    @Override
    protected void startListeningToSceneGraphObject() {
        super.startListeningToSceneGraphObject();
        CubicCurve l = (CubicCurve)this.getSceneGraphObject();
        l.startXProperty().addListener(this.coordinateListener);
        l.startYProperty().addListener(this.coordinateListener);
        l.controlX1Property().addListener(this.coordinateListener);
        l.controlY1Property().addListener(this.coordinateListener);
        l.controlX2Property().addListener(this.coordinateListener);
        l.controlY2Property().addListener(this.coordinateListener);
        l.endXProperty().addListener(this.coordinateListener);
        l.endYProperty().addListener(this.coordinateListener);
    }

    @Override
    protected void stopListeningToSceneGraphObject() {
        super.stopListeningToSceneGraphObject();
        CubicCurve l = (CubicCurve)this.getSceneGraphObject();
        l.startXProperty().removeListener(this.coordinateListener);
        l.startYProperty().removeListener(this.coordinateListener);
        l.controlX1Property().removeListener(this.coordinateListener);
        l.controlY1Property().removeListener(this.coordinateListener);
        l.controlX2Property().removeListener(this.coordinateListener);
        l.controlY2Property().removeListener(this.coordinateListener);
        l.endXProperty().removeListener(this.coordinateListener);
        l.endYProperty().removeListener(this.coordinateListener);
    }

    @Override
    public AbstractGesture findGesture(Node node) {
        EditCurveGesture result = node == this.startHandle ? new EditCurveGesture(this.getContentPanelController(), this.getFxomInstance(), EditCurveGesture.Tunable.START) : (node == this.control1Handle ? new EditCurveGesture(this.getContentPanelController(), this.getFxomInstance(), EditCurveGesture.Tunable.CONTROL1) : (node == this.control2Handle ? new EditCurveGesture(this.getContentPanelController(), this.getFxomInstance(), EditCurveGesture.Tunable.CONTROL2) : (node == this.endHandle ? new EditCurveGesture(this.getContentPanelController(), this.getFxomInstance(), EditCurveGesture.Tunable.END) : null)));
        return result;
    }

    @Override
    public void enabledDidChange() {
        this.setupHandleState(this.startHandle);
        this.setupHandleState(this.control1Handle);
        this.setupHandleState(this.control2Handle);
        this.setupHandleState(this.endHandle);
    }

    private void setupHandleState(Circle handleCircle) {
        String styleClass = this.isEnabled() ? "selection-handles" : "selection-handles-dim";
        Cursor cursor = this.isEnabled() ? Cursor.OPEN_HAND : Cursor.DEFAULT;
        handleCircle.getStyleClass().add((Object)styleClass);
        handleCircle.setCursor(cursor);
    }

    private void setupHandles(Node node) {
        CubicCurveHandles.attachHandles(node, this);
    }
}

