/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles.AbstractCurveHandles;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.AbstractGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.EditCurveGesture;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import javafx.collections.ObservableList;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.Polyline;

public class PolylineHandles
extends AbstractCurveHandles<Polyline> {
    private final List<Circle> verticesHandle = new ArrayList<Circle>();
    private final List<Line> linesHandle = new ArrayList<Line>();

    public PolylineHandles(ContentPanelController contentPanelController, FXOMInstance fxomInstance) {
        super(contentPanelController, fxomInstance, Polyline.class);
        ObservableList rootNodeChildren = this.getRootNode().getChildren();
        this.setupHandles((List<Node>)rootNodeChildren);
    }

    public FXOMInstance getFxomInstance() {
        return (FXOMInstance)this.getFxomObject();
    }

    @Override
    protected void layoutDecoration() {
        Polyline l = (Polyline)this.getSceneGraphObject();
        boolean snapToPixel = true;
        if (l.getPoints().size() != this.verticesHandle.size() * 2) {
            this.setupHandles((List<Node>)this.getRootNode().getChildren());
        }
        if (l.getPoints().size() % 2 != 0) {
            return;
        }
        AtomicInteger counter = new AtomicInteger();
        IntStream.range(0, l.getPoints().size() / 2).mapToObj(i -> l.getPoints().subList(i * 2, 2 * (i + 1))).map(list -> this.sceneGraphObjectToDecoration((Double)list.get(0), (Double)list.get(1), true)).forEach(p -> {
            Circle c = this.verticesHandle.get(counter.getAndIncrement());
            c.setCenterX(p.getX());
            c.setCenterY(p.getY());
        });
        IntStream.range(0, this.verticesHandle.size() - 1).forEach(i -> {
            Circle c1 = this.verticesHandle.get(i);
            Circle c2 = this.verticesHandle.get(i + 1);
            Line line = this.linesHandle.get(i);
            line.setStartX(c1.getCenterX());
            line.setStartY(c1.getCenterY());
            line.setEndX(c2.getCenterX());
            line.setEndY(c2.getCenterY());
        });
    }

    @Override
    protected void startListeningToSceneGraphObject() {
        super.startListeningToSceneGraphObject();
        Polyline l = (Polyline)this.getSceneGraphObject();
        l.getPoints().addListener(this.pointsListener);
    }

    @Override
    protected void stopListeningToSceneGraphObject() {
        super.stopListeningToSceneGraphObject();
        Polyline l = (Polyline)this.getSceneGraphObject();
        l.getPoints().removeListener(this.pointsListener);
    }

    @Override
    public AbstractGesture findGesture(Node node) {
        EditCurveGesture result;
        if (node instanceof Circle && this.verticesHandle.contains((Circle)node)) {
            result = new EditCurveGesture(this.getContentPanelController(), this.getFxomInstance(), EditCurveGesture.Tunable.VERTEX);
            result.getTunableMap().put(EditCurveGesture.Tunable.VERTEX, this.verticesHandle.indexOf((Circle)node));
        } else if (node instanceof Line && this.linesHandle.contains((Line)node)) {
            result = new EditCurveGesture(this.getContentPanelController(), this.getFxomInstance(), EditCurveGesture.Tunable.SIDE);
            result.getTunableMap().put(EditCurveGesture.Tunable.SIDE, this.linesHandle.indexOf((Line)node));
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public void enabledDidChange() {
        this.verticesHandle.forEach(this::setupHandleState);
    }

    private void setupHandles(List<Node> rootNodeChildren) {
        this.verticesHandle.clear();
        this.linesHandle.clear();
        rootNodeChildren.clear();
        Polyline l = (Polyline)this.getSceneGraphObject();
        IntStream.range(0, l.getPoints().size() / 2 - 1).mapToObj(i -> new Line()).forEach(line -> {
            this.linesHandle.add((Line)line);
            line.getStyleClass().add((Object)"selection-pipe");
            line.setCursor(Cursor.CROSSHAIR);
            this.setupHandles((Node)line);
            rootNodeChildren.add((Node)line);
        });
        IntStream.range(0, l.getPoints().size() / 2).mapToObj(i -> new Circle(5.0)).forEach(c -> {
            this.verticesHandle.add((Circle)c);
            this.setupHandleState((Circle)c);
            this.setupHandles((Node)c);
            rootNodeChildren.add((Node)c);
        });
    }

    private void setupHandleState(Circle handleCircle) {
        String styleClass = this.isEnabled() ? "selection-handles" : "selection-handles-dim";
        Cursor cursor = this.isEnabled() ? Cursor.OPEN_HAND : Cursor.DEFAULT;
        handleCircle.getStyleClass().add((Object)styleClass);
        handleCircle.setCursor(cursor);
    }

    private void setupHandles(Node node) {
        PolylineHandles.attachHandles(node, this);
    }
}

