/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles.AbstractCurveHandles;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.AbstractGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.EditCurveGesture;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.QuadCurve;

public class QuadCurveHandles
extends AbstractCurveHandles<QuadCurve> {
    private final Circle startHandle = new Circle(5.0);
    private final Circle controlHandle = new Circle(3.3333333333333335);
    private final Circle endHandle = new Circle(5.0);
    private final Line leftHandle = new Line();
    private final Line rightHandle = new Line();

    public QuadCurveHandles(ContentPanelController contentPanelController, FXOMInstance fxomInstance) {
        super(contentPanelController, fxomInstance, QuadCurve.class);
        this.setupHandleState(this.startHandle);
        this.setupHandleState(this.controlHandle);
        this.setupHandleState(this.endHandle);
        this.leftHandle.getStyleClass().add((Object)"selection-wire");
        this.rightHandle.getStyleClass().add((Object)"selection-wire");
        this.setupHandles((Node)this.startHandle);
        this.setupHandles((Node)this.controlHandle);
        this.setupHandles((Node)this.endHandle);
        this.setupHandles((Node)this.leftHandle);
        this.setupHandles((Node)this.rightHandle);
        ObservableList rootNodeChildren = this.getRootNode().getChildren();
        rootNodeChildren.add(this.leftHandle);
        rootNodeChildren.add(this.rightHandle);
        rootNodeChildren.add(this.startHandle);
        rootNodeChildren.add(this.controlHandle);
        rootNodeChildren.add(this.endHandle);
    }

    public FXOMInstance getFxomInstance() {
        return (FXOMInstance)this.getFxomObject();
    }

    @Override
    protected void layoutDecoration() {
        QuadCurve l = (QuadCurve)this.getSceneGraphObject();
        boolean snapToPixel = true;
        Point2D s = this.sceneGraphObjectToDecoration(l.getStartX(), l.getStartY(), true);
        Point2D c = this.sceneGraphObjectToDecoration(l.getControlX(), l.getControlY(), true);
        Point2D e = this.sceneGraphObjectToDecoration(l.getEndX(), l.getEndY(), true);
        this.startHandle.setCenterX(s.getX());
        this.startHandle.setCenterY(s.getY());
        this.controlHandle.setCenterX(c.getX());
        this.controlHandle.setCenterY(c.getY());
        this.endHandle.setCenterX(e.getX());
        this.endHandle.setCenterY(e.getY());
        this.leftHandle.setStartX(s.getX());
        this.leftHandle.setStartY(s.getY());
        this.leftHandle.setEndX(c.getX());
        this.leftHandle.setEndY(c.getY());
        this.rightHandle.setStartX(c.getX());
        this.rightHandle.setStartY(c.getY());
        this.rightHandle.setEndX(e.getX());
        this.rightHandle.setEndY(e.getY());
    }

    @Override
    protected void startListeningToSceneGraphObject() {
        super.startListeningToSceneGraphObject();
        QuadCurve l = (QuadCurve)this.getSceneGraphObject();
        l.startXProperty().addListener(this.coordinateListener);
        l.startYProperty().addListener(this.coordinateListener);
        l.controlXProperty().addListener(this.coordinateListener);
        l.controlYProperty().addListener(this.coordinateListener);
        l.endXProperty().addListener(this.coordinateListener);
        l.endYProperty().addListener(this.coordinateListener);
    }

    @Override
    protected void stopListeningToSceneGraphObject() {
        super.stopListeningToSceneGraphObject();
        QuadCurve l = (QuadCurve)this.getSceneGraphObject();
        l.startXProperty().removeListener(this.coordinateListener);
        l.startYProperty().removeListener(this.coordinateListener);
        l.controlXProperty().removeListener(this.coordinateListener);
        l.controlYProperty().removeListener(this.coordinateListener);
        l.endXProperty().removeListener(this.coordinateListener);
        l.endYProperty().removeListener(this.coordinateListener);
    }

    @Override
    public AbstractGesture findGesture(Node node) {
        EditCurveGesture result = node == this.startHandle ? new EditCurveGesture(this.getContentPanelController(), this.getFxomInstance(), EditCurveGesture.Tunable.START) : (node == this.controlHandle ? new EditCurveGesture(this.getContentPanelController(), this.getFxomInstance(), EditCurveGesture.Tunable.CONTROL1) : (node == this.endHandle ? new EditCurveGesture(this.getContentPanelController(), this.getFxomInstance(), EditCurveGesture.Tunable.END) : null));
        return result;
    }

    @Override
    public void enabledDidChange() {
        this.setupHandleState(this.startHandle);
        this.setupHandleState(this.controlHandle);
        this.setupHandleState(this.endHandle);
    }

    private void setupHandleState(Circle handleCircle) {
        String styleClass = this.isEnabled() ? "selection-handles" : "selection-handles-dim";
        Cursor cursor = this.isEnabled() ? Cursor.OPEN_HAND : Cursor.DEFAULT;
        handleCircle.getStyleClass().add((Object)styleClass);
        handleCircle.setCursor(cursor);
    }

    private void setupHandles(Node node) {
        QuadCurveHandles.attachHandles(node, this);
    }
}

