/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.TreeTableViewDesignInfoX;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles.AbstractNodeHandles;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.AbstractGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.ResizeTreeTableColumnGesture;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;

public class TreeTableViewHandles
extends AbstractNodeHandles<Node> {
    private final Group grips = new Group();

    public TreeTableViewHandles(ContentPanelController contentPanelController, FXOMInstance fxomInstance) {
        super(contentPanelController, fxomInstance, Node.class);
        assert (fxomInstance.getSceneGraphObject() instanceof TreeTableView);
        this.getRootNode().getChildren().add((Object)this.grips);
    }

    public TreeTableView<?> getTreeTableView() {
        return (TreeTableView)this.getSceneGraphObject();
    }

    @Override
    protected void layoutDecoration() {
        super.layoutDecoration();
        this.adjustGripCount();
        int count = this.getTreeTableView().getColumns().size();
        for (int i = 0; i < count; ++i) {
            this.layoutGrip(i);
        }
    }

    @Override
    public AbstractGesture findGesture(Node node) {
        AbstractGesture result;
        int gripIndex = this.grips.getChildren().indexOf((Object)node);
        if (gripIndex != -1) {
            DesignHierarchyMask m = new DesignHierarchyMask(this.getFxomInstance());
            FXOMObject columnObject = m.getSubComponentAtIndex(gripIndex);
            assert (columnObject instanceof FXOMInstance);
            result = new ResizeTreeTableColumnGesture(this.getContentPanelController(), (FXOMInstance)columnObject);
        } else {
            result = super.findGesture(node);
        }
        return result;
    }

    private void adjustGripCount() {
        int columnCount = this.getTreeTableView().getColumns().size();
        ObservableList gripChildren = this.grips.getChildren();
        while (gripChildren.size() < columnCount) {
            gripChildren.add(this.makeGripLine());
        }
        while (gripChildren.size() > columnCount) {
            gripChildren.remove(gripChildren.size() - 1);
        }
    }

    private Line makeGripLine() {
        Line result = new Line();
        result.setStrokeWidth(10.0);
        result.setStroke((Paint)Color.TRANSPARENT);
        result.setCursor(Cursor.H_RESIZE);
        this.attachHandles((Node)result);
        return result;
    }

    private void layoutGrip(int gripIndex) {
        assert (this.grips.getChildren().get(gripIndex) instanceof Line);
        TreeTableColumn tc = (TreeTableColumn)this.getTreeTableView().getColumns().get(gripIndex);
        if (tc.isVisible()) {
            TreeTableViewDesignInfoX di = new TreeTableViewDesignInfoX();
            Bounds b = di.getColumnHeaderBounds(tc);
            double startX = b.getMaxX();
            double startY = b.getMinY();
            double endY = b.getMaxY();
            boolean snapToPixel = true;
            Point2D startPoint = this.sceneGraphObjectToDecoration(startX, startY, true);
            Point2D endPoint = this.sceneGraphObjectToDecoration(startX, endY, true);
            Line gripLine = (Line)this.grips.getChildren().get(gripIndex);
            gripLine.setVisible(true);
            gripLine.setManaged(true);
            gripLine.setStartX(startPoint.getX());
            gripLine.setStartY(startPoint.getY());
            gripLine.setEndX(endPoint.getX());
            gripLine.setEndY(endPoint.getY());
        } else {
            Line gripLine = (Line)this.grips.getChildren().get(gripIndex);
            gripLine.setVisible(false);
            gripLine.setManaged(false);
        }
    }

    private void attachHandles(Node node) {
        TreeTableViewHandles.attachHandles(node, this);
    }
}

