/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles.AbstractGenericHandles;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.stage.Window;

public class WindowHandles
extends AbstractGenericHandles<Window> {
    private final Pane dummyPane = new Pane();
    private Node sceneGraphObject;

    public WindowHandles(ContentPanelController contentPanelController, FXOMInstance fxomInstance) {
        super(contentPanelController, fxomInstance, Window.class);
        DesignHierarchyMask designHierarchyMask = new DesignHierarchyMask(fxomInstance);
        FXOMObject scene = designHierarchyMask.getAccessory(DesignHierarchyMask.Accessory.SCENE);
        if (scene == null) {
            this.sceneGraphObject = null;
        } else {
            DesignHierarchyMask sceneDesignHierarchyMask = new DesignHierarchyMask(scene);
            FXOMObject root = sceneDesignHierarchyMask.getAccessory(DesignHierarchyMask.Accessory.ROOT);
            assert (root != null);
            assert (root instanceof FXOMInstance);
            assert (root.getSceneGraphObject() instanceof Node);
            this.sceneGraphObject = (Node)root.getSceneGraphObject();
        }
    }

    @Override
    public Bounds getSceneGraphObjectBounds() {
        if (this.sceneGraphObject != null) {
            return this.sceneGraphObject.getLayoutBounds();
        }
        return new BoundingBox(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public Node getSceneGraphObjectProxy() {
        return this.sceneGraphObject != null ? this.sceneGraphObject : this.dummyPane;
    }

    @Override
    protected void startListeningToSceneGraphObject() {
        if (this.sceneGraphObject == null) {
            return;
        }
        this.startListeningToLayoutBounds(this.sceneGraphObject);
        this.startListeningToLocalToSceneTransform(this.sceneGraphObject);
    }

    @Override
    protected void stopListeningToSceneGraphObject() {
        if (this.sceneGraphObject == null) {
            return;
        }
        this.stopListeningToLayoutBounds(this.sceneGraphObject);
        this.stopListeningToLocalToSceneTransform(this.sceneGraphObject);
    }
}

