/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.relocater;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.relocater.AbstractRelocater;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;

public class AnchorPaneRelocater
extends AbstractRelocater<AnchorPane> {
    private final double originalLayoutX;
    private final double originalLayoutY;
    private final Double originalLeftAnchor;
    private final Double originalRightAnchor;
    private final Double originalTopAnchor;
    private final Double originalBottomAnchor;
    private final PropertyName layoutXName = new PropertyName("layoutX");
    private final PropertyName layoutYName = new PropertyName("layoutY");
    private final PropertyName leftAnchorName = new PropertyName("leftAnchor", AnchorPane.class);
    private final PropertyName rightAnchorName = new PropertyName("rightAnchor", AnchorPane.class);
    private final PropertyName topAnchorName = new PropertyName("topAnchor", AnchorPane.class);
    private final PropertyName bottomAnchorName = new PropertyName("bottomAnchor", AnchorPane.class);
    private final List<PropertyName> propertyNames = new ArrayList<PropertyName>();

    public AnchorPaneRelocater(Node sceneGraphObject) {
        super(sceneGraphObject, AnchorPane.class);
        this.originalLayoutX = sceneGraphObject.getLayoutX();
        this.originalLayoutY = sceneGraphObject.getLayoutY();
        this.originalLeftAnchor = AnchorPane.getLeftAnchor((Node)sceneGraphObject);
        this.originalRightAnchor = AnchorPane.getRightAnchor((Node)sceneGraphObject);
        this.originalTopAnchor = AnchorPane.getTopAnchor((Node)sceneGraphObject);
        this.originalBottomAnchor = AnchorPane.getBottomAnchor((Node)sceneGraphObject);
        if (this.originalLeftAnchor == null && this.originalRightAnchor == null) {
            this.propertyNames.add(this.layoutXName);
        } else {
            if (this.originalLeftAnchor != null) {
                this.propertyNames.add(this.leftAnchorName);
                this.propertyNames.add(this.layoutXName);
            }
            if (this.originalRightAnchor != null) {
                this.propertyNames.add(this.rightAnchorName);
            }
        }
        if (this.originalTopAnchor == null && this.originalBottomAnchor == null) {
            this.propertyNames.add(this.layoutYName);
        } else {
            if (this.originalTopAnchor != null) {
                this.propertyNames.add(this.topAnchorName);
                this.propertyNames.add(this.layoutYName);
            }
            if (this.originalBottomAnchor != null) {
                this.propertyNames.add(this.bottomAnchorName);
            }
        }
    }

    @Override
    public void moveToLayoutX(double newLayoutX, Bounds newLayoutBounds) {
        if (this.originalLeftAnchor == null && this.originalRightAnchor == null) {
            this.sceneGraphObject.setLayoutX((double)Math.round(newLayoutX));
        } else {
            Bounds parentLayoutBounds = this.sceneGraphObject.getParent().getLayoutBounds();
            if (this.originalLeftAnchor != null) {
                double leftAnchor = AnchorPaneRelocater.computeLeftAnchor(parentLayoutBounds, newLayoutBounds, newLayoutX);
                AnchorPane.setLeftAnchor((Node)this.sceneGraphObject, (Double)Double.valueOf(Math.round(leftAnchor)));
            }
            if (this.originalRightAnchor != null) {
                double rightAnchor = AnchorPaneRelocater.computeRightAnchor(parentLayoutBounds, newLayoutBounds, newLayoutX);
                AnchorPane.setRightAnchor((Node)this.sceneGraphObject, (Double)Double.valueOf(Math.round(rightAnchor)));
            }
        }
    }

    @Override
    public void moveToLayoutY(double newLayoutY, Bounds newLayoutBounds) {
        if (this.originalTopAnchor == null && this.originalBottomAnchor == null) {
            this.sceneGraphObject.setLayoutY((double)Math.round(newLayoutY));
        } else {
            Bounds parentLayoutBounds = this.sceneGraphObject.getParent().getLayoutBounds();
            if (this.originalTopAnchor != null) {
                double topAnchor = AnchorPaneRelocater.computeTopAnchor(parentLayoutBounds, newLayoutBounds, newLayoutY);
                AnchorPane.setTopAnchor((Node)this.sceneGraphObject, (Double)Double.valueOf(Math.round(topAnchor)));
            }
            if (this.originalBottomAnchor != null) {
                double bottomAnchor = AnchorPaneRelocater.computeBottomAnchor(parentLayoutBounds, newLayoutBounds, newLayoutY);
                AnchorPane.setBottomAnchor((Node)this.sceneGraphObject, (Double)Double.valueOf(Math.round(bottomAnchor)));
            }
        }
    }

    @Override
    public void revertToOriginalLocation() {
        this.sceneGraphObject.setLayoutX(this.originalLayoutX);
        this.sceneGraphObject.setLayoutY(this.originalLayoutY);
        AnchorPane.setLeftAnchor((Node)this.sceneGraphObject, (Double)this.originalLeftAnchor);
        AnchorPane.setRightAnchor((Node)this.sceneGraphObject, (Double)this.originalRightAnchor);
        AnchorPane.setTopAnchor((Node)this.sceneGraphObject, (Double)this.originalTopAnchor);
        AnchorPane.setBottomAnchor((Node)this.sceneGraphObject, (Double)this.originalBottomAnchor);
    }

    @Override
    public List<PropertyName> getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public Object getValue(PropertyName propertyName) {
        assert (propertyName != null);
        assert (this.propertyNames.contains(propertyName)) : "propertyName=" + String.valueOf(propertyName);
        Double result = propertyName.equals(this.layoutXName) ? Double.valueOf(this.sceneGraphObject.getLayoutX()) : (propertyName.equals(this.layoutYName) ? Double.valueOf(this.sceneGraphObject.getLayoutY()) : (propertyName.equals(this.leftAnchorName) ? AnchorPane.getLeftAnchor((Node)this.sceneGraphObject) : (propertyName.equals(this.rightAnchorName) ? AnchorPane.getRightAnchor((Node)this.sceneGraphObject) : (propertyName.equals(this.topAnchorName) ? AnchorPane.getTopAnchor((Node)this.sceneGraphObject) : (propertyName.equals(this.bottomAnchorName) ? AnchorPane.getBottomAnchor((Node)this.sceneGraphObject) : null)))));
        return result;
    }

    @Override
    public Map<PropertyName, Object> getChangeMap() {
        HashMap<PropertyName, Object> result = new HashMap<PropertyName, Object>();
        if (this.originalLeftAnchor == null && this.originalRightAnchor == null) {
            if (!MathUtils.equals(this.sceneGraphObject.getLayoutX(), this.originalLayoutX)) {
                result.put(this.layoutXName, this.sceneGraphObject.getLayoutX());
            }
        } else {
            if (!Objects.equals(AnchorPane.getLeftAnchor((Node)this.sceneGraphObject), this.originalLeftAnchor)) {
                result.put(this.leftAnchorName, AnchorPane.getLeftAnchor((Node)this.sceneGraphObject));
                result.put(this.layoutXName, this.sceneGraphObject.getLayoutX());
            }
            if (!Objects.equals(AnchorPane.getRightAnchor((Node)this.sceneGraphObject), this.originalRightAnchor)) {
                result.put(this.rightAnchorName, AnchorPane.getRightAnchor((Node)this.sceneGraphObject));
            }
        }
        if (this.originalTopAnchor == null && this.originalBottomAnchor == null) {
            if (!MathUtils.equals(this.sceneGraphObject.getLayoutY(), this.originalLayoutY)) {
                result.put(this.layoutYName, this.sceneGraphObject.getLayoutY());
            }
        } else {
            if (!Objects.equals(AnchorPane.getTopAnchor((Node)this.sceneGraphObject), this.originalTopAnchor)) {
                result.put(this.topAnchorName, AnchorPane.getTopAnchor((Node)this.sceneGraphObject));
                result.put(this.layoutYName, this.sceneGraphObject.getLayoutY());
            }
            if (!Objects.equals(AnchorPane.getBottomAnchor((Node)this.sceneGraphObject), this.originalBottomAnchor)) {
                result.put(this.bottomAnchorName, AnchorPane.getBottomAnchor((Node)this.sceneGraphObject));
            }
        }
        return result;
    }

    public static double computeLeftAnchor(Bounds parentBounds, Bounds childBounds, double targetLayoutX) {
        double x0 = parentBounds.getMinX();
        double x1 = parentBounds.getMinX() + targetLayoutX + childBounds.getMinX();
        return x1 - x0;
    }

    public static double computeRightAnchor(Bounds parentBounds, Bounds childBounds, double targetLayoutX) {
        double x0 = parentBounds.getMinX() + targetLayoutX + childBounds.getMaxX();
        double x1 = parentBounds.getMaxX();
        return x1 - x0;
    }

    public static double computeTopAnchor(Bounds parentBounds, Bounds childBounds, double targetLayoutY) {
        double y0 = parentBounds.getMinY();
        double y1 = parentBounds.getMinY() + targetLayoutY + childBounds.getMinY();
        return y1 - y0;
    }

    public static double computeBottomAnchor(Bounds parentBounds, Bounds childBounds, double targetLayoutY) {
        double y0 = parentBounds.getMinY() + targetLayoutY + childBounds.getMaxY();
        double y1 = parentBounds.getMaxY();
        return y1 - y0;
    }
}

