/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.shape;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.AbstractResizer;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.shape.Circle;

public class CircleResizer
extends AbstractResizer<Circle> {
    private final double originalRadius;
    private final PropertyName radiusName = new PropertyName("radius");
    private final List<PropertyName> propertyNames = new ArrayList<PropertyName>();

    public CircleResizer(Circle sceneGraphObject) {
        super(sceneGraphObject);
        this.originalRadius = sceneGraphObject.getRadius();
        this.propertyNames.add(this.radiusName);
    }

    @Override
    public final Bounds computeBounds(double width, double height) {
        double radius = Math.round(Math.min(width, height) / 2.0);
        double minX = ((Circle)this.sceneGraphObject).getCenterX() - radius;
        double minY = ((Circle)this.sceneGraphObject).getCenterY() - radius;
        return new BoundingBox(minX, minY, 2.0 * radius, 2.0 * radius);
    }

    @Override
    public AbstractResizer.Feature getFeature() {
        return AbstractResizer.Feature.SCALING;
    }

    @Override
    public void changeWidth(double width) {
        ((Circle)this.sceneGraphObject).setRadius((double)Math.round(width / 2.0));
    }

    @Override
    public void changeHeight(double height) {
        ((Circle)this.sceneGraphObject).setRadius((double)Math.round(height / 2.0));
    }

    @Override
    public void revertToOriginalSize() {
        ((Circle)this.sceneGraphObject).setRadius(this.originalRadius);
    }

    @Override
    public List<PropertyName> getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public Object getValue(PropertyName propertyName) {
        assert (propertyName != null);
        assert (this.propertyNames.contains(propertyName));
        Double result = propertyName.equals(this.radiusName) ? Double.valueOf(((Circle)this.sceneGraphObject).getRadius()) : null;
        return result;
    }

    @Override
    public Map<PropertyName, Object> getChangeMap() {
        HashMap<PropertyName, Object> result = new HashMap<PropertyName, Object>();
        if (!MathUtils.equals(((Circle)this.sceneGraphObject).getRadius(), this.originalRadius)) {
            result.put(this.radiusName, ((Circle)this.sceneGraphObject).getRadius());
        }
        return result;
    }
}

