/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.tring;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.tring.AbstractNodeTring;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;

public class BorderPaneTring
extends AbstractNodeTring<BorderPane> {
    private final DesignHierarchyMask.Accessory targetAccessory;
    private final BorderPane borderPane = new BorderPane();
    private final Label topLabel = new Label();
    private final Label bottomLabel = new Label();
    private final Label leftLabel = new Label();
    private final Label rightLabel = new Label();
    private final Label centerLabel = new Label();
    private static final String SELECTED = "selected";

    public BorderPaneTring(ContentPanelController contentPanelController, FXOMInstance fxomInstance, DesignHierarchyMask.Accessory targetAccessory) {
        super(contentPanelController, fxomInstance, BorderPane.class);
        assert (targetAccessory == DesignHierarchyMask.Accessory.TOP || targetAccessory == DesignHierarchyMask.Accessory.BOTTOM || targetAccessory == DesignHierarchyMask.Accessory.LEFT || targetAccessory == DesignHierarchyMask.Accessory.RIGHT || targetAccessory == DesignHierarchyMask.Accessory.CENTER);
        this.targetAccessory = targetAccessory;
        this.topLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.topLabel.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.bottomLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.bottomLabel.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.leftLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.leftLabel.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.rightLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.rightLabel.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.centerLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.centerLabel.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.topLabel.setText(DesignHierarchyMask.Accessory.TOP.toString());
        this.bottomLabel.setText(DesignHierarchyMask.Accessory.BOTTOM.toString());
        this.leftLabel.setText(DesignHierarchyMask.Accessory.LEFT.toString());
        this.rightLabel.setText(DesignHierarchyMask.Accessory.RIGHT.toString());
        this.centerLabel.setText(DesignHierarchyMask.Accessory.CENTER.toString());
        this.topLabel.getStyleClass().add((Object)"target-ring");
        this.topLabel.getStyleClass().add((Object)BorderPane.class.getSimpleName());
        this.bottomLabel.getStyleClass().add((Object)"target-ring");
        this.bottomLabel.getStyleClass().add((Object)BorderPane.class.getSimpleName());
        this.leftLabel.getStyleClass().add((Object)"target-ring");
        this.leftLabel.getStyleClass().add((Object)BorderPane.class.getSimpleName());
        this.rightLabel.getStyleClass().add((Object)"target-ring");
        this.rightLabel.getStyleClass().add((Object)BorderPane.class.getSimpleName());
        this.centerLabel.getStyleClass().add((Object)"target-ring");
        this.centerLabel.getStyleClass().add((Object)BorderPane.class.getSimpleName());
        DesignHierarchyMask m = new DesignHierarchyMask(fxomInstance);
        this.topLabel.setVisible(m.getAccessory(DesignHierarchyMask.Accessory.TOP) == null);
        this.bottomLabel.setVisible(m.getAccessory(DesignHierarchyMask.Accessory.BOTTOM) == null);
        this.leftLabel.setVisible(m.getAccessory(DesignHierarchyMask.Accessory.LEFT) == null);
        this.rightLabel.setVisible(m.getAccessory(DesignHierarchyMask.Accessory.RIGHT) == null);
        this.centerLabel.setVisible(m.getAccessory(DesignHierarchyMask.Accessory.CENTER) == null);
        this.borderPane.setTop((Node)this.topLabel);
        this.borderPane.setBottom((Node)this.bottomLabel);
        this.borderPane.setLeft((Node)this.leftLabel);
        this.borderPane.setRight((Node)this.rightLabel);
        this.borderPane.setCenter((Node)this.centerLabel);
        this.borderPane.setMinWidth(Double.NEGATIVE_INFINITY);
        this.borderPane.setMinHeight(Double.NEGATIVE_INFINITY);
        this.borderPane.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.borderPane.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.getRootNode().getChildren().add(0, (Object)this.borderPane);
    }

    public static Bounds computeCenterBounds(BorderPane sceneGraphObject) {
        Bounds b = sceneGraphObject.getLayoutBounds();
        double x0 = b.getMinX();
        double x3 = b.getMaxX();
        double x1 = x0 + (x3 - x0) * 0.25;
        double x2 = x0 + (x3 - x0) * 0.75;
        double y0 = b.getMinY();
        double y3 = b.getMaxY();
        double y1 = y0 + (y3 - y0) * 0.25;
        double y2 = y0 + (y3 - y0) * 0.75;
        return new BoundingBox(x1, y1, x2 - x1, y2 - y1);
    }

    public static Bounds computeAreaBounds(Bounds lb, Bounds cb, DesignHierarchyMask.Accessory area) {
        double xmax;
        double ymin;
        double xmin;
        assert (lb != null);
        assert (cb != null);
        return new BoundingBox(xmin, ymin, xmax - xmin, (switch (area.name()) {
            case "TOP" -> {
                xmin = lb.getMinX();
                ymin = lb.getMinY();
                xmax = lb.getMaxX();
                yield cb.getMinY();
            }
            case "BOTTOM" -> {
                xmin = lb.getMinX();
                ymin = cb.getMaxY();
                xmax = lb.getMaxX();
                yield lb.getMaxY();
            }
            case "LEFT" -> {
                xmin = lb.getMinX();
                ymin = cb.getMinY();
                xmax = cb.getMinX();
                yield cb.getMaxY();
            }
            case "RIGHT" -> {
                xmin = cb.getMaxX();
                ymin = cb.getMinY();
                xmax = lb.getMaxX();
                yield cb.getMaxY();
            }
            case "CENTER" -> {
                xmin = cb.getMinX();
                ymin = cb.getMinY();
                xmax = cb.getMaxX();
                yield cb.getMaxY();
            }
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unexpected area " + String.valueOf(area)));
                }
                xmin = cb.getMinX();
                ymin = cb.getMinY();
                xmax = cb.getMaxX();
                yield cb.getMaxY();
            }
        }) - ymin);
    }

    @Override
    protected void layoutDecoration() {
        super.layoutDecoration();
        Bounds layoutBounds = ((BorderPane)this.getSceneGraphObject()).getLayoutBounds();
        this.borderPane.setPrefWidth(layoutBounds.getWidth());
        this.borderPane.setPrefHeight(layoutBounds.getHeight());
        Bounds centerBounds = BorderPaneTring.computeCenterBounds((BorderPane)this.getSceneGraphObject());
        this.centerLabel.setPrefSize(centerBounds.getWidth(), centerBounds.getHeight());
        Bounds topBounds = BorderPaneTring.computeAreaBounds(layoutBounds, centerBounds, DesignHierarchyMask.Accessory.TOP);
        this.topLabel.setPrefSize(topBounds.getWidth(), topBounds.getHeight());
        Bounds bottomBounds = BorderPaneTring.computeAreaBounds(layoutBounds, centerBounds, DesignHierarchyMask.Accessory.BOTTOM);
        this.bottomLabel.setPrefSize(bottomBounds.getWidth(), bottomBounds.getHeight());
        Bounds leftBounds = BorderPaneTring.computeAreaBounds(layoutBounds, centerBounds, DesignHierarchyMask.Accessory.LEFT);
        this.leftLabel.setPrefSize(leftBounds.getWidth(), leftBounds.getHeight());
        Bounds rightBounds = BorderPaneTring.computeAreaBounds(layoutBounds, centerBounds, DesignHierarchyMask.Accessory.RIGHT);
        this.rightLabel.setPrefSize(rightBounds.getWidth(), rightBounds.getHeight());
        Label targetLabel = switch (this.targetAccessory.name()) {
            case "TOP" -> this.topLabel;
            case "BOTTOM" -> this.bottomLabel;
            case "LEFT" -> this.leftLabel;
            case "RIGHT" -> this.rightLabel;
            case "CENTER" -> this.centerLabel;
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                yield this.centerLabel;
            }
        };
        BorderPaneTring.setupSelectedStyleClass(this.topLabel, this.topLabel == targetLabel);
        BorderPaneTring.setupSelectedStyleClass(this.bottomLabel, this.bottomLabel == targetLabel);
        BorderPaneTring.setupSelectedStyleClass(this.leftLabel, this.leftLabel == targetLabel);
        BorderPaneTring.setupSelectedStyleClass(this.rightLabel, this.rightLabel == targetLabel);
        BorderPaneTring.setupSelectedStyleClass(this.centerLabel, this.centerLabel == targetLabel);
        this.borderPane.getTransforms().clear();
        this.borderPane.getTransforms().add((Object)this.getSceneGraphObjectToDecorationTransform());
    }

    private static void setupSelectedStyleClass(Label label, boolean selected) {
        ObservableList styleClass = label.getStyleClass();
        if (selected) {
            if (!styleClass.contains(SELECTED)) {
                styleClass.add(SELECTED);
            }
        } else if (styleClass.contains(SELECTED)) {
            styleClass.remove(SELECTED);
        }
    }
}

