/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.tring;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.tring.AbstractNodeTring;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.shape.Line;

public class HBoxTring
extends AbstractNodeTring<HBox> {
    private final int targetIndex;
    private final Line crackLine = new Line();

    public HBoxTring(ContentPanelController contentPanelController, FXOMInstance fxomInstance, int targetIndex) {
        super(contentPanelController, fxomInstance, HBox.class);
        assert (targetIndex >= -1);
        this.targetIndex = targetIndex;
        this.crackLine.getStyleClass().add((Object)"target-crack");
        this.crackLine.setMouseTransparent(true);
        this.getRootNode().getChildren().add(0, (Object)this.crackLine);
    }

    @Override
    protected void layoutDecoration() {
        super.layoutDecoration();
        HBox hbox = (HBox)this.getSceneGraphObject();
        int childCount = hbox.getChildren().size();
        if (childCount == 0) {
            this.crackLine.setVisible(false);
        } else {
            double crackX;
            ObservableList children = hbox.getChildren();
            if (this.targetIndex == -1) {
                Node child = (Node)children.get(childCount - 1);
                cb = child.localToParent(child.getLayoutBounds());
                crackX = cb.getMaxX();
            } else {
                Node child = (Node)children.get(this.targetIndex);
                cb = child.localToParent(child.getLayoutBounds());
                crackX = cb.getMinX();
            }
            boolean snapToPixel = true;
            Bounds b = ((HBox)this.getSceneGraphObject()).getLayoutBounds();
            Point2D p0 = this.sceneGraphObjectToDecoration(crackX, b.getMinY(), true);
            Point2D p1 = this.sceneGraphObjectToDecoration(crackX, b.getMaxY(), true);
            this.crackLine.setVisible(true);
            this.crackLine.setStartX(p0.getX());
            this.crackLine.setStartY(p0.getY());
            this.crackLine.setEndX(p1.getX());
            this.crackLine.setEndY(p1.getY());
        }
    }
}

