/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture;

import com.oracle.javafx.scenebuilder.kit.editor.drag.DragController;
import com.oracle.javafx.scenebuilder.kit.editor.drag.source.AbstractDragSource;
import com.oracle.javafx.scenebuilder.kit.editor.drag.source.ExternalDragSource;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.AbstractDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.AccessoryDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.ContainerXYDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.ImageViewDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.RootDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.AbstractDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.BorderPaneDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.AbstractGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.MovingGuideController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.util.BoundsUtils;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.input.DragEvent;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.stage.Window;

public class DragGesture
extends AbstractGesture {
    private static final Logger LOG = Logger.getLogger(DragGesture.class.getName());
    private final double MARGIN = 14.0;
    private final DragController dragController;
    private final Set<FXOMObject> pickExcludes = new HashSet<FXOMObject>();
    private DragEvent dragEnteredEvent;
    private DragEvent lastDragEvent;
    private AbstractGesture.Observer observer;
    private boolean willReceiveDragDone;
    private boolean shouldInvokeEnd;
    private FXOMObject hitParent;
    private DesignHierarchyMask hitParentMask;
    private MovingGuideController movingGuideController;
    private boolean guidesDisabled;
    private Node shadow;

    public DragGesture(ContentPanelController contentPanelController) {
        super(contentPanelController);
        this.dragController = contentPanelController.getEditorController().getDragController();
    }

    @Override
    public void start(InputEvent e, AbstractGesture.Observer observer) {
        assert (e != null);
        assert (e instanceof DragEvent);
        assert (e.getEventType() == DragEvent.DRAG_ENTERED);
        Pane glassLayer = this.contentPanelController.getGlassLayer();
        assert (glassLayer.getOnDragEntered() == null);
        assert (glassLayer.getOnDragOver() == null);
        assert (glassLayer.getOnDragExited() == null);
        assert (glassLayer.getOnDragDropped() == null);
        assert (glassLayer.getOnDragDone() == null);
        assert (glassLayer.getOnKeyPressed() == null);
        glassLayer.setOnDragEntered(e1 -> {
            this.lastDragEvent = e1;
            this.dragEnteredGlassLayer();
        });
        glassLayer.setOnDragOver(e1 -> {
            this.lastDragEvent = e1;
            this.dragOverGlassLayer();
        });
        glassLayer.setOnDragExited(e1 -> {
            this.lastDragEvent = e1;
            this.dragExitedGlassLayer();
        });
        glassLayer.setOnDragDropped(arg_0 -> this.lambda$start$3((Node)glassLayer, arg_0));
        glassLayer.setOnDragDone(e1 -> {
            this.lastDragEvent = e1;
            this.dragDoneOnGlassLayer();
            e1.getDragboard().clear();
            e1.consume();
        });
        glassLayer.setOnKeyPressed(e1 -> this.handleKeyPressed((KeyEvent)e1));
        this.lastDragEvent = this.dragEnteredEvent = (DragEvent)e;
        this.observer = observer;
        this.shouldInvokeEnd = this.willReceiveDragDone = this.dragEnteredEvent.getGestureSource() == glassLayer;
        assert (this.hitParent == null);
        assert (this.hitParentMask == null);
        assert (this.shadow == null);
        this.setupMovingGuideController();
        this.dragEnteredGlassLayer();
    }

    private void dragEnteredGlassLayer() {
        if (this.dragController.getDragSource() == null) {
            FXOMDocument fxomDocument = this.contentPanelController.getEditorController().getFxomDocument();
            Window ownerWindow = this.contentPanelController.getPanelRoot().getScene().getWindow();
            ExternalDragSource dragSource = new ExternalDragSource(this.lastDragEvent.getDragboard(), fxomDocument, ownerWindow);
            assert (dragSource.isAcceptable());
            this.dragController.begin(dragSource);
            this.shouldInvokeEnd = true;
        }
        this.pickExcludes.clear();
        this.pickExcludes.addAll(this.dragController.getDragSource().getDraggedObjects());
        this.showShadow();
        this.dragOverGlassLayer();
    }

    private void dragOverGlassLayer() {
        if (this.lastDragEvent.isDropCompleted()) {
            LOG.log(Level.WARNING, "Ignored dragOver() after dragDropped()");
        } else {
            this.dragOverGlassLayerBis();
        }
    }

    private void dragOverGlassLayerBis() {
        double hitY;
        double hitX = this.lastDragEvent.getSceneX();
        FXOMObject hitObject = this.contentPanelController.pick(hitX, hitY = this.lastDragEvent.getSceneY(), this.pickExcludes);
        if (hitObject == null) {
            FXOMDocument fxomDocument = this.contentPanelController.getEditorController().getFxomDocument();
            hitObject = fxomDocument.getFxomRoot();
        }
        if (hitObject == null) {
            this.dragOverEmptyDocument();
        } else {
            this.dragOverHitObject(hitObject);
        }
    }

    private void dragOverEmptyDocument() {
        this.dragController.setDropTarget(new RootDropTarget());
        this.lastDragEvent.acceptTransferModes(this.dragController.getAcceptedTransferModes());
        this.updateShadow(this.lastDragEvent.getSceneX(), this.lastDragEvent.getSceneY());
    }

    private void dragOverHitObject(FXOMObject hitObject) {
        double guidedY;
        double guidedX;
        DesignHierarchyMask mp;
        FXOMObject hitObjectParent;
        AbstractDriver driver;
        assert (hitObject != null);
        FXOMDocument fxomDocument = this.contentPanelController.getEditorController().getFxomDocument();
        AbstractDragSource dragSource = this.dragController.getDragSource();
        DesignHierarchyMask m = new DesignHierarchyMask(hitObject);
        double hitX = this.lastDragEvent.getSceneX();
        double hitY = this.lastDragEvent.getSceneY();
        assert (fxomDocument != null);
        assert (dragSource != null);
        AbstractDropTarget dropTarget = null;
        FXOMObject newHitParent = null;
        DesignHierarchyMask newHitParentMask = null;
        boolean hitImageView = hitObject.getSceneGraphObject() instanceof ImageView;
        boolean externalDragSource = dragSource instanceof ExternalDragSource;
        if (dragSource.isSingleImageViewOnly() && hitImageView && externalDragSource) {
            dropTarget = new ImageViewDropTarget(hitObject);
            newHitParent = hitObject;
            newHitParentMask = m;
        }
        if (dropTarget == null && dragSource.isSingleTooltipOnly()) {
            assert (hitObject instanceof FXOMInstance);
            dropTarget = new AccessoryDropTarget((FXOMInstance)hitObject, DesignHierarchyMask.Accessory.TOOLTIP);
            newHitParent = hitObject;
            newHitParentMask = m;
        }
        if (dropTarget == null && dragSource.isSingleContextMenuOnly()) {
            assert (hitObject instanceof FXOMInstance);
            dropTarget = new AccessoryDropTarget((FXOMInstance)hitObject, DesignHierarchyMask.Accessory.CONTEXT_MENU);
            newHitParent = hitObject;
            newHitParentMask = m;
        }
        if (dropTarget == null && hitObject.getSceneGraphObject() instanceof BorderPane) {
            driver = this.contentPanelController.lookupDriver(hitObject);
            assert (driver instanceof BorderPaneDriver);
            dropTarget = driver.makeDropTarget(hitObject, hitX, hitY);
            newHitParent = hitObject;
            newHitParentMask = m;
        }
        if (dropTarget == null && m.isAcceptingSubComponent()) {
            driver = this.contentPanelController.lookupDriver(hitObject);
            dropTarget = driver.makeDropTarget(hitObject, hitX, hitY);
            newHitParent = hitObject;
            newHitParentMask = m;
        }
        if (dropTarget == null && m.isAcceptingAccessory(DesignHierarchyMask.Accessory.CONTENT)) {
            assert (hitObject instanceof FXOMInstance);
            dropTarget = new AccessoryDropTarget((FXOMInstance)hitObject, DesignHierarchyMask.Accessory.CONTENT);
            newHitParent = hitObject;
            newHitParentMask = m;
        }
        if (dropTarget == null && (hitObjectParent = hitObject.getParentObject()) != null && (mp = new DesignHierarchyMask(hitObjectParent)).isAcceptingSubComponent()) {
            AbstractDriver driver2 = this.contentPanelController.lookupDriver(hitObjectParent);
            dropTarget = driver2.makeDropTarget(hitObjectParent, hitX, hitY);
            newHitParent = hitObjectParent;
            newHitParentMask = mp;
        }
        if (newHitParent != this.hitParent) {
            this.hitParent = newHitParent;
            this.hitParentMask = newHitParentMask;
            if (this.hitParent == null) {
                assert (this.hitParentMask == null);
                this.movingGuideController.clearSampleBounds();
            } else {
                assert (this.hitParentMask != null);
                if (this.hitParentMask.isFreeChildPositioning() && dragSource.isNodeOnly()) {
                    this.populateMovingGuideController();
                } else {
                    this.movingGuideController.clearSampleBounds();
                }
            }
        }
        if (this.movingGuideController.hasSampleBounds() && !this.guidesDisabled) {
            this.updateShadow(hitX, hitY);
            Bounds shadowBounds = this.shadow.getLayoutBounds();
            Bounds shadowBoundsInScene = this.shadow.localToScene(shadowBounds, true);
            this.movingGuideController.match(shadowBoundsInScene);
            guidedX = hitX + this.movingGuideController.getSuggestedDX();
            guidedY = hitY + this.movingGuideController.getSuggestedDY();
        } else {
            guidedX = hitX;
            guidedY = hitY;
        }
        this.updateShadow(guidedX, guidedY);
        if (!MathUtils.equals(guidedX, hitX) || !MathUtils.equals(guidedY, hitY)) {
            assert (dropTarget != null);
            assert (dropTarget instanceof ContainerXYDropTarget);
            AbstractDriver driver3 = this.contentPanelController.lookupDriver(dropTarget.getTargetObject());
            dropTarget = driver3.makeDropTarget(this.hitParent, guidedX, guidedY);
            assert (dropTarget instanceof ContainerXYDropTarget);
        }
        this.dragController.setDropTarget(dropTarget);
        this.lastDragEvent.acceptTransferModes(this.dragController.getAcceptedTransferModes());
    }

    private void dragExitedGlassLayer() {
        this.dragController.setDropTarget(null);
        this.hideShadow();
        this.movingGuideController.clearSampleBounds();
        if (!this.willReceiveDragDone) {
            this.dragDoneOnGlassLayer();
        }
    }

    private void dragDroppedOnGlassLayer() {
        this.lastDragEvent.setDropCompleted(true);
        this.dragController.commit();
        this.contentPanelController.getGlassLayer().requestFocus();
    }

    private void dragDoneOnGlassLayer() {
        if (this.shouldInvokeEnd) {
            this.dragController.end();
        }
        this.performTermination();
    }

    private void handleKeyPressed(KeyEvent e) {
        if (e.getCode() == KeyCode.ESCAPE) {
            this.dragExitedGlassLayer();
            if (this.willReceiveDragDone) {
                this.dragDoneOnGlassLayer();
            }
        } else if (e.getCode() == KeyCode.ALT) {
            EventType eventType = e.getEventType();
            if (eventType == KeyEvent.KEY_PRESSED) {
                this.guidesDisabled = true;
            } else if (eventType == KeyEvent.KEY_RELEASED) {
                this.guidesDisabled = false;
            }
            this.dragOverGlassLayer();
        }
    }

    private void performTermination() {
        Pane glassLayer = this.contentPanelController.getGlassLayer();
        glassLayer.setOnDragEntered(null);
        glassLayer.setOnDragOver(null);
        glassLayer.setOnDragExited(null);
        glassLayer.setOnDragDropped(null);
        glassLayer.setOnDragDone(null);
        glassLayer.setOnKeyPressed(null);
        this.dismantleMovingGuideController();
        this.observer.gestureDidTerminate(this);
        this.observer = null;
        this.dragEnteredEvent = null;
        this.lastDragEvent = null;
        this.shouldInvokeEnd = false;
        this.hitParent = null;
        this.hitParentMask = null;
        assert (this.shadow == null);
    }

    private void showShadow() {
        assert (this.shadow == null);
        this.shadow = this.dragController.getDragSource().makeShadow();
        this.shadow.setMouseTransparent(true);
        this.contentPanelController.getRudderLayer().getChildren().add((Object)this.shadow);
        this.updateShadow(0.0, 0.0);
    }

    private void updateShadow(double hitX, double hitY) {
        assert (this.shadow != null);
        Group rudderLayer = this.contentPanelController.getRudderLayer();
        Point2D p = rudderLayer.sceneToLocal(hitX, hitY, true);
        this.shadow.setLayoutX(p.getX());
        this.shadow.setLayoutY(p.getY());
    }

    private void hideShadow() {
        assert (this.shadow != null);
        this.contentPanelController.getRudderLayer().getChildren().remove((Object)this.shadow);
        this.shadow = null;
    }

    private void setupMovingGuideController() {
        Bounds scope = this.contentPanelController.getWorkspacePane().getLayoutBounds();
        Bounds scopeInScene = this.contentPanelController.getWorkspacePane().localToScene(scope, true);
        this.movingGuideController = new MovingGuideController(this.contentPanelController.getGuidesColor(), scopeInScene);
        Group rudderLayer = this.contentPanelController.getRudderLayer();
        Group guideGroup = this.movingGuideController.getGuideGroup();
        assert (guideGroup.isMouseTransparent());
        rudderLayer.getChildren().add((Object)guideGroup);
    }

    private void populateMovingGuideController() {
        assert (this.hitParentMask != null);
        assert (this.hitParentMask.isFreeChildPositioning());
        this.movingGuideController.clearSampleBounds();
        int c = this.hitParentMask.getSubComponentCount();
        for (int i = 0; i < c; ++i) {
            FXOMObject child = this.hitParentMask.getSubComponentAtIndex(i);
            boolean isNode = child.getSceneGraphObject() instanceof Node;
            if (this.pickExcludes.contains(child) || !isNode) continue;
            Node childNode = (Node)child.getSceneGraphObject();
            this.movingGuideController.addSampleBounds(childNode);
        }
        assert (this.hitParent.getSceneGraphObject() instanceof Node);
        Node hitParentNode = (Node)this.hitParent.getSceneGraphObject();
        this.movingGuideController.addSampleBounds(hitParentNode);
        Bounds hitParentBounds = hitParentNode.getLayoutBounds();
        Bounds insetBounds = BoundsUtils.inset(hitParentBounds, 14.0, 14.0);
        if (!insetBounds.isEmpty()) {
            Bounds insetBoundsInScene = hitParentNode.localToScene(insetBounds, true);
            this.movingGuideController.addSampleBounds(insetBoundsInScene, false);
        }
    }

    private void dismantleMovingGuideController() {
        assert (this.movingGuideController != null);
        Group guideGroup = this.movingGuideController.getGuideGroup();
        Group rudderLayer = this.contentPanelController.getRudderLayer();
        assert (rudderLayer.getChildren().contains((Object)guideGroup));
        rudderLayer.getChildren().remove((Object)guideGroup);
        this.movingGuideController = null;
    }

    private /* synthetic */ void lambda$start$3(Node glassLayer, DragEvent e1) {
        this.lastDragEvent = e1;
        this.dragDroppedOnGlassLayer();
        e1.consume();
        glassLayer.setOnDragOver(null);
    }
}

