/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.AbstractGesture;
import javafx.scene.Node;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;

public abstract class AbstractMouseGesture
extends AbstractGesture {
    private MouseEvent mousePressedEvent;
    private MouseEvent lastMouseEvent;
    private AbstractGesture.Observer observer;
    private boolean mouseDidDrag;

    protected abstract void mousePressed();

    protected abstract void mouseDragStarted();

    protected abstract void mouseDragged();

    protected abstract void mouseDragEnded();

    protected abstract void mouseReleased();

    protected abstract void keyEvent(KeyEvent var1);

    protected abstract void userDidCancel();

    public AbstractMouseGesture(ContentPanelController contentPanelController) {
        super(contentPanelController);
    }

    protected MouseEvent getMousePressedEvent() {
        return this.mousePressedEvent;
    }

    protected MouseEvent getLastMouseEvent() {
        return this.lastMouseEvent;
    }

    protected boolean isStarted() {
        return this.observer != null;
    }

    protected boolean isMouseDidDrag() {
        return this.mouseDidDrag;
    }

    @Override
    public void start(InputEvent e, AbstractGesture.Observer observer) {
        assert (e != null);
        assert (e instanceof MouseEvent);
        assert (e.getEventType() == MouseEvent.MOUSE_PRESSED);
        assert (observer != null);
        assert (!this.mouseDidDrag);
        Pane glassLayer = this.contentPanelController.getGlassLayer();
        assert (glassLayer.getOnDragDetected() == null);
        assert (glassLayer.getOnMouseDragged() == null);
        assert (glassLayer.getOnMouseReleased() == null);
        assert (glassLayer.getOnKeyPressed() == null);
        assert (glassLayer.getOnKeyReleased() == null);
        glassLayer.setOnDragDetected(arg_0 -> this.lambda$start$0((Node)glassLayer, arg_0));
        glassLayer.setOnMouseReleased(arg_0 -> this.lambda$start$2((Node)glassLayer, arg_0));
        glassLayer.setOnKeyPressed(e1 -> this.handleKeyPressed((KeyEvent)e1));
        glassLayer.setOnKeyReleased(e1 -> this.handleKeyReleased((KeyEvent)e1));
        this.lastMouseEvent = this.mousePressedEvent = (MouseEvent)e;
        this.observer = observer;
        try {
            this.mousePressed();
        }
        catch (RuntimeException x) {
            this.performTermination();
            throw x;
        }
    }

    private void handleKeyPressed(KeyEvent e) {
        if (e.getCode() == KeyCode.ESCAPE) {
            if (this.mouseDidDrag) {
                this.contentPanelController.getGlassLayer().setOnMouseDragged(null);
            }
            this.userDidCancel();
            this.performTermination();
        } else {
            this.keyEvent(e);
        }
    }

    private void handleKeyReleased(KeyEvent e) {
        this.keyEvent(e);
    }

    private void performTermination() {
        Pane glassLayer = this.contentPanelController.getGlassLayer();
        glassLayer.setOnDragDetected(null);
        glassLayer.setOnMouseReleased(null);
        glassLayer.setOnKeyPressed(null);
        glassLayer.setOnKeyReleased(null);
        try {
            this.observer.gestureDidTerminate(this);
        }
        finally {
            this.observer = null;
            this.mousePressedEvent = null;
            this.lastMouseEvent = null;
            this.mouseDidDrag = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$start$2(Node glassLayer, MouseEvent e1) {
        this.lastMouseEvent = e1;
        try {
            if (this.mouseDidDrag) {
                try {
                    this.mouseDragEnded();
                }
                finally {
                    glassLayer.setOnMouseDragged(null);
                }
            }
            this.mouseReleased();
        }
        finally {
            this.performTermination();
        }
    }

    private /* synthetic */ void lambda$start$0(Node glassLayer, MouseEvent e1) {
        this.lastMouseEvent = e1;
        this.mouseDidDrag = true;
        this.mouseDragStarted();
        glassLayer.setOnMouseDragged(e2 -> {
            this.lastMouseEvent = e2;
            this.mouseDragged();
        });
    }
}

