/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ModifyObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.HudWindowController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.SplitPaneDesignInfoX;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.AbstractMouseGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.util.CardinalPoint;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javafx.scene.input.KeyEvent;

public class AdjustDividerGesture
extends AbstractMouseGesture {
    private final FXOMInstance splitPaneInstance;
    private final int dividerIndex;
    private final SplitPaneDesignInfoX di = new SplitPaneDesignInfoX();
    private double[] originalDividerPositions;
    private static final PropertyName dividerPositionsName = new PropertyName("dividerPositions");

    public AdjustDividerGesture(ContentPanelController contentPanelController, FXOMInstance splitPaneInstance, int dividerIndex) {
        super(contentPanelController);
        assert (splitPaneInstance.getSceneGraphObject() instanceof SplitPane);
        this.splitPaneInstance = splitPaneInstance;
        this.dividerIndex = dividerIndex;
    }

    @Override
    protected void mousePressed() {
    }

    @Override
    protected void mouseDragStarted() {
        this.originalDividerPositions = this.getSplitPane().getDividerPositions();
        this.setupAndOpenHudWindow();
        this.contentPanelController.getHandleLayer().setVisible(false);
        this.mouseDragged();
    }

    @Override
    protected void mouseDragged() {
        SplitPane splitPane = (SplitPane)this.splitPaneInstance.getSceneGraphObject();
        double sceneX = this.getLastMouseEvent().getSceneX();
        double sceneY = this.getLastMouseEvent().getSceneY();
        double[] newDividerPositions = this.di.simulateDividerMove(splitPane, this.dividerIndex, sceneX, sceneY);
        splitPane.setDividerPositions(newDividerPositions);
        splitPane.layout();
        this.updateHudWindow();
        this.contentPanelController.getHudWindowController().updatePopupLocation();
    }

    @Override
    protected void mouseDragEnded() {
        ArrayList<Double> newDividerPositions = new ArrayList<Double>();
        for (double p : this.getSplitPane().getDividerPositions()) {
            newDividerPositions.add(p);
        }
        this.userDidCancel();
        Metadata metadata = Metadata.getMetadata();
        EditorController editorController = this.contentPanelController.getEditorController();
        ValuePropertyMetadata dividerPositionsMeta = metadata.queryValueProperty(this.splitPaneInstance, dividerPositionsName);
        ModifyObjectJob j = new ModifyObjectJob(this.splitPaneInstance, dividerPositionsMeta, newDividerPositions, editorController);
        if (j.isExecutable()) {
            editorController.getJobManager().push(j);
        }
    }

    @Override
    protected void mouseReleased() {
    }

    @Override
    protected void keyEvent(KeyEvent e) {
    }

    @Override
    protected void userDidCancel() {
        this.getSplitPane().setDividerPositions(this.originalDividerPositions);
        this.contentPanelController.getHudWindowController().closeWindow();
        this.contentPanelController.getHandleLayer().setVisible(true);
        this.getSplitPane().layout();
    }

    private SplitPane getSplitPane() {
        assert (this.splitPaneInstance.getSceneGraphObject() instanceof SplitPane);
        return (SplitPane)this.splitPaneInstance.getSceneGraphObject();
    }

    private void setupAndOpenHudWindow() {
        HudWindowController hudWindowController = this.contentPanelController.getHudWindowController();
        hudWindowController.setRowCount(1);
        hudWindowController.setNameAtRowIndex("dividerPosition", 0);
        this.updateHudWindow();
        hudWindowController.setRelativePosition(switch (this.getSplitPane().getOrientation()) {
            default -> CardinalPoint.S;
            case Orientation.VERTICAL -> CardinalPoint.E;
        });
        hudWindowController.openWindow((Node)this.getSplitPane());
    }

    private void updateHudWindow() {
        HudWindowController hudWindowController = this.contentPanelController.getHudWindowController();
        double dividerPosition = this.getSplitPane().getDividerPositions()[this.dividerIndex];
        String str = String.format("%.2f %%", dividerPosition * 100.0);
        hudWindowController.setValueAtRowIndex(str, 0);
    }
}

