/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ModifyObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.HudWindowController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.curve.AbstractCurveEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles.AbstractHandles;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.AbstractMouseGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.EditCurveGuideController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.util.CardinalPoint;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.shape.Circle;

public class EditCurveGesture
extends AbstractMouseGesture {
    private final FXOMInstance fxomInstance;
    private final AbstractCurveEditor<?> editor;
    private EditCurveGuideController controller;
    private boolean straightAnglesMode = false;
    private static final PropertyName POINTS_NAME = new PropertyName("points");
    private static final int MAX_POINTS_HUD = 24;
    private final EnumMap<Tunable, Integer> tunableMap = new EnumMap(Tunable.class);
    private boolean inserted;
    private boolean removed;
    private Point2D insertionPoint;

    public EditCurveGesture(ContentPanelController contentPanelController, FXOMInstance fxomInstance, Tunable tunable) {
        super(contentPanelController);
        assert (contentPanelController.lookupDriver(fxomInstance) != null);
        assert (fxomInstance.getSceneGraphObject() instanceof Node);
        this.fxomInstance = fxomInstance;
        this.tunableMap.put(tunable, -1);
        this.editor = contentPanelController.lookupDriver(fxomInstance).makeCurveEditor(fxomInstance);
    }

    public EnumMap<Tunable, Integer> getTunableMap() {
        return this.tunableMap;
    }

    @Override
    protected void mousePressed() {
        MouseEvent mousePressedEvent = this.getMousePressedEvent();
        this.inserted = false;
        this.removed = false;
        if (this.tunableMap.containsKey((Object)Tunable.SIDE) && mousePressedEvent.isShortcutDown()) {
            double hitX = mousePressedEvent.getSceneX();
            double hitY = mousePressedEvent.getSceneY();
            this.insertionPoint = this.editor.getSceneGraphObject().sceneToLocal(hitX, hitY, true);
            this.inserted = true;
        } else if (this.tunableMap.containsKey((Object)Tunable.VERTEX) && mousePressedEvent.isShortcutDown()) {
            this.removed = true;
        }
        this.updateHandle(true);
    }

    @Override
    protected void mouseDragStarted() {
        assert (this.editor != null);
        assert (this.editor.getSceneGraphObject() == this.fxomInstance.getSceneGraphObject());
        this.controller = this.editor.createController(this.tunableMap);
        double hitX = this.getLastMouseEvent().getSceneX();
        double hitY = this.getLastMouseEvent().getSceneY();
        HashSet<FXOMObject> pickExcludes = new HashSet<FXOMObject>();
        pickExcludes.add(this.fxomInstance);
        FXOMObject hitParent = this.contentPanelController.pick(hitX, hitY, pickExcludes);
        if (hitParent == null) {
            FXOMDocument fxomDocument = this.contentPanelController.getEditorController().getFxomDocument();
            hitParent = fxomDocument.getFxomRoot();
        }
        assert (hitParent != null);
        DesignHierarchyMask hitParentMask = new DesignHierarchyMask(hitParent);
        assert (hitParentMask.isFreeChildPositioning());
        int c = hitParentMask.getSubComponentCount();
        for (int i = 0; i < c; ++i) {
            FXOMObject child = hitParentMask.getSubComponentAtIndex(i);
            boolean isNode = child.getSceneGraphObject() instanceof Node;
            if (!isNode || child == this.fxomInstance) continue;
            Node childNode = (Node)child.getSceneGraphObject();
            this.controller.addSampleBounds(childNode);
        }
        assert (hitParent.getSceneGraphObject() instanceof Node);
        Node hitParentNode = (Node)hitParent.getSceneGraphObject();
        this.controller.addSampleBounds(hitParentNode);
        this.setupAndOpenHudWindow();
        this.mouseDragged();
    }

    @Override
    protected void mouseDragged() {
        this.contentPanelController.getHudWindowController().updatePopupLocation();
        this.updateCurvePosition();
    }

    @Override
    protected void mouseDragEnded() {
        EditorController editorController;
        Map<PropertyName, Object> changeMap = this.editor.getChangeMap();
        ArrayList<Double> points = null;
        if (this.editor.getPoints() != null) {
            points = new ArrayList<Double>(this.editor.getPoints());
        }
        this.userDidCancel();
        Metadata metadata = Metadata.getMetadata();
        HashMap<ValuePropertyMetadata, Object> metaValueMap = new HashMap<ValuePropertyMetadata, Object>();
        for (Map.Entry<PropertyName, Object> entry : changeMap.entrySet()) {
            ValuePropertyMetadata valuePropertyMetadata = metadata.queryValueProperty(this.fxomInstance, entry.getKey());
            assert (valuePropertyMetadata != null);
            metaValueMap.put(valuePropertyMetadata, entry.getValue());
        }
        if (!changeMap.isEmpty()) {
            editorController = this.contentPanelController.getEditorController();
            for (Map.Entry entry : metaValueMap.entrySet()) {
                ModifyObjectJob job = new ModifyObjectJob(this.fxomInstance, (ValuePropertyMetadata)entry.getKey(), entry.getValue(), editorController, "Edit");
                if (!job.isExecutable()) continue;
                editorController.getJobManager().push(job);
            }
        }
        if (points != null) {
            editorController = this.contentPanelController.getEditorController();
            ValuePropertyMetadata valuePropertyMetadata = metadata.queryValueProperty(this.fxomInstance, POINTS_NAME);
            ModifyObjectJob modifyObjectJob = new ModifyObjectJob(this.fxomInstance, valuePropertyMetadata, points, editorController);
            if (modifyObjectJob.isExecutable()) {
                editorController.getJobManager().push(modifyObjectJob);
            }
        }
    }

    @Override
    protected void mouseReleased() {
        this.updateHandle(false);
        if (this.removed || this.inserted) {
            if (this.removed) {
                this.editor.removePoint(this.tunableMap);
            } else if (this.inserted) {
                this.editor.addPoint(this.tunableMap, this.insertionPoint.getX(), this.insertionPoint.getY());
            }
            List points = null;
            if (this.editor.getPoints() != null) {
                points = this.editor.getPoints().stream().collect(Collectors.toList());
            }
            this.userDidCancel();
            Metadata metadata = Metadata.getMetadata();
            if (points != null) {
                EditorController editorController = this.contentPanelController.getEditorController();
                ValuePropertyMetadata pointsMeta = metadata.queryValueProperty(this.fxomInstance, POINTS_NAME);
                ModifyObjectJob job = new ModifyObjectJob(this.fxomInstance, pointsMeta, points, editorController);
                if (job.isExecutable()) {
                    editorController.getJobManager().push(job);
                }
            }
        }
    }

    @Override
    protected void keyEvent(KeyEvent e) {
        if (e.getCode() == KeyCode.SHIFT) {
            if (e.getEventType() == KeyEvent.KEY_PRESSED) {
                this.straightAnglesMode = true;
            } else if (e.getEventType() == KeyEvent.KEY_RELEASED) {
                this.straightAnglesMode = false;
            }
            this.mouseDragged();
        }
    }

    @Override
    protected void userDidCancel() {
        this.editor.revertToOriginalState();
        this.editor.getSceneGraphObject().getParent().layout();
        this.contentPanelController.getHudWindowController().closeWindow();
    }

    private void updateCurvePosition() {
        if (this.editor == null || this.controller == null) {
            return;
        }
        Object sceneGraphObject = this.editor.getSceneGraphObject();
        sceneGraphObject.getParent().layout();
        double currentSceneX = this.getLastMouseEvent().getSceneX();
        double currentSceneY = this.getLastMouseEvent().getSceneY();
        Point2D current = new Point2D(currentSceneX, currentSceneY);
        current = this.straightAnglesMode ? this.controller.makeStraightAngles(current) : this.controller.correct(current);
        current = sceneGraphObject.sceneToLocal(current.getX(), current.getY(), true);
        this.editor.moveTunable(this.tunableMap, current.getX(), current.getY());
        sceneGraphObject.getParent().layout();
        this.updateHudWindow();
    }

    private void updateHandle(boolean value) {
        Node hitNode = (Node)this.getMousePressedEvent().getTarget();
        AbstractHandles<?> hitHandles = AbstractHandles.lookupHandles(hitNode);
        while (hitHandles == null && hitNode.getParent() != null) {
            hitNode = hitNode.getParent();
            hitHandles = AbstractHandles.lookupHandles(hitNode);
        }
        if (hitNode instanceof Circle) {
            if (this.removed) {
                hitNode.setCursor(value ? Cursor.CROSSHAIR : Cursor.OPEN_HAND);
            } else {
                hitNode.setCursor(value ? Cursor.CLOSED_HAND : Cursor.OPEN_HAND);
            }
        }
    }

    private void setupAndOpenHudWindow() {
        int i;
        HudWindowController hudWindowController = this.contentPanelController.getHudWindowController();
        int propertiesCount = this.editor.getPropertyNames().size();
        int pointsCount = this.editor.getPoints() != null ? Math.min(24, this.editor.getPoints().size()) : 0;
        hudWindowController.setRowCount(propertiesCount + pointsCount);
        List<PropertyName> sizePropertyNames = this.editor.getPropertyNames();
        for (i = 0; i < propertiesCount; ++i) {
            PropertyName pn = sizePropertyNames.get(i);
            hudWindowController.setNameAtRowIndex(pn.getName() + ":", i);
        }
        for (i = 0; i < pointsCount / 2; ++i) {
            hudWindowController.setNameAtRowIndex(i + 1 + ".X:", 2 * i + propertiesCount);
            hudWindowController.setNameAtRowIndex(i + 1 + ".Y:", 2 * i + 1 + propertiesCount);
        }
        this.updateHudWindow();
        hudWindowController.setRelativePosition(CardinalPoint.E);
        hudWindowController.openWindow((Node)this.editor.getSceneGraphObject());
    }

    private void updateHudWindow() {
        int pointsCount;
        HudWindowController hudWindowController = this.contentPanelController.getHudWindowController();
        List<PropertyName> sizePropertyNames = this.editor.getPropertyNames();
        int propertiesCount = sizePropertyNames.size();
        for (int i = 0; i < propertiesCount; ++i) {
            PropertyName pn = sizePropertyNames.get(i);
            String value = String.valueOf(this.editor.getValue(pn));
            hudWindowController.setValueAtRowIndex(value, i);
        }
        int n = pointsCount = this.editor.getPoints() != null ? Math.min(24, this.editor.getPoints().size()) : 0;
        if (pointsCount > 0) {
            for (int i = 0; i < pointsCount; ++i) {
                hudWindowController.setValueAtRowIndex(String.format("%.3f", this.editor.getPoints().get(i)), i + propertiesCount);
            }
        }
    }

    public static enum Tunable {
        START,
        END,
        CONTROL1,
        CONTROL2,
        VERTEX,
        SIDE;

    }
}

