/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.AbstractSegment;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.HorizontalLineIndex;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.HorizontalSegment;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.PointIndex;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.VerticalLineIndex;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.VerticalSegment;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;

public class EditCurveGuideController {
    private final double MATCH_DISTANCE = 6.0;
    private final List<Point2D> curvePoints = new ArrayList<Point2D>();
    private final PointIndex pointIndex = new PointIndex();
    private final HorizontalLineIndex horizontalLineIndex = new HorizontalLineIndex();
    private final VerticalLineIndex verticalLineIndex = new VerticalLineIndex();

    public void addCurvePoint(Point2D pointInScene) {
        assert (pointInScene != null);
        this.curvePoints.add(pointInScene);
        this.pointIndex.addPoint(pointInScene);
    }

    public void addSampleBounds(Node node) {
        assert (node != null);
        assert (node.getScene() != null);
        Bounds layoutBounds = node.getLayoutBounds();
        Bounds boundsInScene = node.localToScene(layoutBounds, true);
        this.addSampleBounds(boundsInScene, true);
    }

    public void addSampleBounds(Bounds boundsInScene, boolean addMiddle) {
        double minX = boundsInScene.getMinX();
        double minY = boundsInScene.getMinY();
        double maxX = boundsInScene.getMaxX();
        double maxY = boundsInScene.getMaxY();
        this.pointIndex.addPoint(new Point2D(minX, minY));
        this.pointIndex.addPoint(new Point2D(minX, maxY));
        this.pointIndex.addPoint(new Point2D(maxX, minY));
        this.pointIndex.addPoint(new Point2D(maxX, maxY));
        if (addMiddle) {
            double midX = (minX + maxX) / 2.0;
            double midY = (minY + maxY) / 2.0;
            this.pointIndex.addPoint(new Point2D(midX, midY));
            this.pointIndex.addPoint(new Point2D(midX, minY));
            this.pointIndex.addPoint(new Point2D(midX, maxY));
            this.pointIndex.addPoint(new Point2D(minX, midY));
            this.pointIndex.addPoint(new Point2D(maxX, midY));
        }
        this.horizontalLineIndex.addLine(new HorizontalSegment(minX, maxX, minY));
        this.horizontalLineIndex.addLine(new HorizontalSegment(minX, maxX, maxY));
        this.verticalLineIndex.addLine(new VerticalSegment(minX, minY, maxY));
        this.verticalLineIndex.addLine(new VerticalSegment(maxX, minY, maxY));
    }

    public Point2D correct(Point2D point) {
        AbstractSegment line;
        assert (point != null);
        double x = point.getX();
        double y = point.getY();
        List<Point2D> matchedPoints = this.pointIndex.match(point, 6.0);
        List<HorizontalSegment> horizontalMatchingLines = this.horizontalLineIndex.matchPoint(point, 6.0);
        List<VerticalSegment> verticalMatchedLines = this.verticalLineIndex.matchPoint(point, 6.0);
        if (!matchedPoints.isEmpty()) {
            return matchedPoints.get(0);
        }
        if (!horizontalMatchingLines.isEmpty()) {
            line = horizontalMatchingLines.get(0);
            y = ((HorizontalSegment)line).getY1();
        }
        if (!verticalMatchedLines.isEmpty()) {
            line = verticalMatchedLines.get(0);
            x = ((VerticalSegment)line).getX1();
        }
        for (Point2D curvePoint : this.curvePoints) {
            if (Math.abs(point.getX() - curvePoint.getX()) < 6.0) {
                x = curvePoint.getX();
            }
            if (!(Math.abs(point.getY() - curvePoint.getY()) < 6.0)) continue;
            y = curvePoint.getY();
        }
        return new Point2D(x, y);
    }

    public Point2D makeStraightAngles(Point2D point) {
        assert (point != null);
        double x = point.getX();
        double y = point.getY();
        for (Point2D curvePoint : this.curvePoints) {
            if (Math.abs(point.getX() - curvePoint.getX()) > Math.abs(point.getY() - curvePoint.getY())) {
                y = curvePoint.getY();
                continue;
            }
            x = curvePoint.getX();
        }
        return new Point2D(x, y);
    }
}

