/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.PointComparator;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.geometry.Point2D;

class PointIndex {
    private static final PointComparator comparator = new PointComparator();
    private final List<Point2D> points = new ArrayList<Point2D>();
    private boolean sorted;

    PointIndex() {
    }

    public void addPoint(Point2D point) {
        this.points.add(point);
        this.sorted = false;
    }

    public void clear() {
        this.points.clear();
    }

    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    public List<Point2D> match(Point2D target, double threshold) {
        assert (threshold >= 0.0);
        if (!this.sorted) {
            Collections.sort(this.points, comparator);
        }
        double bestDelta = Double.MAX_VALUE;
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        for (Point2D point : this.points) {
            double delta = Math.sqrt(Math.pow(target.getX() - point.getX(), 2.0) + Math.pow(target.getY() - point.getY(), 2.0));
            if (!(delta < threshold)) continue;
            if (MathUtils.equals(delta, bestDelta)) {
                result.add(point);
                continue;
            }
            if (!(delta < bestDelta)) continue;
            bestDelta = delta;
            result.clear();
            result.add(point);
        }
        return result;
    }
}

