/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides;

import javafx.collections.ObservableList;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;

public class ResizingGuideChrome
extends Path {
    private final MoveTo moveTo = new MoveTo();
    private final LineTo lineTo = new LineTo();
    private final MoveTo moveTo0 = new MoveTo();
    private final LineTo lineTo0 = new LineTo();
    private final MoveTo moveTo1 = new MoveTo();
    private final LineTo lineTo1 = new LineTo();
    private final double sideLength;

    public ResizingGuideChrome(double sideLength) {
        this.sideLength = sideLength;
        ObservableList elements = this.getElements();
        elements.add(this.moveTo);
        elements.add(this.lineTo);
        elements.add(this.moveTo0);
        elements.add(this.lineTo0);
        elements.add(this.moveTo1);
        elements.add(this.lineTo1);
    }

    public void setup(double x1, double y1, double x2, double y2) {
        this.moveTo.setX(x1);
        this.moveTo.setY(y1);
        this.lineTo.setX(x2);
        this.lineTo.setY(y2);
        if (x1 == x2) {
            this.moveTo0.setX(x1 - this.sideLength);
            this.moveTo0.setY(y1);
            this.lineTo0.setX(x1 + this.sideLength);
            this.lineTo0.setY(y1);
            this.moveTo1.setX(x2 - this.sideLength);
            this.moveTo1.setY(y2);
            this.lineTo1.setX(x2 + this.sideLength);
            this.lineTo1.setY(y2);
        } else if (y1 == y2) {
            this.moveTo0.setX(x1);
            this.moveTo0.setY(y1 - this.sideLength);
            this.lineTo0.setX(x1);
            this.lineTo0.setY(y1 + this.sideLength);
            this.moveTo1.setX(x2);
            this.moveTo1.setY(y2 - this.sideLength);
            this.lineTo1.setX(x2);
            this.lineTo1.setY(y2 + this.sideLength);
        } else {
            double dx = x2 - x1;
            double dy = y2 - y1;
            double distance = Math.sqrt(dx * dx + dy * dy);
            double leftX = -dy / distance;
            double leftY = dx / distance;
            this.moveTo0.setX(x1 + leftX * this.sideLength);
            this.moveTo0.setY(y1 + leftY * this.sideLength);
            this.lineTo0.setX(x1 - leftX * this.sideLength);
            this.lineTo0.setY(y1 - leftY + this.sideLength);
            this.moveTo1.setX(x2 + leftX * this.sideLength);
            this.moveTo1.setY(y2 + leftY * this.sideLength);
            this.lineTo1.setX(x2 - leftX * this.sideLength);
            this.lineTo1.setY(y2 - leftY + this.sideLength);
        }
    }
}

