/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.AbstractSegment;

class VerticalSegment
extends AbstractSegment {
    private final double x;
    private final double y1;
    private final double y2;
    private final double length;

    public VerticalSegment(double x, double y1, double y2) {
        this.x = x;
        this.y1 = y1;
        this.y2 = y2;
        this.length = Math.abs(y2 - y1);
    }

    @Override
    public double getX1() {
        return this.x;
    }

    @Override
    public double getX2() {
        return this.x;
    }

    @Override
    public double getY1() {
        return this.y1;
    }

    @Override
    public double getY2() {
        return this.y2;
    }

    @Override
    public double getLength() {
        return this.length;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.x) >>> 32);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.y1) ^ Double.doubleToLongBits(this.y1) >>> 32);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.y2) ^ Double.doubleToLongBits(this.y2) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VerticalSegment other = (VerticalSegment)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y1) != Double.doubleToLongBits(other.y1)) {
            return false;
        }
        return Double.doubleToLongBits(this.y2) == Double.doubleToLongBits(other.y2);
    }

    @Override
    public int compareTo(AbstractSegment o) {
        assert (o != null);
        return Double.compare(this.length, o.getLength());
    }
}

