/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.mode;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.drag.DragController;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.AbstractDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.GridPaneDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.RootDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.job.RelocateSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ModifyObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.messagelog.MessageLog;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.AbstractDecoration;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.AbstractDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.gridpane.GridPaneHandles;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.gridpane.GridPaneTring;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles.AbstractHandles;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.pring.AbstractPring;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.tring.AbstractTring;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.AbstractGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.DragGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.ZoomGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.key.MoveWithKeyGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.SelectAndMoveGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.SelectWithMarqueeGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.mode.AbstractModeController;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.editor.util.ContextMenuController;
import com.oracle.javafx.scenebuilder.kit.editor.util.InlineEditController;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.DragEvent;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ZoomEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.util.Callback;

public class EditModeController
extends AbstractModeController
implements AbstractGesture.Observer {
    private final List<AbstractHandles<?>> handles = new ArrayList();
    private final Set<FXOMObject> excludes = new HashSet<FXOMObject>();
    private final SelectWithMarqueeGesture selectWithMarqueeGesture;
    private final SelectAndMoveGesture selectAndMoveGesture;
    private final ZoomGesture zoomGesture;
    private AbstractPring<?> pring;
    private AbstractTring<?> tring;
    private AbstractGesture activeGesture;
    private AbstractGesture glassGesture;
    private FXOMInstance inlineEditedObject;
    private final EventHandler<MouseEvent> mouseEnteredGlassLayerListener = e -> this.mouseEnteredGlassLayer((MouseEvent)e);
    private final EventHandler<MouseEvent> mouseExitedGlassLayerListener = e -> this.mouseExitedGlassLayer((MouseEvent)e);
    private final EventHandler<MouseEvent> mouseMovedOnGlassLayerListener = e -> this.mouseMovedOnGlassLayer((MouseEvent)e);
    private final EventHandler<MouseEvent> mousePressedOnGlassLayerListener = e -> this.mousePressedOnGlassLayer((MouseEvent)e);
    private final EventHandler<KeyEvent> keyPressedOnGlassLayerListener = e -> this.keyPressedOnGlassLayer((KeyEvent)e);
    private final EventHandler<ZoomEvent> zoomStartedOnGlassLayer = e -> this.zoomStartedOnGlassLayer((ZoomEvent)e);
    private final EventHandler<DragEvent> dragEnteredGlassLayerListener = e -> this.dragEnteredGlassLayer((DragEvent)e);
    private final EventHandler<MouseEvent> mousePressedOnHandleLayerListener = e -> this.mousePressedOnHandleLayer((MouseEvent)e);
    private final EventHandler<MouseEvent> mousePressedOnPringLayerListener = e -> this.mousePressedOnPringLayer((MouseEvent)e);

    public EditModeController(ContentPanelController contentPanelController) {
        super(contentPanelController);
        this.selectWithMarqueeGesture = new SelectWithMarqueeGesture(contentPanelController);
        this.selectAndMoveGesture = new SelectAndMoveGesture(contentPanelController);
        this.zoomGesture = new ZoomGesture(contentPanelController);
    }

    public AbstractHandles<?> lookupHandles(FXOMObject fxomObject) {
        assert (fxomObject != null);
        AbstractHandles<?> result = null;
        for (AbstractHandles<?> h : this.handles) {
            if (h.getFxomObject() != fxomObject) continue;
            result = h;
            break;
        }
        return result;
    }

    @Override
    public void gestureDidTerminate(AbstractGesture gesture) {
        assert (this.activeGesture == gesture);
        this.activeGesture = null;
        this.startListeningToInputEvents();
        this.contentPanelController.endInteraction();
        this.glassGesture = null;
    }

    @Override
    public void willResignActive(AbstractModeController nextModeController) {
        this.stopListeningToInputEvents();
        this.removeAllHandles();
        this.removePring();
        this.removeTring();
        assert (this.contentPanelController.getHandleLayer().getChildren().isEmpty());
        assert (this.contentPanelController.getPringLayer().getChildren().isEmpty());
        assert (this.contentPanelController.getRudderLayer().getChildren().isEmpty());
    }

    @Override
    public void didBecomeActive(AbstractModeController previousModeController) {
        assert (this.contentPanelController.getGlassLayer() != null);
        assert (this.contentPanelController.getHandleLayer() != null);
        assert (this.contentPanelController.getPringLayer() != null);
        assert (this.contentPanelController.getRudderLayer() != null);
        this.editorSelectionDidChange();
        this.startListeningToInputEvents();
    }

    @Override
    public void editorSelectionDidChange() {
        this.updateParentRing();
        this.updateHandles();
        this.makeSelectionVisible();
    }

    @Override
    public void fxomDocumentDidChange(FXOMDocument oldDocument) {
        this.fxomDocumentDidRefreshSceneGraph();
    }

    @Override
    public void fxomDocumentDidRefreshSceneGraph() {
        this.updateParentRing();
        this.updateHandles();
        this.glassGesture = null;
    }

    @Override
    public void dropTargetDidChange() {
        this.updateTring();
    }

    private void makeSelectionVisible() {
        this.contentPanelController.scrollToSelection();
        if (!this.handles.isEmpty()) {
            this.contentPanelController.reveal(this.handles.get(0).getFxomObject());
        }
    }

    private void updateParentRing() {
        AbstractPring<?> newPring;
        if (this.contentPanelController.isContentDisplayable()) {
            Selection selection = this.contentPanelController.getEditorController().getSelection();
            if (this.pring == null || this.pring.getFxomObject() != selection.getAncestor()) {
                newPring = selection.getAncestor() != null ? this.makePring(selection.getAncestor()) : null;
            } else {
                switch (this.pring.getState()) {
                    default: {
                        newPring = this.pring;
                        break;
                    }
                    case NEEDS_RECONCILE: {
                        newPring = this.pring;
                        this.pring.reconcile();
                        break;
                    }
                    case NEEDS_REPLACE: {
                        newPring = this.makePring(this.pring.getFxomObject());
                    }
                }
            }
        } else {
            newPring = null;
        }
        if (newPring != this.pring) {
            Group pringLayer = this.contentPanelController.getPringLayer();
            if (this.pring != null) {
                pringLayer.getChildren().remove((Object)this.pring.getRootNode());
            }
            this.pring = newPring;
            if (this.pring != null) {
                pringLayer.getChildren().add((Object)this.pring.getRootNode());
            }
        } else assert (this.pring == null || this.pring.getState() == AbstractDecoration.State.CLEAN);
    }

    private AbstractPring<?> makePring(FXOMObject fxomObject) {
        AbstractPring<?> result;
        AbstractDriver driver = this.contentPanelController.lookupDriver(fxomObject);
        if (driver != null) {
            result = driver.makePring(fxomObject);
            if (result != null) {
                result.changeStroke(this.contentPanelController.getPringColor());
            }
        } else {
            result = null;
        }
        return result;
    }

    private void removePring() {
        if (this.pring != null) {
            Group pringLayer = this.contentPanelController.getPringLayer();
            pringLayer.getChildren().remove((Object)this.pring.getRootNode());
            this.pring = null;
        }
    }

    private void updateTring() {
        AbstractTring<?> newTring;
        DragController dragController = this.contentPanelController.getEditorController().getDragController();
        if (dragController.isDropAccepted() && this.contentPanelController.isContentDisplayable()) {
            AbstractDropTarget dropTarget = dragController.getDropTarget();
            if (this.tring instanceof GridPaneTring && dropTarget instanceof GridPaneDropTarget) {
                newTring = this.tring;
                this.updateTring((GridPaneTring)this.tring, (GridPaneDropTarget)dropTarget);
            } else {
                newTring = this.makeTring(dropTarget);
            }
        } else {
            newTring = null;
        }
        if (newTring != this.tring) {
            Group rudderLayer = this.contentPanelController.getRudderLayer();
            if (this.tring != null) {
                rudderLayer.getChildren().remove((Object)this.tring.getRootNode());
            }
            this.tring = newTring;
            if (this.tring != null) {
                rudderLayer.getChildren().add((Object)this.tring.getRootNode());
            }
        } else assert (this.tring == null || this.tring.getState() == AbstractDecoration.State.CLEAN);
    }

    private void updateTring(GridPaneTring tring, GridPaneDropTarget dropTarget) {
        assert (tring != null);
        assert (dropTarget != null);
        tring.setupWithDropTarget(dropTarget);
    }

    private AbstractTring<?> makeTring(AbstractDropTarget dropTarget) {
        AbstractTring<?> result;
        if (dropTarget.getTargetObject() == null) {
            assert (dropTarget instanceof RootDropTarget);
            result = null;
        } else {
            AbstractDriver driver = this.contentPanelController.lookupDriver(dropTarget.getTargetObject());
            if (driver != null) {
                result = driver.makeTring(dropTarget);
                if (result != null) {
                    result.changeStroke(this.contentPanelController.getPringColor());
                }
            } else {
                result = null;
            }
        }
        return result;
    }

    private void removeTring() {
        if (this.tring != null) {
            Group rudderLayer = this.contentPanelController.getRudderLayer();
            rudderLayer.getChildren().remove((Object)this.tring.getRootNode());
            this.tring = null;
        }
    }

    private void updateHandles() {
        Selection selection = this.contentPanelController.getEditorController().getSelection();
        if (selection.getGroup() instanceof ObjectSelectionGroup) {
            this.updateHandles((ObjectSelectionGroup)selection.getGroup());
        } else if (selection.getGroup() instanceof GridSelectionGroup) {
            this.updateHandles((GridSelectionGroup)selection.getGroup());
        } else {
            assert (selection.getGroup() == null) : "Implement updateHandles() for " + String.valueOf(selection.getGroup());
            this.removeAllHandles();
        }
        boolean enabled = this.handles.size() == 1;
        for (AbstractHandles<?> h : this.handles) {
            h.setEnabled(enabled);
        }
    }

    private void updateHandles(ObjectSelectionGroup osg) {
        ArrayList obsoleteHandles = new ArrayList();
        ArrayList<FXOMObject> incomingObjects = new ArrayList<FXOMObject>();
        if (this.contentPanelController.isContentDisplayable()) {
            incomingObjects.addAll(osg.getItems());
        }
        for (AbstractHandles<?> h : this.handles) {
            if (incomingObjects.contains(h.getFxomObject())) {
                switch (h.getState()) {
                    case CLEAN: {
                        incomingObjects.remove(h.getFxomObject());
                        break;
                    }
                    case NEEDS_RECONCILE: {
                        h.reconcile();
                        incomingObjects.remove(h.getFxomObject());
                        break;
                    }
                    case NEEDS_REPLACE: {
                        obsoleteHandles.add(h);
                    }
                }
                if (!(h instanceof GridPaneHandles)) continue;
                GridPaneHandles gridPaneHandles = (GridPaneHandles)h;
                gridPaneHandles.updateColumnRowSelection(null);
                continue;
            }
            obsoleteHandles.add(h);
        }
        this.excludes.clear();
        Group handleLayer = this.contentPanelController.getHandleLayer();
        for (FXOMObject fXOMObject : incomingObjects) {
            AbstractDriver driver = this.contentPanelController.lookupDriver(fXOMObject);
            if (driver == null) {
                this.excludes.add(fXOMObject);
                continue;
            }
            AbstractHandles<?> newHandles = driver.makeHandles(fXOMObject);
            handleLayer.getChildren().add((Object)newHandles.getRootNode());
            this.handles.add(newHandles);
        }
        for (AbstractHandles abstractHandles : obsoleteHandles) {
            handleLayer.getChildren().remove((Object)abstractHandles.getRootNode());
            this.handles.remove(abstractHandles);
        }
    }

    private void updateHandles(GridSelectionGroup gsg) {
        ArrayList obsoleteHandles = new ArrayList();
        if (this.contentPanelController.isContentDisplayable()) {
            for (AbstractHandles<?> h : this.handles) {
                if (h.getFxomObject() == gsg.getParentObject()) {
                    assert (h instanceof GridPaneHandles);
                    if (h.getState() == AbstractDecoration.State.NEEDS_RECONCILE) {
                        h.reconcile();
                    } else assert (h.getState() == AbstractDecoration.State.CLEAN);
                    GridPaneHandles gridPaneHandles = (GridPaneHandles)h;
                    gridPaneHandles.updateColumnRowSelection(gsg);
                    continue;
                }
                obsoleteHandles.add(h);
            }
        } else {
            obsoleteHandles.addAll(this.handles);
        }
        this.excludes.clear();
        Group handleLayer = this.contentPanelController.getHandleLayer();
        if (this.handles.size() == obsoleteHandles.size()) {
            assert (gsg.getParentObject().getSceneGraphObject() instanceof GridPane);
            AbstractDriver driver = this.contentPanelController.lookupDriver(gsg.getParentObject());
            assert (driver != null);
            AbstractHandles<?> abstractHandles = driver.makeHandles(gsg.getParentObject());
            handleLayer.getChildren().add((Object)abstractHandles.getRootNode());
            this.handles.add(abstractHandles);
            assert (abstractHandles instanceof GridPaneHandles);
            GridPaneHandles gridPaneHandles = (GridPaneHandles)abstractHandles;
            gridPaneHandles.updateColumnRowSelection(gsg);
        }
        for (AbstractHandles abstractHandles : obsoleteHandles) {
            handleLayer.getChildren().remove((Object)abstractHandles.getRootNode());
            this.handles.remove(abstractHandles);
        }
    }

    private void removeAllHandles() {
        Group handleLayer = this.contentPanelController.getHandleLayer();
        for (AbstractHandles<?> h : new ArrayList(this.handles)) {
            handleLayer.getChildren().remove((Object)h.getRootNode());
            this.handles.remove(h);
        }
    }

    private void startListeningToInputEvents() {
        Pane glassLayer = this.contentPanelController.getGlassLayer();
        assert (glassLayer.getOnMouseEntered() == null);
        assert (glassLayer.getOnMouseExited() == null);
        assert (glassLayer.getOnMouseMoved() == null);
        assert (glassLayer.getOnMousePressed() == null);
        assert (glassLayer.getOnKeyPressed() == null);
        assert (glassLayer.getOnZoomStarted() == null);
        assert (glassLayer.getOnDragEntered() == null);
        glassLayer.setOnMouseEntered(this.mouseEnteredGlassLayerListener);
        glassLayer.setOnMouseExited(this.mouseExitedGlassLayerListener);
        glassLayer.setOnMouseMoved(this.mouseMovedOnGlassLayerListener);
        glassLayer.setOnMousePressed(this.mousePressedOnGlassLayerListener);
        glassLayer.setOnKeyPressed(this.keyPressedOnGlassLayerListener);
        glassLayer.setOnZoomStarted(this.zoomStartedOnGlassLayer);
        glassLayer.setOnDragEntered(this.dragEnteredGlassLayerListener);
        Group handleLayer = this.contentPanelController.getHandleLayer();
        assert (handleLayer.getOnMousePressed() == null);
        handleLayer.setOnMousePressed(this.mousePressedOnHandleLayerListener);
        Group pringLayer = this.contentPanelController.getPringLayer();
        assert (pringLayer.getOnMousePressed() == null);
        pringLayer.setOnMousePressed(this.mousePressedOnPringLayerListener);
    }

    private void stopListeningToInputEvents() {
        Pane glassLayer = this.contentPanelController.getGlassLayer();
        glassLayer.setOnMouseEntered(null);
        glassLayer.setOnMouseExited(null);
        glassLayer.setOnMouseMoved(null);
        glassLayer.setOnMousePressed(null);
        glassLayer.setOnKeyPressed(null);
        glassLayer.setOnZoomStarted(null);
        glassLayer.setOnDragEntered(null);
        Group handleLayer = this.contentPanelController.getHandleLayer();
        handleLayer.setOnMousePressed(null);
        Group pringLayer = this.contentPanelController.getPringLayer();
        pringLayer.setOnMousePressed(null);
    }

    private void mouseEnteredGlassLayer(MouseEvent e) {
        this.mouseMovedOnGlassLayer(e);
    }

    private void mouseExitedGlassLayer(MouseEvent e) {
        assert (this.activeGesture == null) : "activeGesture=" + String.valueOf(this.activeGesture);
        this.glassGesture = null;
    }

    private void mouseMovedOnGlassLayer(MouseEvent e) {
        assert (this.activeGesture == null) : "activeGesture=" + String.valueOf(this.activeGesture);
        FXOMObject hitObject = this.contentPanelController.pick(e.getSceneX(), e.getSceneY());
        FXOMObject selectionAncestor = this.contentPanelController.getEditorController().getSelection().getAncestor();
        if (hitObject == null) {
            this.selectWithMarqueeGesture.setup(null, selectionAncestor);
            this.glassGesture = this.selectWithMarqueeGesture;
        } else if (hitObject == selectionAncestor) {
            this.selectWithMarqueeGesture.setup(selectionAncestor, selectionAncestor);
            this.glassGesture = this.selectWithMarqueeGesture;
        } else {
            this.selectAndMoveGesture.setHitObject(hitObject);
            this.selectAndMoveGesture.setHitSceneX(e.getSceneX());
            this.selectAndMoveGesture.setHitSceneY(e.getSceneY());
            this.glassGesture = this.selectAndMoveGesture;
        }
    }

    private void mousePressedOnGlassLayer(MouseEvent e) {
        this.contentPanelController.getGlassLayer().requestFocus();
        if (this.glassGesture == null) {
            this.mouseMovedOnGlassLayer(e);
        }
        assert (this.glassGesture != null);
        switch (e.getClickCount()) {
            case 1: {
                if (e.getButton() == MouseButton.SECONDARY) {
                    FXOMObject hitObject;
                    if (this.glassGesture == this.selectAndMoveGesture) {
                        hitObject = this.selectAndMoveGesture.getHitObject();
                    } else {
                        assert (this.glassGesture == this.selectWithMarqueeGesture);
                        hitObject = this.selectWithMarqueeGesture.getHitObject();
                    }
                    Selection selection = this.contentPanelController.getEditorController().getSelection();
                    if (hitObject != null && !selection.isSelected(hitObject)) {
                        selection.select(hitObject);
                    }
                    ContextMenuController contextMenuController = this.contentPanelController.getEditorController().getContextMenuController();
                    contextMenuController.updateContextMenuItems();
                    break;
                }
                this.activateGesture(this.glassGesture, (InputEvent)e);
                break;
            }
            case 2: {
                this.mouseDoubleClickedOnGlassLayer(e);
                break;
            }
        }
        e.consume();
    }

    private void mouseDoubleClickedOnGlassLayer(MouseEvent e) {
        assert (this.activeGesture == null);
        assert (this.glassGesture == this.selectAndMoveGesture || this.glassGesture == this.selectWithMarqueeGesture);
        if (this.glassGesture == this.selectAndMoveGesture) {
            assert (this.selectAndMoveGesture.getHitObject() instanceof FXOMInstance);
            FXOMInstance hitObject = (FXOMInstance)this.selectAndMoveGesture.getHitObject();
            DesignHierarchyMask m = new DesignHierarchyMask(hitObject);
            if (!m.isResourceKey()) {
                this.handleInlineEditing((FXOMInstance)this.selectAndMoveGesture.getHitObject());
            } else {
                MessageLog ml = this.contentPanelController.getEditorController().getMessageLog();
                ml.logWarningMessage("log.warning.inline.edit.internationalized.strings", new Object[0]);
            }
        }
    }

    private void handleInlineEditing(FXOMInstance hitObject) {
        assert (hitObject != null);
        assert (this.inlineEditedObject == null);
        AbstractDriver driver = this.contentPanelController.lookupDriver(hitObject);
        Node inlineEditingBounds = driver.getInlineEditorBounds(hitObject);
        if (inlineEditingBounds != null) {
            this.inlineEditedObject = hitObject;
            InlineEditController inlineEditController = this.contentPanelController.getEditorController().getInlineEditController();
            DesignHierarchyMask m = new DesignHierarchyMask(this.inlineEditedObject);
            String text = m.getDescription();
            InlineEditController.Type type = inlineEditingBounds instanceof TextArea || DesignHierarchyMask.containsLineFeed(text) ? InlineEditController.Type.TEXT_AREA : InlineEditController.Type.TEXT_FIELD;
            TextInputControl inlineEditor = inlineEditController.createTextInputControl(type, inlineEditingBounds, text);
            ObservableList styleSheets = this.getContentPanelController().getPanelRoot().getStylesheets();
            inlineEditor.getStylesheets().addAll((Collection)styleSheets);
            inlineEditor.getStyleClass().add((Object)"theme-presets");
            inlineEditor.getStyleClass().add((Object)"inline-editor");
            Callback requestCommit = value -> this.inlineEditingDidRequestCommit((String)value);
            Callback requestRevert = value -> {
                this.inlineEditingDidRequestRevert();
                return true;
            };
            inlineEditController.startEditingSession(inlineEditor, inlineEditingBounds, (Callback<String, Boolean>)requestCommit, (Callback<Void, Boolean>)requestRevert);
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Inline editing bounds object is null");
        }
        assert (this.contentPanelController.getEditorController().isTextEditingSessionOnGoing() || this.inlineEditedObject == null);
    }

    private boolean inlineEditingDidRequestCommit(String newValue) {
        EditorController editorController;
        assert (this.inlineEditedObject != null);
        DesignHierarchyMask m = new DesignHierarchyMask(this.inlineEditedObject);
        PropertyName propertyName = m.getPropertyNameForDescription();
        assert (propertyName != null);
        ValuePropertyMetadata vpm = Metadata.getMetadata().queryValueProperty(this.inlineEditedObject, propertyName);
        ModifyObjectJob job = new ModifyObjectJob(this.inlineEditedObject, vpm, newValue, editorController = this.contentPanelController.getEditorController());
        if (job.isExecutable()) {
            editorController.getJobManager().push(job);
        }
        this.inlineEditedObject = null;
        return true;
    }

    private void inlineEditingDidRequestRevert() {
        assert (this.inlineEditedObject != null);
        this.inlineEditedObject = null;
    }

    private void keyPressedOnGlassLayer(KeyEvent e) {
        assert (this.activeGesture == null) : "activeGesture=" + String.valueOf(this.activeGesture);
        switch (e.getCode()) {
            case UP: 
            case DOWN: 
            case LEFT: 
            case RIGHT: {
                if (RelocateSelectionJob.isSelectionMovable(this.contentPanelController.getEditorController())) {
                    this.activateGesture(new MoveWithKeyGesture(this.contentPanelController), (InputEvent)e);
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Selection is not movable");
                }
                e.consume();
                break;
            }
            case ENTER: {
                DesignHierarchyMask mask;
                FXOMObject nodeFxomObject;
                ObjectSelectionGroup osg;
                Selection selection = this.contentPanelController.getEditorController().getSelection();
                if (!(selection.getGroup() instanceof ObjectSelectionGroup) || (osg = (ObjectSelectionGroup)selection.getGroup()).getItems().size() != 1 || !((nodeFxomObject = (mask = new DesignHierarchyMask(osg.getSortedItems().get(0))).getClosestFxNode()) instanceof FXOMInstance)) break;
                this.handleInlineEditing((FXOMInstance)nodeFxomObject);
                break;
            }
        }
    }

    private void zoomStartedOnGlassLayer(ZoomEvent e) {
        this.activateGesture(this.zoomGesture, (InputEvent)e);
        e.consume();
    }

    private void dragEnteredGlassLayer(DragEvent e) {
        this.activateGesture(new DragGesture(this.contentPanelController), (InputEvent)e);
    }

    private void mousePressedOnHandleLayer(MouseEvent e) {
        assert (e.getTarget() instanceof Node);
        if (e.getButton() == MouseButton.SECONDARY) {
            ContextMenuController contextMenuController = this.contentPanelController.getEditorController().getContextMenuController();
            contextMenuController.updateContextMenuItems();
        } else {
            Node target;
            Node hitNode = target = (Node)e.getTarget();
            AbstractHandles<?> hitHandles = AbstractHandles.lookupHandles(hitNode);
            while (hitHandles == null && hitNode.getParent() != null) {
                hitNode = hitNode.getParent();
                hitHandles = AbstractHandles.lookupHandles(hitNode);
            }
            if (hitHandles != null) {
                this.activateGesture(hitHandles.findEnabledGesture(hitNode), (InputEvent)e);
            } else assert (false) : "event target has no HANDLES property :" + String.valueOf(target);
        }
        e.consume();
    }

    private void mousePressedOnPringLayer(MouseEvent e) {
        Node target;
        assert (e.getTarget() instanceof Node);
        Node hitNode = target = (Node)e.getTarget();
        AbstractPring<?> hitPring = AbstractPring.lookupPring(target);
        while (hitPring == null && hitNode.getParent() != null) {
            hitNode = hitNode.getParent();
            hitPring = AbstractPring.lookupPring(hitNode);
        }
        if (hitPring != null) {
            this.activateGesture(hitPring.findGesture(hitNode), (InputEvent)e);
        } else assert (false) : "event target has no PRING property :" + String.valueOf(target);
        e.consume();
    }

    private void activateGesture(AbstractGesture gesture, InputEvent e) {
        assert (this.activeGesture == null) : "activeGesture=" + String.valueOf(this.activeGesture);
        if (gesture == null) {
            return;
        }
        EditorController editorController = this.contentPanelController.getEditorController();
        if (this.contentPanelController.isContentDisplayable() && editorController.canGetFxmlText()) {
            this.contentPanelController.beginInteraction();
            this.stopListeningToInputEvents();
            this.activeGesture = gesture;
            gesture.start(e, this);
            assert (this.activeGesture == gesture || this.activeGesture == null);
        }
    }
}

