/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.util;

import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;

public final class CardinalPoint
extends Enum<CardinalPoint> {
    public static final /* enum */ CardinalPoint N = new CardinalPoint();
    public static final /* enum */ CardinalPoint NE = new CardinalPoint();
    public static final /* enum */ CardinalPoint E = new CardinalPoint();
    public static final /* enum */ CardinalPoint SE = new CardinalPoint();
    public static final /* enum */ CardinalPoint S = new CardinalPoint();
    public static final /* enum */ CardinalPoint SW = new CardinalPoint();
    public static final /* enum */ CardinalPoint W = new CardinalPoint();
    public static final /* enum */ CardinalPoint NW = new CardinalPoint();
    private static final /* synthetic */ CardinalPoint[] $VALUES;

    public static CardinalPoint[] values() {
        return (CardinalPoint[])$VALUES.clone();
    }

    public static CardinalPoint valueOf(String name) {
        return Enum.valueOf(CardinalPoint.class, name);
    }

    public CardinalPoint getOpposite() {
        return switch (this.ordinal()) {
            case 0 -> S;
            case 1 -> SW;
            case 2 -> W;
            case 3 -> NW;
            case 4 -> N;
            case 5 -> NE;
            case 6 -> E;
            case 7 -> SE;
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("unexpected cardinal point:" + String.valueOf((Object)this)));
                }
                yield N;
            }
        };
    }

    public Point2D getPosition(Bounds bounds) {
        double x;
        return new Point2D(x, switch (this.ordinal()) {
            case 0 -> {
                x = (bounds.getMinX() + bounds.getMaxX()) / 2.0;
                yield bounds.getMinY();
            }
            case 1 -> {
                x = bounds.getMaxX();
                yield bounds.getMinY();
            }
            case 2 -> {
                x = bounds.getMaxX();
                yield (bounds.getMinY() + bounds.getMaxY()) / 2.0;
            }
            case 3 -> {
                x = bounds.getMaxX();
                yield bounds.getMaxY();
            }
            case 4 -> {
                x = (bounds.getMinX() + bounds.getMaxX()) / 2.0;
                yield bounds.getMaxY();
            }
            case 5 -> {
                x = bounds.getMinX();
                yield bounds.getMaxY();
            }
            case 6 -> {
                x = bounds.getMinX();
                yield (bounds.getMinY() + bounds.getMaxY()) / 2.0;
            }
            case 7 -> {
                x = bounds.getMinX();
                yield bounds.getMinY();
            }
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("unexpected cardinal point:" + String.valueOf((Object)this)));
                }
                x = bounds.getMinX();
                yield bounds.getMinY();
            }
        });
    }

    public Bounds getResizedBounds(Bounds currentBounds, double dx, double dy) {
        double newMinY;
        double newMinX;
        double minX = currentBounds.getMinX();
        double maxX = currentBounds.getMaxX();
        double newMaxX = switch (this.ordinal()) {
            case 5, 6, 7 -> {
                newMinX = Math.min(minX + dx, maxX);
                yield maxX;
            }
            case 1, 2, 3 -> {
                newMinX = minX;
                yield Math.max(maxX + dx, minX);
            }
            case 0, 4 -> {
                newMinX = minX;
                yield maxX;
            }
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("unexpected value=" + String.valueOf((Object)this)));
                }
                newMinX = minX;
                yield maxX;
            }
        };
        double minY = currentBounds.getMinY();
        double maxY = currentBounds.getMaxY();
        return new BoundingBox(newMinX, newMinY, newMaxX - newMinX, (switch (this.ordinal()) {
            case 0, 1, 7 -> {
                newMinY = Math.min(minY + dy, maxY);
                yield maxY;
            }
            case 3, 4, 5 -> {
                newMinY = minY;
                yield Math.max(maxY + dy, minY);
            }
            case 2, 6 -> {
                newMinY = minY;
                yield maxY;
            }
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("unexpected value=" + String.valueOf((Object)this)));
                }
                newMinY = minY;
                yield maxY;
            }
        }) - newMinY);
    }

    public Point2D clampVector(double dx, double dy) {
        double resultDX;
        return new Point2D(resultDX, switch (this.ordinal()) {
            case 0, 4 -> {
                resultDX = 0.0;
                yield dy;
            }
            case 2, 6 -> {
                resultDX = dx;
                yield 0.0;
            }
            default -> {
                resultDX = dx;
                yield dy;
            }
        });
    }

    public Bounds snapBounds(Bounds bounds, double ratio) {
        double newMinY;
        double newMinX;
        double minX = bounds.getMinX();
        double minY = bounds.getMinY();
        double maxX = bounds.getMaxX();
        double maxY = bounds.getMaxY();
        double snapWidth = bounds.getHeight() / ratio;
        double snapDX = snapWidth - bounds.getWidth();
        double snapHeight = bounds.getWidth() * ratio;
        double snapDY = snapHeight - bounds.getHeight();
        return new BoundingBox(newMinX, newMinY, (switch (this.ordinal()) {
            case 0, 4 -> {
                newMinX = minX - snapDX / 2.0;
                yield maxX + snapDX / 2.0;
            }
            case 2, 6 -> {
                newMinX = minX;
                yield maxX;
            }
            case 5, 7 -> {
                newMinX = Math.abs(snapDX) >= Math.abs(snapDY) ? minX - snapDX : minX;
                yield maxX;
            }
            case 1, 3 -> {
                newMinX = minX;
                if (Math.abs(snapDX) >= Math.abs(snapDY)) {
                    yield maxX + snapDX;
                }
                yield maxX;
            }
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unexpected " + String.valueOf((Object)this)));
                }
                newMinX = minX;
                yield maxX;
            }
        }) - newMinX, (switch (this.ordinal()) {
            case 0, 4 -> {
                newMinY = minY;
                yield maxY;
            }
            case 2, 6 -> {
                newMinY = minY - snapDY / 2.0;
                yield maxY + snapDY / 2.0;
            }
            case 1, 7 -> {
                newMinY = Math.abs(snapDY) > Math.abs(snapDX) ? minY - snapDY : minY;
                yield maxY;
            }
            case 3, 5 -> {
                newMinY = minY;
                if (Math.abs(snapDY) > Math.abs(snapDX)) {
                    yield maxY + snapDY;
                }
                yield maxY;
            }
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unexpected " + String.valueOf((Object)this)));
                }
                newMinY = minY;
                yield maxY;
            }
        }) - newMinY);
    }

    private static /* synthetic */ CardinalPoint[] $values() {
        return new CardinalPoint[]{N, NE, E, SE, S, SW, W, NW};
    }

    static {
        $VALUES = CardinalPoint.$values();
    }
}

