/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.util;

import javafx.geometry.Point2D;
import javafx.scene.shape.Line;

public class DistanceUtils {
    DistanceUtils() {
    }

    public static double getDistFromPointToLine(Point2D point, Line line) {
        double y1;
        double x1;
        double y0;
        double x = point.getX();
        double y = point.getY();
        double x0 = line.getStartX();
        double dot0 = DistanceUtils.dot(x - x0, y - (y0 = line.getStartY()), (x1 = line.getEndX()) - x0, (y1 = line.getEndY()) - y0);
        if (dot0 < 0.0) {
            return DistanceUtils.dist(x, y, x0, y0);
        }
        double dot1 = DistanceUtils.dot(x - x1, y - y1, x0 - x1, y0 - y1);
        if (dot1 < 0.0) {
            return DistanceUtils.dist(x, y, x1, y1);
        }
        return Math.abs((y0 - y1) * x + (x1 - x0) * y + (x0 * y1 - x1 * y0)) / DistanceUtils.dist(x0, y0, x1, y1);
    }

    private static double dot(double x1, double y1, double x2, double y2) {
        return x1 * x2 + y1 * y2;
    }

    private static double dist(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
    }
}

