/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.util;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.util.DistanceUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.shape.Line;
import javafx.scene.shape.Shape;

public class Picker {
    private static final double THRESHOLD = 3.0;
    private final Set<Node> excludes = new HashSet<Node>();
    private final List<Node> matches = new ArrayList<Node>();

    public List<Node> pick(Node startNode, double sceneX, double sceneY) {
        assert (startNode != null);
        assert (startNode.getScene() != null);
        assert (!Double.isNaN(sceneX));
        assert (!Double.isNaN(sceneY));
        Point2D localXY = startNode.sceneToLocal(sceneX, sceneY, true);
        return this.pickInLocal(startNode, localXY.getX(), localXY.getY());
    }

    public List<Node> pickInLocal(Node startNode, double localX, double localY) {
        assert (startNode != null);
        assert (startNode.getScene() != null);
        assert (!Double.isNaN(localX));
        assert (!Double.isNaN(localY));
        this.matches.clear();
        this.performPick(startNode, localX, localY);
        return this.matches.isEmpty() ? null : Collections.unmodifiableList(this.matches);
    }

    public Set<Node> getExcludes() {
        return this.excludes;
    }

    private void performPick(Node startNode, double localX, double localY) {
        if (!this.excludes.contains(startNode) && startNode.isVisible()) {
            if (this.match(startNode, localX, localY)) {
                this.matches.add(0, startNode);
            }
            if (startNode instanceof Parent) {
                Parent startParent = (Parent)startNode;
                for (Node child : startParent.getChildrenUnmodifiable()) {
                    Point2D childLocalXY = child.parentToLocal(localX, localY);
                    if (childLocalXY == null) continue;
                    this.performPick(child, childLocalXY.getX(), childLocalXY.getY());
                }
            }
        }
    }

    private boolean match(Node node, double x, double y) {
        Line line;
        Point2D point;
        assert (node != null);
        Bounds bounds = node.getLayoutBounds();
        if (bounds.isEmpty()) {
            return false;
        }
        boolean result = node instanceof Line ? DistanceUtils.getDistFromPointToLine(point = new Point2D(x, y), line = (Line)node) < 3.0 : (node instanceof Shape ? ((Shape)node).contains(x, y) : bounds.contains(x, y));
        return result;
    }
}

