/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.css;

import com.oracle.javafx.scenebuilder.kit.editor.panel.css.CssUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.css.CssValueConverter;
import com.oracle.javafx.scenebuilder.kit.editor.panel.css.NodeCssState;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.PropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.CssInternal;
import com.oracle.javafx.scenebuilder.kit.util.Deprecation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javafx.css.CssMetaData;
import javafx.css.ParsedValue;
import javafx.css.Rule;
import javafx.css.Style;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.scene.Node;
import javafx.scene.Parent;

public class CssContentMaker {
    private CssContentMaker() {
        assert (false);
    }

    public static <N extends Node> PropertyState initialValue(N n, CssMetaData<N, ?> sub) {
        InitialPropertyState val = null;
        try {
            Object fxValue;
            String cssValue;
            Object value = sub.getInitialValue(n);
            if (value == null) {
                cssValue = "none";
                fxValue = cssValue;
            } else {
                fxValue = sub.getInitialValue(n);
                cssValue = CssValueConverter.toCssString(sub.getProperty(), n);
            }
            val = CssContentMaker.newInitialPropertyState(fxValue, cssValue, n, sub);
        }
        catch (RuntimeException ex) {
            System.out.println(ex.getMessage() + " " + String.valueOf(ex));
        }
        return val;
    }

    public static <N extends Node> PropertyState initialValue(N n, NodeCssState.CssProperty complex, CssMetaData<N, ?> sub) {
        InitialPropertyState val = null;
        try {
            Object fxValue;
            String cssValue;
            Object complexInitial = complex.getStyleable().getInitialValue((Styleable)complex.getTarget());
            if (complexInitial == null) {
                cssValue = "none";
                fxValue = cssValue;
            } else {
                fxValue = sub.getInitialValue(n);
                cssValue = CssValueConverter.toCssString(sub.getProperty(), complexInitial);
            }
            val = CssContentMaker.newInitialPropertyState(fxValue, cssValue, n, sub);
        }
        catch (RuntimeException ex) {
            System.out.println(ex.getMessage() + " " + String.valueOf(ex));
        }
        return val;
    }

    public static <N extends Node> PropertyState modelValue(N node, CssMetaData<?, ?> cssMeta, FXOMObject fxomObject) {
        BeanPropertyState val = null;
        if (fxomObject == null) {
            return null;
        }
        String beanPropName = CssUtils.getBeanPropertyName(node, cssMeta);
        if (beanPropName == null) {
            return null;
        }
        PropertyName beanPropertyName = new PropertyName(beanPropName);
        assert (fxomObject instanceof FXOMInstance);
        FXOMInstance fxomInstance = (FXOMInstance)fxomObject;
        ValuePropertyMetadata propMeta = Metadata.getMetadata().queryValueProperty(fxomInstance, beanPropertyName);
        if (propMeta == null) {
            return null;
        }
        if (!propMeta.isReadWrite()) {
            return null;
        }
        boolean overriden = false;
        Object defaultValue = propMeta.getDefaultValueObject();
        Object propertyValue = propMeta.getValueObject(fxomInstance);
        if (propertyValue == null || defaultValue == null) {
            if (propertyValue != defaultValue) {
                overriden = true;
            }
        } else if (!propertyValue.equals(defaultValue)) {
            overriden = true;
        }
        if (overriden) {
            val = new BeanPropertyState(propMeta, cssMeta.getProperty(), propertyValue, CssValueConverter.toCssString(cssMeta.getProperty(), propertyValue));
            if (cssMeta.getSubProperties() != null && !cssMeta.getSubProperties().isEmpty()) {
                for (CssMetaData sub : cssMeta.getSubProperties()) {
                    BeanPropertyState subProp = new BeanPropertyState(propMeta, sub.getProperty(), propertyValue, CssValueConverter.toCssString(sub.getProperty(), propertyValue));
                    val.getSubProperties().add(subProp);
                }
            }
        }
        return val;
    }

    public static Node getSourceNodeForStyle(Object component, String property) {
        Node ret = null;
        Node n = CssUtils.getNode(component);
        if (n != null) {
            if (n.getStyle() != null && n.getStyle().contains(property)) {
                ret = n;
            } else {
                for (Parent p = n.getParent(); p != null; p = p.getParent()) {
                    String s = p.getStyle();
                    if (s == null || !s.contains(property)) continue;
                    ret = p;
                    break;
                }
            }
        }
        return ret;
    }

    public static boolean isInlineInherited(Object component, CssPropertyState cssProperty) {
        boolean isInherited = false;
        Node node = CssUtils.getNode(component);
        if (node == null) {
            return false;
        }
        if (node.getStyle() == null) {
            return true;
        }
        if (!CssContentMaker.containsInStyle(cssProperty, node.getStyle())) {
            isInherited = true;
        }
        return isInherited;
    }

    public static boolean containsPseudoState(String selector) {
        return selector.contains(":");
    }

    private static boolean containsInStyle(CssPropertyState prop, String style) {
        return style.contains(prop.getCssProperty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static NodeCssState getCssState(Object selectedObject) {
        block7: {
            block5: {
                block6: {
                    node = CssUtils.getSelectedNode(selectedObject);
                    if (node == null) {
                        return null;
                    }
                    p = null;
                    current = 1.0;
                    try {
                        if (node.getScene() != null) ** GOTO lbl27
                        inScene = CssUtils.getFirstAncestorWithNonNullScene(node);
                        if (inScene != null) break block5;
                        var6_5 = null;
                        if (p == null) break block6;
                    }
                    catch (Throwable var7_7) {
                        if (p != null) {
                            CssUtils.removeFromParent(p, node);
                            node.setOpacity(current);
                        }
                        throw var7_7;
                    }
                    CssUtils.removeFromParent(p, node);
                    node.setOpacity(current);
                }
                return var6_5;
            }
            p = inScene.getParent();
            current = node.getOpacity();
            node.setOpacity(0.0);
            CssUtils.addToParent(p, node);
lbl27:
            // 2 sources

            var6_6 = state = new NodeCssState(CssInternal.collectCssState(node), node, CssContentMaker.getFXOMObject(selectedObject));
            if (p == null) break block7;
            CssUtils.removeFromParent(p, node);
            node.setOpacity(current);
        }
        return var6_6;
    }

    private static FXOMObject getFXOMObject(Object selectedObject) {
        if (selectedObject instanceof FXOMObject) {
            return (FXOMObject)selectedObject;
        }
        return null;
    }

    private static <N extends Node> InitialPropertyState newInitialPropertyState(Object fxValue, String cssValue, N n, CssMetaData<?, ?> cssMeta) {
        InitialPropertyState val = new InitialPropertyState(cssMeta.getProperty(), fxValue, cssValue);
        if (cssMeta.getSubProperties() != null && !cssMeta.getSubProperties().isEmpty()) {
            for (CssMetaData sub : cssMeta.getSubProperties()) {
                Object subValue = CssValueConverter.getSubPropertyValue(sub.getProperty(), fxValue);
                String subCssValue = CssValueConverter.toCssString(subValue);
                InitialPropertyState subProp = new InitialPropertyState(sub.getProperty(), subValue, subCssValue);
                val.getSubProperties().add(subProp);
            }
        }
        return val;
    }

    protected static CssPropertyState.CssStyle retrieveStyle(List<Style> styles, Style style) {
        CssPropertyState.CssStyle st = new CssPropertyState.CssStyle(style);
        ParsedValue parsedValue = style.getDeclaration().getParsedValue();
        if (parsedValue.isContainsLookups() || parsedValue.isLookup()) {
            CssContentMaker.retrieveStylesFromParsedValue(styles, st, style.getDeclaration().getParsedValue());
        }
        return st;
    }

    private static void retrieveStylesFromParsedValue(List<Style> lst, CssPropertyState.CssStyle current, ParsedValue<?, ?> parsedValue) {
        block5: {
            Object val;
            block6: {
                ParsedValue[] layers;
                block4: {
                    ParsedValue[][] layers2;
                    val = parsedValue.getValue();
                    if (!(val instanceof ParsedValue[][])) break block4;
                    ParsedValue[][] parsedValueArray = layers2 = (ParsedValue[][])val;
                    int n = parsedValueArray.length;
                    for (int i = 0; i < n; ++i) {
                        ParsedValue[] layers3;
                        for (ParsedValue layer : layers3 = parsedValueArray[i]) {
                            if (layer == null) continue;
                            CssContentMaker.retrieveStylesFromParsedValue(lst, current, layer);
                        }
                    }
                    break block5;
                }
                if (!(val instanceof ParsedValue[])) break block6;
                for (ParsedValue layer : layers = (ParsedValue[])val) {
                    if (layer == null) continue;
                    CssContentMaker.retrieveStylesFromParsedValue(lst, current, layer);
                }
                break block5;
            }
            if (!(val instanceof String)) break block5;
            String value = (String)val;
            for (Style info : lst) {
                if (!value.equals(info.getDeclaration().getProperty())) continue;
                CssPropertyState.CssStyle cssStyle = CssContentMaker.retrieveStyle(lst, info);
                current.getLookupChain().add(cssStyle);
            }
        }
    }

    protected static List<CssPropertyState.CssStyle> getNotAppliedStyles(List<Style> appliedStyles, Node node, CssMetaData<?, ?> cssMeta) {
        ArrayList<CssPropertyState.CssStyle> ret = new ArrayList<CssPropertyState.CssStyle>();
        List<Style> allStyles = Deprecation.getMatchingStyles(cssMeta, (Styleable)node);
        List<Style> matchingStyles = CssContentMaker.removeUserAgentStyles(allStyles);
        ArrayList<Style> notApplied = new ArrayList<Style>();
        for (Style style : matchingStyles) {
            if (appliedStyles.contains(style)) continue;
            notApplied.add(style);
        }
        for (Style style : notApplied) {
            if (!style.getDeclaration().getProperty().equals(cssMeta.getProperty())) continue;
            CssPropertyState.CssStyle cssStyle = CssContentMaker.retrieveStyle(matchingStyles, style);
            ret.add(cssStyle);
        }
        return ret;
    }

    protected static List<Style> removeUserAgentStyles(List<Style> allStyles) {
        ArrayList<Style> matchingStyles = new ArrayList<Style>();
        for (Style style : allStyles) {
            if (style.getDeclaration().getRule().getOrigin() == StyleOrigin.USER_AGENT) continue;
            matchingStyles.add(style);
        }
        return matchingStyles;
    }

    private static class InitialPropertyState
    extends PropertyState {
        private final String name;
        private final Object fxValue;

        InitialPropertyState(String name, Object fxValue, String cssValue) {
            super(cssValue);
            this.name = name;
            this.fxValue = fxValue;
        }

        @Override
        public String getCssProperty() {
            return this.name;
        }

        @Override
        public Object getFxValue() {
            return this.fxValue;
        }
    }

    public static class BeanPropertyState
    extends PropertyState {
        PropertyMetadata propMeta;
        private final String cssPropName;
        private final Object fxValue;

        BeanPropertyState(PropertyMetadata propMeta, String cssPropName, Object fxValue, String cssValue) {
            super(cssValue);
            this.propMeta = propMeta;
            this.cssPropName = cssPropName;
            this.fxValue = fxValue;
        }

        @Override
        public String getCssProperty() {
            return this.cssPropName;
        }

        public PropertyMetadata getPropertyMeta() {
            return this.propMeta;
        }

        @Override
        public Object getFxValue() {
            return this.fxValue;
        }
    }

    public static abstract class PropertyState
    implements Comparable<PropertyState> {
        private final List<CssPropertyState.CssStyle> notAppliedStyles = new ArrayList<CssPropertyState.CssStyle>();
        private final List<PropertyState> lst = new ArrayList<PropertyState>();
        private final String cssValue;

        protected PropertyState(String cssValue) {
            this.cssValue = cssValue;
        }

        public abstract String getCssProperty();

        public abstract Object getFxValue();

        public String getCssValue() {
            return this.cssValue;
        }

        public List<PropertyState> getSubProperties() {
            return this.lst;
        }

        public List<CssPropertyState.CssStyle> getNotAppliedStyles() {
            return this.notAppliedStyles;
        }

        @Override
        public int compareTo(PropertyState t) {
            PropertyState ps = t;
            return this.getCssProperty().compareTo(ps.getCssProperty());
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyState ps = (PropertyState)obj;
            return this.getCssProperty().compareTo(ps.getCssProperty()) == 0;
        }

        public int hashCode() {
            int hash = 7;
            hash = 53 * hash + Objects.hashCode(this.notAppliedStyles);
            hash = 53 * hash + Objects.hashCode(this.lst);
            hash = 53 * hash + Objects.hashCode(this.cssValue);
            return hash;
        }
    }

    public static class CssPropertyState
    extends PropertyState {
        protected final StyleableProperty<?> value;
        protected final CssMetaData<?, ?> cssMeta;
        private CssStyle style;

        CssPropertyState(StyleableProperty<?> value, CssMetaData<?, ?> cssMeta, String cssValue) {
            super(cssValue);
            this.value = value;
            this.cssMeta = cssMeta;
        }

        @Override
        public String getCssProperty() {
            return this.cssMeta.getProperty();
        }

        public CssStyle getStyle() {
            return this.style;
        }

        void setStyle(CssStyle style) {
            this.style = style;
        }

        @Override
        public Object getFxValue() {
            return this.value.getValue();
        }

        public static class CssStyle {
            private final Style style;
            private boolean used = true;
            private final List<CssStyle> lookupSet = new ArrayList<CssStyle>();

            public CssStyle(Style style) {
                this.style = style;
            }

            protected void setUnused() {
                this.used = false;
            }

            public boolean isUsed() {
                return this.used;
            }

            public Style getStyle() {
                return this.style;
            }

            public String getCssProperty() {
                return this.style.getDeclaration().getProperty();
            }

            public ParsedValue getParsedValue() {
                return this.style.getDeclaration().getParsedValue();
            }

            public StyleOrigin getOrigin() {
                return CssInternal.getOrigin(this.style);
            }

            public String getSelector() {
                String sel = this.style.getSelector().toString();
                if (sel.startsWith("*")) {
                    sel = sel.substring(1);
                }
                return sel;
            }

            public Rule getCssRule() {
                return this.style.getDeclaration().getRule();
            }

            public URL getUrl() {
                Rule rule = this.getCssRule();
                if (rule == null) {
                    return null;
                }
                try {
                    return new URL(rule.getStylesheet().getUrl());
                }
                catch (MalformedURLException ex) {
                    System.out.println(ex.getMessage() + " " + String.valueOf(ex));
                    return null;
                }
            }

            public String toString() {
                return this.style.toString();
            }

            public List<CssStyle> getLookupChain() {
                return this.lookupSet;
            }

            public int hashCode() {
                int hash = 7;
                hash = 47 * hash + (this.style != null ? this.style.hashCode() : 0);
                return hash;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof CssStyle)) {
                    return false;
                }
                CssStyle cssStyle = (CssStyle)obj;
                return this.style.equals((Object)cssStyle.style);
            }
        }
    }

    protected static class CssSubPropertyState
    extends CssPropertyState {
        CssSubPropertyState(StyleableProperty<?> value, CssMetaData<?, ?> cssMeta, String cssValue) {
            super(value, cssMeta, cssValue);
        }

        @Override
        public Object getFxValue() {
            return CssValueConverter.getSubPropertyValue(this.cssMeta.getProperty(), this.value.getValue());
        }
    }
}

