/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.css;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.metadata.util.ColorEncoder;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javafx.css.Declaration;
import javafx.css.ParsedValue;
import javafx.css.Rule;
import javafx.css.Size;
import javafx.css.converter.DeriveColorConverter;
import javafx.css.converter.DeriveSizeConverter;
import javafx.css.converter.LadderConverter;
import javafx.css.converter.PaintConverter;
import javafx.geometry.Insets;
import javafx.geometry.Side;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderImage;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;

public class CssValueConverter {
    private static final List<String> STRING_VALUE = new ArrayList<String>();
    private static final List<String> SINGLE_WHEN_EQUALITY = new ArrayList<String>();
    static Map<Color, String> standardColors;

    private CssValueConverter() {
        assert (false);
    }

    public static Object convert(ParsedValue pv) {
        Object value = null;
        if (pv == null) {
            return null;
        }
        if (pv.getConverter() != null) {
            try {
                Object converted;
                value = converted = pv.getConverter().convert(pv, null);
            }
            catch (RuntimeException runtimeException) {}
        } else {
            value = pv.getValue();
        }
        if (value instanceof ParsedValue) {
            value = CssValueConverter.convert((ParsedValue)value);
        }
        return value;
    }

    public static String toCssString(String property, Rule rule, Object fxValue) {
        try {
            return CssValueConverter.getValue(property, rule, fxValue);
        }
        catch (IllegalArgumentException ex) {
            return CssValueConverter.getValue(property, null, fxValue);
        }
    }

    public static String toCssString(String property, Object fxValue) {
        return CssValueConverter.getValue(property, null, fxValue);
    }

    public static String toCssString(Object fxValue) {
        return CssValueConverter.getValue(null, null, fxValue);
    }

    public static Object getSubPropertyValue(String property, Object value) {
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            ArrayList<Object> subValues = new ArrayList<Object>();
            for (Object bf : values) {
                subValues.add(CssValueConverter.getSubPropertyValue(property, bf));
            }
            return subValues;
        }
        if (value != null && value.getClass().isArray()) {
            Object newArray = Array.newInstance(value.getClass().getComponentType(), Array.getLength(value));
            for (int i = 0; i < Array.getLength(value); ++i) {
                Array.set(newArray, i, CssValueConverter.getSubPropertyValue(property, Array.get(value, i)));
            }
            return newArray;
        }
        if (value instanceof Background) {
            Background background = (Background)value;
            if (background.getFills() != null) {
                return CssValueConverter.getSubPropertyValue(property, background.getFills());
            }
            if (background.getImages() != null) {
                return CssValueConverter.getSubPropertyValue(property, background.getImages());
            }
        } else {
            if (value instanceof BackgroundFill) {
                return CssValueConverter.subBackgroundFill(property, (BackgroundFill)value);
            }
            if (value instanceof BackgroundImage) {
                return CssValueConverter.subBackgroundImage(property, (BackgroundImage)value);
            }
            if (value instanceof Border) {
                Border border = (Border)value;
                if (border.getStrokes() != null) {
                    return CssValueConverter.getSubPropertyValue(property, border.getStrokes());
                }
                if (border.getImages() != null) {
                    return CssValueConverter.getSubPropertyValue(property, border.getImages());
                }
            } else {
                if (value instanceof BorderStroke) {
                    return CssValueConverter.subBorderStroke(property, (BorderStroke)value);
                }
                if (value instanceof BorderImage) {
                    return CssValueConverter.subBorderImage(property, (BorderImage)value);
                }
                if (value instanceof Font) {
                    return CssValueConverter.subFont(property, (Font)value);
                }
            }
        }
        return CssValueConverter.getValue(property, null, value);
    }

    private static String format(String property, String value) {
        if (STRING_VALUE.contains(property)) {
            return "\"" + value + "\"";
        }
        return value;
    }

    private static String getValue(String property, Rule r, Object eventValue) throws IllegalArgumentException {
        if (r == null) {
            return CssValueConverter.format(property, CssValueConverter.retrieveValue(property, eventValue));
        }
        for (Declaration d : r.getDeclarations()) {
            if (!d.getProperty().equals(property)) continue;
            if (property.equals("-fx-background-radius") || property.equals("-fx-border-radius")) {
                return CssValueConverter.format(property, CssValueConverter.getRadiusCssString(property, d.getParsedValue()));
            }
            return CssValueConverter.format(property, CssValueConverter.getCssString(property, d.getParsedValue()));
        }
        throw new IllegalArgumentException("Can't compute a value");
    }

    private static boolean singleForEquality(String prop) {
        return SINGLE_WHEN_EQUALITY.contains(prop);
    }

    private static String getCssString(String property, ParsedValue value) {
        Object obj;
        if (value == null) {
            return "null";
        }
        if (value.getConverter() instanceof PaintConverter.LinearGradientConverter || value.getConverter() instanceof PaintConverter.RadialGradientConverter) {
            try {
                Object converted = value.getConverter().convert(value, null);
                return CssValueConverter.toCssString(converted);
            }
            catch (RuntimeException converted) {
                // empty catch block
            }
        }
        if ((obj = value.getValue()) instanceof ParsedValue) {
            return CssValueConverter.getCssString(property, (ParsedValue)obj);
        }
        StringBuilder builder = new StringBuilder();
        boolean isDerive = value.getConverter() instanceof DeriveColorConverter || value.getConverter() instanceof DeriveSizeConverter;
        boolean isLadder = value.getConverter() instanceof LadderConverter;
        if (isDerive) {
            builder.append("derive(");
        }
        if (isLadder) {
            builder.append("ladder(");
        }
        if (obj instanceof ParsedValue[]) {
            ParsedValue[] array = (ParsedValue[])obj;
            boolean isArrayValue = false;
            if (array.length >= 1) {
                ParsedValue pval = array[0];
                Object val = null;
                if (pval != null) {
                    val = pval.getConverter() instanceof PaintConverter.LinearGradientConverter || pval.getConverter() instanceof PaintConverter.RadialGradientConverter ? null : pval.getValue();
                }
                isArrayValue = val != null && val.getClass().isArray();
            }
            boolean singleForEquality = CssValueConverter.singleForEquality(property) && !isArrayValue;
            StringBuilder b = new StringBuilder();
            if (singleForEquality) {
                String latest = null;
                boolean areEquals = true;
                ArrayList<String> values = new ArrayList<String>(array.length);
                for (ParsedValue v : array) {
                    String current = CssValueConverter.getCssString(property, v);
                    values.add(current);
                    areEquals &= latest == null || current.equals(latest);
                    latest = current;
                }
                if (areEquals) {
                    String val = (String)values.get(0);
                    val = CssValueConverter.removeDotZeroPxPercent(val);
                    b.append(val);
                } else {
                    for (int i = 0; i < values.size(); ++i) {
                        b.append((String)values.get(i));
                        if (i >= array.length - 1) continue;
                        b.append(" ");
                    }
                }
            } else {
                for (int i = 0; i < array.length; ++i) {
                    ParsedValue v = array[i];
                    String val = CssValueConverter.getCssString(property, v);
                    val = CssValueConverter.removeDotZeroPxPercent(val);
                    b.append(val);
                    if (i >= array.length - 1 || val.length() <= 0) continue;
                    b.append(", ");
                }
            }
            builder.append(b.toString());
        } else if (obj instanceof ParsedValue[][]) {
            ParsedValue[][] arr = (ParsedValue[][])obj;
            for (int i = 0; i < arr.length; ++i) {
                String val = CssValueConverter.retrieveValue(property, arr[i]);
                builder.append(val);
                if (i >= arr.length - 1 || val.length() <= 0) continue;
                builder.append(", ");
            }
        } else {
            builder.append(CssValueConverter.retrieveValue(property, obj));
        }
        if (isDerive || isLadder) {
            builder.append(")");
        }
        return builder.toString();
    }

    private static String getRadiusCssString(String property, ParsedValue value) {
        assert (property.equals("-fx-background-radius") || property.equals("-fx-border-radius"));
        StringBuilder sbAll = new StringBuilder();
        Object obj = value.getValue();
        if (!(obj instanceof ParsedValue[])) {
            return null;
        }
        ParsedValue[] pvArray = (ParsedValue[])obj;
        int index = 0;
        for (ParsedValue pvItem : pvArray) {
            obj = pvItem.getValue();
            if (!(obj instanceof ParsedValue[][])) {
                return null;
            }
            ParsedValue[][] pvArray2 = (ParsedValue[][])obj;
            StringBuilder sbCornerRadii = new StringBuilder();
            Size initSize = null;
            boolean areEquals = true;
            int index2 = 0;
            ParsedValue[][] parsedValueArray = pvArray2;
            int n = parsedValueArray.length;
            for (int i = 0; i < n; ++i) {
                ParsedValue[] pvArray1;
                for (ParsedValue pvItem2 : pvArray1 = parsedValueArray[i]) {
                    obj = pvItem2.getValue();
                    if (!(obj instanceof Size)) {
                        return null;
                    }
                    Size size = (Size)obj;
                    sbCornerRadii.append(size).append(" ");
                    if (initSize == null) {
                        initSize = size;
                        continue;
                    }
                    if (initSize.equals((Object)size)) continue;
                    areEquals = false;
                }
                if (index2 != pvArray2.length - 1) {
                    sbCornerRadii.append(" / ");
                }
                ++index2;
            }
            if (areEquals) {
                sbAll.append(initSize);
            } else {
                sbAll.append(sbCornerRadii.toString().trim());
            }
            if (index != pvArray.length - 1) {
                sbAll.append(", ");
            }
            ++index;
        }
        return CssValueConverter.removeDotZeroPxPercent(sbAll.toString());
    }

    private static String retrieveValue(String property, Object eventValue) {
        if (eventValue instanceof ParsedValue) {
            eventValue = CssValueConverter.convert((ParsedValue)eventValue);
        }
        if (eventValue == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        if (eventValue instanceof List) {
            List values = (List)eventValue;
            int length = values.size();
            for (int i = 0; i < length; ++i) {
                String val = CssValueConverter.retrieveValue(property, values.get(i));
                builder.append(val);
                if (i >= length - 1 || val.length() <= 0) continue;
                builder.append(", ");
            }
        } else if (eventValue.getClass().isArray()) {
            int length = Array.getLength(eventValue);
            for (int i = 0; i < length; ++i) {
                String val = CssValueConverter.retrieveValue(property, Array.get(eventValue, i));
                builder.append(val);
                if (i >= length - 1 || val.length() <= 0) continue;
                builder.append(", ");
            }
        } else if (eventValue instanceof Background) {
            Background background = (Background)eventValue;
            if (background.getFills() != null) {
                return CssValueConverter.retrieveValue(property, background.getFills());
            }
            if (background.getImages() != null) {
                return CssValueConverter.retrieveValue(property, background.getImages());
            }
        } else if (eventValue instanceof Border) {
            Border border = (Border)eventValue;
            if (border.getStrokes() != null) {
                return CssValueConverter.retrieveValue(property, border.getStrokes());
            }
            if (border.getImages() != null) {
                return CssValueConverter.retrieveValue(property, border.getImages());
            }
        } else if (eventValue instanceof BackgroundFill) {
            builder.append(CssValueConverter.backgroundFillToString(property, (BackgroundFill)eventValue));
        } else if (eventValue instanceof CornerRadii) {
            builder.append(CssValueConverter.cornerRadiiToString(property, (CornerRadii)eventValue));
        } else if (eventValue instanceof BackgroundImage) {
            builder.append(CssValueConverter.backgroundImageToString(property, (BackgroundImage)eventValue));
        } else if (eventValue instanceof BorderStroke) {
            builder.append(CssValueConverter.borderStrokeToString(property, (BorderStroke)eventValue));
        } else if (eventValue instanceof BorderImage) {
            builder.append(CssValueConverter.borderImageToString(property, (BorderImage)eventValue));
        } else if (eventValue instanceof Font) {
            builder.append(CssValueConverter.fontToString(property, (Font)eventValue));
        } else if (eventValue instanceof Paint) {
            builder.append(CssValueConverter.paintToString((Paint)eventValue).toLowerCase(Locale.ROOT));
        } else if (eventValue instanceof Insets) {
            builder.append(CssValueConverter.insetsValue((Insets)eventValue));
        } else if (eventValue instanceof Effect) {
            builder.append(CssValueConverter.effectValue((Effect)eventValue));
        } else {
            String str = EditorUtils.valAsStr(eventValue);
            if (str == null) {
                str = "null";
            } else {
                str = str.replaceAll("\n", " ");
                str = str.split("@")[0];
                str = CssValueConverter.removeDotZeroPxPercent(str);
            }
            builder.append(str);
        }
        return builder.toString();
    }

    private static String getColorAsWebString(Color c) {
        int red = (int)Math.round(c.getRed() * 255.0);
        int green = (int)Math.round(c.getGreen() * 255.0);
        int blue = (int)Math.round(c.getBlue() * 255.0);
        int alpha = (int)Math.round(c.getOpacity() * 255.0);
        if (alpha == 255) {
            return String.format("#%02x%02x%02x", red, green, blue);
        }
        return String.format("#%02x%02x%02x%02x", red, green, blue, alpha);
    }

    private static String getColorAsString(Color color) {
        if (CssValueConverter.isStandardColor(color)) {
            return CssValueConverter.getStandardColorAsString(color);
        }
        return CssValueConverter.getColorAsWebString(color);
    }

    private static boolean isStandardColor(Color c) {
        return standardColors.containsKey(c);
    }

    private static String getStandardColorAsString(Color c) {
        return standardColors.get(c);
    }

    private static String backgroundFillToString(String property, BackgroundFill bf) {
        if (property == null) {
            return bf.toString();
        }
        StringBuilder builder = new StringBuilder();
        if (property.equals("-fx-background-color")) {
            Paint p = bf.getFill();
            builder.append(CssValueConverter.paintToString(p));
        } else if (property.equals("-fx-background-insets")) {
            builder.append(CssValueConverter.insetsValue(bf.getInsets()));
        } else if (property.equals("-fx-background-radius")) {
            CssValueConverter.handleCornerRadii(bf.getRadii(), builder);
        }
        return builder.toString();
    }

    private static String cornerRadiiToString(String property, CornerRadii cr) {
        if (property == null) {
            return cr.toString();
        }
        StringBuilder builder = new StringBuilder();
        CssValueConverter.handleCornerRadii(cr, builder);
        return builder.toString();
    }

    private static String backgroundImageToString(String property, BackgroundImage bi) {
        if (property == null) {
            return bi.toString();
        }
        StringBuilder builder = new StringBuilder();
        if (property.equals("-fx-background-image")) {
            Image p = bi.getImage();
            builder.append(p.getUrl());
        } else if (property.equals("-fx-background-position")) {
            double left = 0.0;
            double right = 0.0;
            double top = 0.0;
            double bottom = 0.0;
            if (bi.getPosition().getHorizontalSide() == Side.LEFT) {
                left = bi.getPosition().getHorizontalPosition();
            } else {
                right = bi.getPosition().getHorizontalPosition();
            }
            if (bi.getPosition().getVerticalSide() == Side.TOP) {
                top = bi.getPosition().getVerticalPosition();
            } else {
                bottom = bi.getPosition().getVerticalPosition();
            }
            builder.append("left:");
            builder.append(EditorUtils.valAsStr(left));
            builder.append(" right:");
            builder.append(EditorUtils.valAsStr(right));
            builder.append(" top:");
            builder.append(EditorUtils.valAsStr(top));
            builder.append(" bottom:");
            builder.append(EditorUtils.valAsStr(bottom));
        } else if (property.equals("-fx-background-repeat")) {
            if (bi.getRepeatX() != null) {
                builder.append(bi.getRepeatX().toString());
            } else if (bi.getRepeatY() != null) {
                builder.append(bi.getRepeatY().toString());
            } else {
                builder.append("unknown repeat");
            }
        } else if (property.equals("-fx-background-size")) {
            BackgroundSize bs = bi.getSize();
            if (bs.isContain()) {
                builder.append("contain");
            } else if (bs.isCover()) {
                builder.append("cover");
            } else {
                if (bs.getWidth() == -1.0) {
                    builder.append("width: auto");
                } else {
                    builder.append("width: ").append(EditorUtils.valAsStr(bs.getWidth()));
                }
                if (bs.getHeight() == -1.0) {
                    builder.append("height: auto");
                } else {
                    builder.append("height: ").append(EditorUtils.valAsStr(bs.getHeight()));
                }
            }
        }
        return builder.toString();
    }

    private static String borderImageToString(String property, BorderImage bi) {
        if (property == null) {
            return bi.toString();
        }
        StringBuilder builder = new StringBuilder();
        if (property.equals("-fx-border-image")) {
            Image p = bi.getImage();
            builder.append(p.getUrl());
        } else if (!property.equals("-fx-background-position")) {
            if (property.equals("-fx-border-image-repeat")) {
                if (bi.getRepeatX() != null) {
                    builder.append(bi.getRepeatX().toString());
                } else if (bi.getRepeatY() != null) {
                    builder.append(bi.getRepeatY().toString());
                } else {
                    builder.append("unknown repeat");
                }
            } else if (property.equals("-fx-border-image-insets")) {
                builder.append(CssValueConverter.insetsValue(bi.getInsets()));
            } else if (property.equals("-fx-border-image-width")) {
                BorderWidths bw = bi.getWidths();
                if (MathUtils.equals(bw.getTop(), bw.getBottom()) && MathUtils.equals(bw.getLeft(), bw.getRight())) {
                    builder.append(EditorUtils.valAsStr(bw.getTop()));
                } else {
                    builder.append(EditorUtils.valAsStr(bw.getTop())).append(" ").append(EditorUtils.valAsStr(bw.getRight())).append(" ").append(EditorUtils.valAsStr(bw.getBottom())).append(" ").append(EditorUtils.valAsStr(bw.getLeft()));
                }
            } else if (property.equals("-fx-border-image-slice")) {
                BorderWidths bw = bi.getSlices();
                if (MathUtils.equals(bw.getTop(), bw.getBottom()) && MathUtils.equals(bw.getLeft(), bw.getRight())) {
                    builder.append(EditorUtils.valAsStr(bw.getTop()));
                } else {
                    builder.append(EditorUtils.valAsStr(bw.getTop())).append(" ").append(EditorUtils.valAsStr(bw.getRight())).append(" ").append(EditorUtils.valAsStr(bw.getBottom())).append(" ").append(EditorUtils.valAsStr(bw.getLeft()));
                }
            }
        }
        return builder.toString();
    }

    private static String borderStrokeToString(String property, BorderStroke bs) {
        if (property == null) {
            return bs.toString();
        }
        StringBuilder builder = new StringBuilder();
        if (property.equals("-fx-border-color")) {
            if (bs.getTopStroke().equals(bs.getBottomStroke()) && bs.getRightStroke().equals(bs.getBottomStroke()) && bs.getLeftStroke().equals(bs.getBottomStroke())) {
                builder.append(CssValueConverter.paintToString(bs.getBottomStroke()));
            } else {
                builder.append(CssValueConverter.paintToString(bs.getTopStroke())).append(" ");
                builder.append(CssValueConverter.paintToString(bs.getRightStroke())).append(" ");
                builder.append(CssValueConverter.paintToString(bs.getBottomStroke())).append(" ");
                builder.append(CssValueConverter.paintToString(bs.getLeftStroke()));
            }
        } else if (property.equals("-fx-border-insets")) {
            builder.append(CssValueConverter.insetsValue(bs.getInsets()));
        } else if (property.equals("-fx-border-radius")) {
            CssValueConverter.handleCornerRadii(bs.getRadii(), builder);
        } else if (property.equals("-fx-border-style")) {
            builder.append(bs.getTopStyle().toString()).append(", ");
            builder.append(bs.getRightStyle().toString()).append(", ");
            builder.append(bs.getBottomStyle().toString()).append(", ");
            builder.append(bs.getLeftStyle().toString());
        } else if (property.equals("-fx-border-width")) {
            BorderWidths bw = bs.getWidths();
            if (MathUtils.equals(bw.getTop(), bw.getBottom()) && MathUtils.equals(bw.getRight(), bw.getBottom()) && MathUtils.equals(bw.getLeft(), bw.getBottom())) {
                builder.append(EditorUtils.valAsStr(bw.getBottom()));
            } else {
                builder.append(EditorUtils.valAsStr(bw.getTop())).append(" ").append(EditorUtils.valAsStr(bw.getRight())).append(" ").append(EditorUtils.valAsStr(bw.getBottom())).append(" ").append(EditorUtils.valAsStr(bw.getLeft()));
            }
        }
        return builder.toString();
    }

    private static String paintToString(Paint p) {
        if (p instanceof Color) {
            return CssValueConverter.getColorAsString((Color)p).toLowerCase(Locale.ROOT);
        }
        String gradient = p.toString();
        gradient = gradient.replaceAll("0x", "#");
        gradient = CssValueConverter.removeDotZeroPxPercent(gradient);
        return gradient;
    }

    private static String fontToString(String property, Font font) {
        if (property == null) {
            return CssValueConverter.removeAllDotZero(font.toString());
        }
        StringBuilder builder = new StringBuilder();
        if (property.equals("-fx-font")) {
            String size = EditorUtils.valAsStr(font.getSize());
            String previewStr = font.getFamily() + " " + size + "px" + (String)(!font.getName().equals(font.getFamily()) && !"Regular".equals(font.getStyle()) ? " (" + font.getStyle() + ")" : "");
            builder.append(previewStr);
        } else if (property.equals("-fx-font-size")) {
            double p = font.getSize();
            builder.append(EditorUtils.valAsStr(p)).append("px");
        } else if (property.equals("-fx-font-family")) {
            builder.append(font.getFamily());
        } else if (property.equals("-fx-font-weight")) {
            builder.append(CssValueConverter.removeAllDotZero(font.toString()));
        } else if (property.equals("-fx-font-style")) {
            builder.append(font.getStyle());
        }
        return builder.toString();
    }

    private static String insetsValue(Insets insets) {
        if (MathUtils.equals(insets.getBottom(), insets.getLeft()) && MathUtils.equals(insets.getRight(), insets.getLeft()) && MathUtils.equals(insets.getTop(), insets.getLeft())) {
            return EditorUtils.valAsStr(insets.getLeft());
        }
        return EditorUtils.valAsStr(insets.getTop()) + " " + EditorUtils.valAsStr(insets.getRight()) + " " + EditorUtils.valAsStr(insets.getBottom()) + " " + EditorUtils.valAsStr(insets.getLeft());
    }

    private static String effectValue(Effect effect) {
        StringBuilder strBuild = new StringBuilder();
        Effect adding = effect;
        while (adding != null) {
            strBuild.append(adding.getClass().getSimpleName());
            if ((adding = CssValueConverter.getEffectInput(adding)) == null) continue;
            strBuild.append(", ");
        }
        return strBuild.toString();
    }

    private static Object subBackgroundFill(String property, BackgroundFill bf) {
        if (property == null) {
            return bf;
        }
        if (property.equals("-fx-background-color")) {
            return bf.getFill();
        }
        if (property.equals("-fx-background-insets")) {
            return bf.getInsets();
        }
        return CssValueConverter.backgroundFillToString(property, bf);
    }

    private static Object subBackgroundImage(String property, BackgroundImage bi) {
        if (property == null) {
            return bi;
        }
        if (property.equals("-fx-background-image")) {
            return bi.getImage();
        }
        return CssValueConverter.backgroundImageToString(property, bi);
    }

    private static Object subBorderImage(String property, BorderImage bi) {
        if (property == null) {
            return bi;
        }
        if (property.equals("-fx-border-image")) {
            return bi.getImage();
        }
        return CssValueConverter.borderImageToString(property, bi);
    }

    private static Object subBorderStroke(String property, BorderStroke bs) {
        if (property == null) {
            return bs;
        }
        if (property.equals("-fx-border-color")) {
            if (bs.getTopStroke().equals(bs.getBottomStroke()) && bs.getRightStroke().equals(bs.getBottomStroke()) && bs.getLeftStroke().equals(bs.getBottomStroke())) {
                return bs.getBottomStroke();
            }
            Paint[] p = new Paint[]{bs.getTopStroke(), bs.getRightStroke(), bs.getBottomStroke(), bs.getLeftStroke()};
            return p;
        }
        if (property.equals("-fx-border-insets")) {
            return bs.getInsets();
        }
        return CssValueConverter.borderStrokeToString(property, bs);
    }

    private static Object subFont(String property, Font font) {
        if (property == null) {
            return font;
        }
        if (property.equals("-fx-font-size")) {
            return EditorUtils.valAsStr(font.getSize());
        }
        if (property.equals("-fx-font-style")) {
            return font.getStyle();
        }
        if (property.equals("-fx-font-family")) {
            return font.getFamily();
        }
        if (property.equals("-fx-font-weight")) {
            return font.getFamily() + " " + font.getStyle();
        }
        return font;
    }

    private static String removeDotZeroPxPercent(String str) {
        str = str.replaceAll("\\.0px", "px");
        str = str.replaceAll("\\.0em", "em");
        str = str.replaceAll("\\.0\\%", "%");
        return str;
    }

    private static String removeAllDotZero(String str) {
        str = str.replaceAll("\\.0", "");
        return str;
    }

    private static void handleCornerRadii(CornerRadii cr, StringBuilder builder) {
        double topLeftH = cr.getTopLeftHorizontalRadius();
        double topLeftV = cr.getTopLeftVerticalRadius();
        double topRightH = cr.getTopRightHorizontalRadius();
        double topRightV = cr.getTopRightVerticalRadius();
        double bottomLeftH = cr.getBottomLeftHorizontalRadius();
        double bottomLeftV = cr.getBottomLeftVerticalRadius();
        double bottomRightH = cr.getBottomRightHorizontalRadius();
        double bottomRightV = cr.getBottomRightVerticalRadius();
        if (MathUtils.equals(topLeftH, topLeftV) && MathUtils.equals(topRightH, topRightV) && MathUtils.equals(bottomLeftH, bottomLeftV) && MathUtils.equals(bottomRightH, bottomRightV)) {
            if (MathUtils.equals(topLeftH, topRightH) && MathUtils.equals(topRightH, bottomLeftH) && MathUtils.equals(bottomLeftH, bottomRightH)) {
                builder.append(EditorUtils.valAsStr(topLeftH));
            } else {
                builder.append(EditorUtils.valAsStr(topLeftH)).append(" ").append(EditorUtils.valAsStr(topRightH)).append(" ").append(EditorUtils.valAsStr(bottomRightH)).append(" ").append(EditorUtils.valAsStr(bottomLeftH));
            }
        } else {
            builder.append(EditorUtils.valAsStr(topLeftH)).append(" ").append(EditorUtils.valAsStr(topRightH)).append(" ").append(EditorUtils.valAsStr(bottomRightH)).append(" ").append(EditorUtils.valAsStr(bottomLeftH)).append(" / ").append(EditorUtils.valAsStr(topLeftV)).append(" ").append(EditorUtils.valAsStr(topRightV)).append(" ").append(EditorUtils.valAsStr(bottomRightV)).append(" ").append(EditorUtils.valAsStr(bottomLeftV));
        }
    }

    private static Effect getEffectInput(Effect effect) {
        Effect found = null;
        try {
            found = (Effect)effect.getClass().getMethod("getInput", new Class[0]).invoke((Object)effect, new Object[0]);
        }
        catch (Throwable e) {
            try {
                found = (Effect)effect.getClass().getMethod("getContentInput", new Class[0]).invoke((Object)effect, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return found;
    }

    static {
        STRING_VALUE.add("-fx-skin");
        STRING_VALUE.add("-fx-shape");
        SINGLE_WHEN_EQUALITY.add("-fx-padding");
        SINGLE_WHEN_EQUALITY.add("-fx-background-radius");
        SINGLE_WHEN_EQUALITY.add("-fx-background-insets");
        SINGLE_WHEN_EQUALITY.add("-fx-border-color");
        SINGLE_WHEN_EQUALITY.add("-fx-border-radius");
        SINGLE_WHEN_EQUALITY.add("-fx-border-insets");
        SINGLE_WHEN_EQUALITY.add("-fx-border-image-insets");
        SINGLE_WHEN_EQUALITY.add("-fx-border-image-slice");
        SINGLE_WHEN_EQUALITY.add("-fx-border-image-width");
        standardColors = ColorEncoder.getStandardColorNames();
    }
}

