/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy;

import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.AbstractHierarchyPanelController;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import javafx.scene.image.Image;

public class HierarchyItem {
    protected DesignHierarchyMask mask;

    public HierarchyItem() {
    }

    public HierarchyItem(FXOMObject fxomObject) {
        assert (fxomObject != null);
        this.mask = new DesignHierarchyMask(fxomObject);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HierarchyItem item = (HierarchyItem)obj;
        assert (this.getFxomObject() != null);
        return this.getFxomObject().equals(item.getFxomObject());
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + Objects.hashCode(this.mask);
        return hash;
    }

    public final DesignHierarchyMask getMask() {
        return this.mask;
    }

    public final FXOMObject getFxomObject() {
        return this.mask == null ? null : this.mask.getFxomObject();
    }

    public String getDescription() {
        return this.mask == null ? null : this.mask.getDescription();
    }

    public String getSingleLineDescription() {
        return this.mask == null ? null : this.mask.getSingleLineDescription();
    }

    public String getNodeId() {
        return this.mask == null ? null : this.mask.getNodeId();
    }

    public String getFxId() {
        return this.mask == null ? null : this.mask.getFxId();
    }

    public String getDisplayInfo(AbstractHierarchyPanelController.DisplayOption option) {
        if (this.mask == null) {
            return null;
        }
        Object sceneGraphObject = this.mask.getFxomObject().getSceneGraphObject();
        if (sceneGraphObject == null) {
            return null;
        }
        String info = null;
        switch (option) {
            case INFO: {
                info = this.getSingleLineDescription();
                break;
            }
            case FXID: {
                info = this.getFxId();
                break;
            }
            case NODEID: {
                info = this.getNodeId();
            }
        }
        return info;
    }

    public PropertyName getPropertyNameForDisplayInfo(AbstractHierarchyPanelController.DisplayOption option) {
        assert (this.mask != null);
        PropertyName propertyName = null;
        switch (option) {
            case INFO: {
                propertyName = this.mask.getPropertyNameForDescription();
                break;
            }
            case NODEID: {
                propertyName = new PropertyName("id");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return propertyName;
    }

    public boolean isResourceKey(AbstractHierarchyPanelController.DisplayOption option) {
        if (this.mask == null) {
            return false;
        }
        return option == AbstractHierarchyPanelController.DisplayOption.INFO && this.mask.isResourceKey();
    }

    public boolean isPlaceholder() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isAcceptingSubComponent(List<FXOMObject> fxomObjects) {
        return !this.isEmpty() && this.mask.isAcceptingSubComponent(fxomObjects);
    }

    public boolean isAcceptingAccessory(DesignHierarchyMask.Accessory accessory, FXOMObject fxomObject) {
        return !this.isEmpty() && this.mask.isAcceptingAccessory(accessory, fxomObject) && this.mask.getAccessory(accessory) == null;
    }

    public boolean hasDisplayInfo(AbstractHierarchyPanelController.DisplayOption option) {
        return this.mask != null && (option == AbstractHierarchyPanelController.DisplayOption.FXID || option == AbstractHierarchyPanelController.DisplayOption.NODEID || option == AbstractHierarchyPanelController.DisplayOption.INFO && this.mask.hasDescription());
    }

    public Image getPlaceholderImage() {
        return null;
    }

    public String getPlaceholderInfo() {
        return null;
    }

    public Image getClassNameIcon() {
        assert (this.mask != null);
        return this.mask.getClassNameIcon();
    }

    public URL getClassNameIconURL() {
        assert (this.mask != null);
        return this.mask.getClassNameIconURL();
    }

    public String getClassNameInfo() {
        assert (this.mask != null);
        return this.mask.getClassNameInfo();
    }
}

