/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy;

import com.oracle.javafx.scenebuilder.kit.editor.images.ImageUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.HierarchyItem;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.net.URL;
import java.util.Objects;
import javafx.scene.image.Image;

public class HierarchyItemGraphic
extends HierarchyItem {
    private final DesignHierarchyMask owner;

    public HierarchyItemGraphic(DesignHierarchyMask owner, FXOMObject fxomObject) {
        assert (owner != null);
        this.owner = owner;
        this.mask = fxomObject == null ? null : new DesignHierarchyMask(fxomObject);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HierarchyItemGraphic item = (HierarchyItemGraphic)obj;
        if (!this.isEmpty()) {
            assert (this.getFxomObject() != null);
            return this.getFxomObject().equals(item.getFxomObject());
        }
        return this.getOwner().equals(item.getOwner());
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Objects.hashCode(this.mask);
        hash = 37 * hash + Objects.hashCode(this.owner);
        return hash;
    }

    @Override
    public boolean isPlaceholder() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.mask == null;
    }

    public DesignHierarchyMask getOwner() {
        return this.owner;
    }

    @Override
    public Image getPlaceholderImage() {
        return ImageUtils.getNodeIcon("Graphic.png");
    }

    @Override
    public String getPlaceholderInfo() {
        return this.mask != null ? null : I18N.getString("hierarchy.placeholder.insert.graphic");
    }

    @Override
    public Image getClassNameIcon() {
        return this.mask == null ? null : this.mask.getClassNameIcon();
    }

    @Override
    public URL getClassNameIconURL() {
        return this.mask == null ? null : this.mask.getClassNameIconURL();
    }

    @Override
    public String getClassNameInfo() {
        return this.mask == null ? null : this.mask.getClassNameInfo();
    }
}

