/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.treeview;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.drag.DragController;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.AbstractDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.AccessoryDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.ContainerZDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.GridPaneDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.RootDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.images.ImageUtils;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ModifyFxIdJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ModifyObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.AbstractHierarchyPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.HierarchyDNDController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.HierarchyItem;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.treeview.HierarchyTreeViewUtils;
import com.oracle.javafx.scenebuilder.kit.editor.report.CSSParsingReport;
import com.oracle.javafx.scenebuilder.kit.editor.report.ErrorReport;
import com.oracle.javafx.scenebuilder.kit.editor.report.ErrorReportEntry;
import com.oracle.javafx.scenebuilder.kit.editor.util.InlineEditController;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNode;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.glossary.Glossary;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssParser;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Cell;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.DragEvent;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.util.Callback;

public class HierarchyTreeCell<T extends HierarchyItem>
extends TreeCell<HierarchyItem> {
    private final AbstractHierarchyPanelController panelController;
    static final String TREE_CELL_GRAPHIC = "tree-cell-graphic";
    public static final String HIERARCHY_FIRST_CELL = "hierarchy-first-cell";
    static final String HIERARCHY_PLACE_HOLDER_LABEL = "hierarchy-place-holder-label";
    static final String HIERARCHY_READWRITE_LABEL = "hierarchy-readwrite-label";
    static final String HIERARCHY_TREE_CELL = "hierarchy-tree-cell";
    private final HBox graphic = new HBox();
    private final Label placeHolderLabel = new Label();
    private final Label classNameInfoLabel = new Label();
    private final Label displayInfoLabel = new Label();
    private final ImageView placeHolderImageView = new ImageView();
    private final ImageView classNameImageView = new ImageView();
    private final ImageView warningBadgeImageView = new ImageView();
    private final ImageView includedFileImageView = new ImageView();
    private final StackPane iconsStack = new StackPane();
    private final Label iconsLabel = new Label();
    private final Tooltip warningBadgeTooltip = new Tooltip();
    private final Line insertLineIndicator = new Line();
    final ChangeListener<AbstractHierarchyPanelController.DisplayOption> displayOptionListener = (ov, t, t1) -> {
        if (!this.isEmpty() && this.getItem() != null && !((HierarchyItem)this.getItem()).isEmpty()) {
            String displayInfo = ((HierarchyItem)this.getItem()).getDisplayInfo((AbstractHierarchyPanelController.DisplayOption)((Object)t1));
            this.displayInfoLabel.setText(displayInfo);
            this.displayInfoLabel.setManaged(((HierarchyItem)this.getItem()).hasDisplayInfo((AbstractHierarchyPanelController.DisplayOption)((Object)t1)));
            this.displayInfoLabel.setVisible(((HierarchyItem)this.getItem()).hasDisplayInfo((AbstractHierarchyPanelController.DisplayOption)((Object)t1)));
        }
    };

    public HierarchyTreeCell(AbstractHierarchyPanelController c) {
        this.panelController = c;
        this.iconsStack.getChildren().setAll((Object[])new Node[]{this.classNameImageView, this.warningBadgeImageView});
        this.iconsLabel.setGraphic((Node)this.iconsStack);
        this.graphic.getChildren().setAll((Object[])new Node[]{this.includedFileImageView, this.placeHolderImageView, this.iconsLabel, this.placeHolderLabel, this.classNameInfoLabel, this.displayInfoLabel});
        this.getStyleClass().add((Object)HIERARCHY_TREE_CELL);
        this.insertLineIndicator.setStrokeWidth(2.0);
        this.graphic.getStyleClass().add((Object)TREE_CELL_GRAPHIC);
        this.updatePlaceHolder();
        this.displayInfoLabel.getStyleClass().add((Object)HIERARCHY_READWRITE_LABEL);
        this.placeHolderLabel.getStyleClass().add((Object)HIERARCHY_PLACE_HOLDER_LABEL);
        this.classNameInfoLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        this.displayInfoLabel.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)this.displayInfoLabel, (Priority)Priority.ALWAYS);
        this.panelController.displayOptionProperty().addListener((ChangeListener)new WeakChangeListener(this.displayOptionListener));
        EventHandler keyEventHandler = e -> this.filterKeyEvent((KeyEvent)e);
        this.addEventFilter(KeyEvent.ANY, keyEventHandler);
        EventHandler mouseEventHandler = e -> this.filterMouseEvent((MouseEvent)e);
        this.addEventFilter(MouseEvent.ANY, mouseEventHandler);
        HierarchyDNDController dndController = this.panelController.getDNDController();
        this.setOnDragDropped(event -> {
            TreeItem treeItem = this.getTreeItem();
            dndController.handleOnDragDropped((TreeItem<HierarchyItem>)treeItem, (DragEvent)event);
            this.panelController.clearBorderColor((Cell<?>)this);
            this.panelController.removeFromPanelControlSkin((Node)this.insertLineIndicator);
        });
        this.setOnDragEntered(event -> {
            TreeItem treeItem = this.getTreeItem();
            dndController.handleOnDragEntered((TreeItem<HierarchyItem>)treeItem, (DragEvent)event);
        });
        this.setOnDragExited(event -> {
            TreeItem treeItem = this.getTreeItem();
            Bounds bounds = this.getLayoutBounds();
            Point2D point = this.localToScene(bounds.getMinX(), bounds.getMinY(), true);
            HierarchyDNDController.DroppingMouseLocation location = event.getSceneY() <= point.getY() ? HierarchyDNDController.DroppingMouseLocation.TOP : HierarchyDNDController.DroppingMouseLocation.BOTTOM;
            dndController.handleOnDragExited((TreeItem<HierarchyItem>)treeItem, (DragEvent)event, location);
            this.panelController.clearBorderColor((Cell<?>)this);
            this.panelController.removeFromPanelControlSkin((Node)this.insertLineIndicator);
        });
        this.setOnDragOver(event -> {
            TreeItem treeItem = this.getTreeItem();
            DragController dragController = this.panelController.getEditorController().getDragController();
            HierarchyDNDController.DroppingMouseLocation location = this.getDroppingMouseLocation((DragEvent)event);
            dndController.handleOnDragOver((TreeItem<HierarchyItem>)treeItem, (DragEvent)event, location);
            this.panelController.clearBorderColor();
            Paint paint = this.panelController.getParentRingColor();
            this.insertLineIndicator.setStroke(paint);
            this.panelController.removeFromPanelControlSkin((Node)this.insertLineIndicator);
            if (this.panelController.isTimelineRunning()) {
                return;
            }
            if (dragController.isDropAccepted()) {
                AbstractDropTarget dropTarget = dragController.getDropTarget();
                FXOMObject dropTargetObject = dropTarget.getTargetObject();
                TreeItem rootTreeItem = this.getTreeView().getRoot();
                if (dropTarget instanceof RootDropTarget) {
                    return;
                }
                if (dropTarget instanceof AccessoryDropTarget) {
                    TreeCell<?> cell;
                    AccessoryDropTarget accessoryDropTarget = (AccessoryDropTarget)dropTarget;
                    if (treeItem == null) {
                        cell = HierarchyTreeViewUtils.getTreeCell(this.getTreeView(), rootTreeItem);
                    } else {
                        HierarchyItem item = (HierarchyItem)treeItem.getValue();
                        assert (item != null);
                        if (item.isPlaceholder()) {
                            cell = this;
                        } else if (accessoryDropTarget.getAccessory() == DesignHierarchyMask.Accessory.GRAPHIC) {
                            TreeItem<HierarchyItem> graphicTreeItem = dndController.getEmptyGraphicTreeItemFor((TreeItem<HierarchyItem>)treeItem);
                            if (graphicTreeItem != null) {
                                cell = HierarchyTreeViewUtils.getTreeCell(this.getTreeView(), graphicTreeItem);
                            } else {
                                TreeItem<HierarchyItem> accessoryOwnerTreeItem1 = this.panelController.lookupTreeItem(dropTargetObject);
                                cell = HierarchyTreeViewUtils.getTreeCell(this.getTreeView(), accessoryOwnerTreeItem1);
                            }
                        } else {
                            TreeItem<HierarchyItem> accessoryOwnerTreeItem2 = this.panelController.lookupTreeItem(dropTargetObject);
                            cell = HierarchyTreeViewUtils.getTreeCell(this.getTreeView(), accessoryOwnerTreeItem2);
                        }
                    }
                    this.panelController.setBorder((Cell<?>)cell, AbstractHierarchyPanelController.BorderSide.TOP_RIGHT_BOTTOM_LEFT);
                } else {
                    assert (dropTarget instanceof ContainerZDropTarget || dropTarget instanceof GridPaneDropTarget);
                    if (treeItem == null) {
                        if (rootTreeItem.isLeaf() || !rootTreeItem.isExpanded()) {
                            TreeCell<?> rootCell = HierarchyTreeViewUtils.getTreeCell(this.getTreeView(), 0);
                            this.panelController.setBorder((Cell<?>)rootCell, AbstractHierarchyPanelController.BorderSide.TOP_RIGHT_BOTTOM_LEFT);
                        } else {
                            TreeItem lastTreeItem = this.panelController.getLastVisibleTreeItem(rootTreeItem);
                            TreeCell<?> lastCell = HierarchyTreeViewUtils.getTreeCell(this.getTreeView(), lastTreeItem);
                            assert (lastCell != null);
                            this.panelController.setBorder((Cell<?>)lastCell, AbstractHierarchyPanelController.BorderSide.BOTTOM);
                            TreeItem startTreeItem = rootTreeItem;
                            TreeCell<?> startCell = HierarchyTreeViewUtils.getTreeCell(this.getTreeView(), startTreeItem);
                            TreeCell<?> stopCell = lastCell;
                            this.updateInsertLineIndicator(startCell, stopCell);
                            this.panelController.addToPanelControlSkin((Node)this.insertLineIndicator);
                        }
                    } else {
                        HierarchyItem item = (HierarchyItem)treeItem.getValue();
                        assert (item != null);
                        if (item.isPlaceholder() || item.getFxomObject() == dropTargetObject) {
                            this.panelController.setBorder((Cell<?>)this, AbstractHierarchyPanelController.BorderSide.TOP_RIGHT_BOTTOM_LEFT);
                        } else {
                            switch (location) {
                                case TOP: {
                                    if (treeItem == rootTreeItem) {
                                        this.panelController.setBorder((Cell<?>)this, AbstractHierarchyPanelController.BorderSide.TOP_RIGHT_BOTTOM_LEFT);
                                        break;
                                    }
                                    int index = this.getIndex();
                                    TreeCell<?> previousCell = HierarchyTreeViewUtils.getTreeCell(this.getTreeView(), index - 1);
                                    if (previousCell != null) {
                                        this.panelController.setBorder((Cell<?>)previousCell, AbstractHierarchyPanelController.BorderSide.BOTTOM);
                                    }
                                    TreeItem<HierarchyItem> startTreeItem = this.panelController.lookupTreeItem(dropTarget.getTargetObject());
                                    TreeCell<?> startCell = HierarchyTreeViewUtils.getTreeCell(this.getTreeView(), startTreeItem);
                                    TreeCell<?> stopCell = previousCell;
                                    this.updateInsertLineIndicator(startCell, stopCell);
                                    this.panelController.addToPanelControlSkin((Node)this.insertLineIndicator);
                                    break;
                                }
                                case CENTER: {
                                    if (treeItem.isLeaf() || !treeItem.isExpanded()) {
                                        this.panelController.setBorder((Cell<?>)this, AbstractHierarchyPanelController.BorderSide.TOP_RIGHT_BOTTOM_LEFT);
                                        break;
                                    }
                                    TreeItem lastTreeItem = this.panelController.getLastVisibleTreeItem(treeItem);
                                    TreeCell<?> lastCell = HierarchyTreeViewUtils.getTreeCell(this.getTreeView(), lastTreeItem);
                                    if (lastCell != null) {
                                        this.panelController.setBorder((Cell<?>)lastCell, AbstractHierarchyPanelController.BorderSide.BOTTOM);
                                    }
                                    TreeItem startTreeItem = this.getTreeItem();
                                    TreeCell<?> startCell = HierarchyTreeViewUtils.getTreeCell(this.getTreeView(), startTreeItem);
                                    TreeCell<?> stopCell = lastCell;
                                    this.updateInsertLineIndicator(startCell, stopCell);
                                    this.panelController.addToPanelControlSkin((Node)this.insertLineIndicator);
                                    break;
                                }
                                case BOTTOM: {
                                    if (treeItem == rootTreeItem && (treeItem.isLeaf() || !treeItem.isExpanded())) {
                                        this.panelController.setBorder((Cell<?>)this, AbstractHierarchyPanelController.BorderSide.TOP_RIGHT_BOTTOM_LEFT);
                                        break;
                                    }
                                    this.panelController.setBorder((Cell<?>)this, AbstractHierarchyPanelController.BorderSide.BOTTOM);
                                    TreeItem<HierarchyItem> startTreeItem = this.panelController.lookupTreeItem(dropTarget.getTargetObject());
                                    TreeCell<?> startCell = HierarchyTreeViewUtils.getTreeCell(this.getTreeView(), startTreeItem);
                                    TreeCell<?> stopCell = this;
                                    this.updateInsertLineIndicator(startCell, stopCell);
                                    this.panelController.addToPanelControlSkin((Node)this.insertLineIndicator);
                                    break;
                                }
                                default: {
                                    assert (false);
                                    break;
                                }
                            }
                        }
                    }
                }
            }
        });
    }

    public void updateItem(HierarchyItem item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (!empty && item != null) {
            this.updateLayout(item);
            this.setGraphic((Node)this.graphic);
            this.setText(null);
            this.panelController.updateParentRing();
        } else {
            assert (item == null);
            this.setGraphic(null);
            this.setText(null);
            this.panelController.clearBorderColor((Cell<?>)this);
        }
    }

    public final void updatePlaceHolder() {
        Paint paint = this.panelController.getParentRingColor();
        this.placeHolderLabel.setTextFill(paint);
        BorderWidths bw = new BorderWidths(1.0);
        BorderStroke bs = new BorderStroke(paint, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, bw);
        Border b = new Border(new BorderStroke[]{bs});
        this.placeHolderLabel.setBorder(b);
    }

    private void filterKeyEvent(KeyEvent ke) {
    }

    private void filterMouseEvent(MouseEvent me) {
        if (me.getEventType() == MouseEvent.MOUSE_PRESSED && me.getButton() == MouseButton.PRIMARY) {
            if (!this.isEmpty()) {
                if (me.getClickCount() >= 2) {
                    HierarchyItem item = (HierarchyItem)this.getItem();
                    assert (item != null);
                    AbstractHierarchyPanelController.DisplayOption option = this.panelController.getDisplayOption();
                    if (item.hasDisplayInfo(option) && !item.isResourceKey(option) && this.displayInfoLabel.isHover()) {
                        this.startEditingDisplayInfo();
                        me.consume();
                    }
                }
            } else {
                this.getTreeView().getSelectionModel().clearSelection();
            }
        }
        this.updateCursor(me);
    }

    private void updateCursor(MouseEvent me) {
        Scene scene = this.getScene();
        if (scene == null) {
            return;
        }
        if (!this.getScene().getWindow().isFocused()) {
            scene.setCursor(Cursor.DEFAULT);
            return;
        }
        if (this.isEmpty()) {
            scene.setCursor(Cursor.DEFAULT);
        } else {
            TreeItem rootTreeItem = this.getTreeView().getRoot();
            HierarchyItem item = (HierarchyItem)this.getTreeItem().getValue();
            assert (item != null);
            boolean isRoot = this.getTreeItem() == rootTreeItem;
            boolean isEmpty = item.isEmpty();
            if (me.getEventType() == MouseEvent.MOUSE_ENTERED) {
                if (!me.isPrimaryButtonDown()) {
                    if (isRoot || isEmpty) {
                        this.setCursor(Cursor.DEFAULT);
                    } else {
                        this.setCursor(Cursor.OPEN_HAND);
                    }
                }
            } else if (me.getEventType() == MouseEvent.MOUSE_PRESSED) {
                if (isRoot || isEmpty) {
                    this.setCursor(Cursor.DEFAULT);
                } else {
                    this.setCursor(Cursor.CLOSED_HAND);
                }
            } else if (me.getEventType() == MouseEvent.MOUSE_RELEASED) {
                if (isRoot || isEmpty) {
                    this.setCursor(Cursor.DEFAULT);
                } else {
                    this.setCursor(Cursor.OPEN_HAND);
                }
            } else if (me.getEventType() == MouseEvent.MOUSE_EXITED) {
                this.setCursor(Cursor.DEFAULT);
            }
        }
    }

    public void startEditingDisplayInfo() {
        String initialValue;
        InlineEditController.Type type;
        assert (((HierarchyItem)this.getItem()).hasDisplayInfo(this.panelController.getDisplayOption()));
        InlineEditController inlineEditController = this.panelController.getEditorController().getInlineEditController();
        if (this.panelController.getDisplayOption() == AbstractHierarchyPanelController.DisplayOption.INFO) {
            String info = ((HierarchyItem)this.getItem()).getDescription();
            Object sceneGraphObject = ((HierarchyItem)this.getItem()).getFxomObject().getSceneGraphObject();
            type = sceneGraphObject instanceof TextArea || DesignHierarchyMask.containsLineFeed(info) ? InlineEditController.Type.TEXT_AREA : InlineEditController.Type.TEXT_FIELD;
            initialValue = ((HierarchyItem)this.getItem()).getDescription();
        } else {
            type = InlineEditController.Type.TEXT_FIELD;
            initialValue = this.displayInfoLabel.getText();
        }
        TextInputControl editor = inlineEditController.createTextInputControl(type, (Node)this.displayInfoLabel, initialValue);
        ObservableList styleSheets = this.panelController.getPanelRoot().getStylesheets();
        editor.getStylesheets().addAll((Collection)styleSheets);
        editor.getStyleClass().add((Object)"theme-presets");
        editor.getStyleClass().add((Object)"inline-editor");
        Callback requestCommit = newValue -> {
            HierarchyItem item = (HierarchyItem)this.getItem();
            if (item != null) {
                FXOMObject fxomObject = item.getFxomObject();
                AbstractHierarchyPanelController.DisplayOption option = this.panelController.getDisplayOption();
                EditorController editorController = this.panelController.getEditorController();
                switch (option) {
                    case INFO: 
                    case NODEID: {
                        if (!(fxomObject instanceof FXOMInstance)) break;
                        FXOMInstance fxomInstance = (FXOMInstance)fxomObject;
                        PropertyName propertyName = item.getPropertyNameForDisplayInfo(option);
                        assert (propertyName != null);
                        ValuePropertyMetadata vpm = Metadata.getMetadata().queryValueProperty(fxomInstance, propertyName);
                        ModifyObjectJob job1 = new ModifyObjectJob(fxomInstance, vpm, newValue, editorController);
                        if (!job1.isExecutable()) break;
                        editorController.getJobManager().push(job1);
                        break;
                    }
                    case FXID: {
                        assert (newValue != null);
                        String fxId = newValue.isEmpty() ? null : newValue;
                        ModifyFxIdJob job2 = new ModifyFxIdJob(fxomObject, fxId, editorController);
                        if (job2.isExecutable()) {
                            FXOMDocument fxomDocument;
                            Set<String> fxIds2;
                            String controllerClass = editorController.getFxomDocument().getFxomRoot().getFxController();
                            if (controllerClass != null && fxId != null) {
                                URL location = editorController.getFxmlLocation();
                                Class<?> clazz = fxomObject.getSceneGraphObject() == null ? null : fxomObject.getSceneGraphObject().getClass();
                                Glossary glossary = editorController.getGlossary();
                                List<String> fxIds1 = glossary.queryFxIds(location, controllerClass, clazz);
                                if (!fxIds1.contains(fxId)) {
                                    editorController.getMessageLog().logWarningMessage("log.warning.no.injectable.fxid", fxId);
                                }
                            }
                            if ((fxIds2 = (fxomDocument = editorController.getFxomDocument()).collectFxIds().keySet()).contains(fxId)) {
                                editorController.getMessageLog().logWarningMessage("log.warning.duplicate.fxid", fxId);
                            }
                            editorController.getJobManager().push(job2);
                            break;
                        }
                        if (fxId == null) break;
                        editorController.getMessageLog().logWarningMessage("log.warning.invalid.fxid", fxId);
                        break;
                    }
                    default: {
                        assert (false);
                        return false;
                    }
                }
            }
            return true;
        };
        inlineEditController.startEditingSession(editor, (Node)this.displayInfoLabel, (Callback<String, Boolean>)requestCommit, null);
    }

    private void updateLayout(HierarchyItem item) {
        assert (item != null);
        FXOMObject fxomObject = item.getFxomObject();
        this.getStyleClass().removeAll((Object[])new String[]{HIERARCHY_FIRST_CELL});
        if (fxomObject != null && fxomObject.getParentObject() == null) {
            this.getStyleClass().add((Object)HIERARCHY_FIRST_CELL);
        }
        Image placeHolderImage = item.getPlaceholderImage();
        this.placeHolderImageView.setImage(placeHolderImage);
        this.placeHolderImageView.setManaged(placeHolderImage != null);
        Image classNameImage = item.getClassNameIcon();
        this.classNameImageView.setImage(classNameImage);
        this.classNameImageView.setManaged(classNameImage != null);
        if (fxomObject instanceof FXOMIntrinsic && ((FXOMIntrinsic)fxomObject).getType() == FXOMIntrinsic.Type.FX_INCLUDE) {
            URL resource = ImageUtils.getNodeIconURL("Included.png");
            this.includedFileImageView.setImage(ImageUtils.getImage(resource));
            this.includedFileImageView.setManaged(true);
        } else {
            this.includedFileImageView.setImage(null);
            this.includedFileImageView.setManaged(false);
        }
        List<ErrorReportEntry> entries = this.getErrorReportEntries(item);
        if (entries != null) {
            assert (!entries.isEmpty());
            ErrorReportEntry entry = entries.get(0);
            this.warningBadgeTooltip.setText(this.getErrorReport(entry));
            this.warningBadgeImageView.setImage(ImageUtils.getWarningBadgeImage());
            this.warningBadgeImageView.setManaged(true);
            this.iconsLabel.setTooltip(this.warningBadgeTooltip);
        } else {
            this.warningBadgeTooltip.setText(null);
            this.warningBadgeImageView.setImage(null);
            this.warningBadgeImageView.setManaged(false);
            this.iconsLabel.setTooltip(null);
        }
        String placeHolderInfo = item.getPlaceholderInfo();
        this.placeHolderLabel.setText(placeHolderInfo);
        this.placeHolderLabel.setManaged(item.isEmpty());
        this.placeHolderLabel.setVisible(item.isEmpty());
        String classNameInfo = item.getClassNameInfo();
        this.classNameInfoLabel.setText(classNameInfo);
        this.classNameInfoLabel.setManaged(classNameInfo != null);
        this.classNameInfoLabel.setVisible(classNameInfo != null);
        AbstractHierarchyPanelController.DisplayOption option = this.panelController.getDisplayOption();
        String displayInfo = item.getDisplayInfo(option);
        if (item.isResourceKey(option)) {
            this.displayInfoLabel.getStyleClass().removeAll((Object[])new String[]{HIERARCHY_READWRITE_LABEL});
        } else if (!this.displayInfoLabel.getStyleClass().contains((Object)HIERARCHY_READWRITE_LABEL)) {
            this.displayInfoLabel.getStyleClass().add((Object)HIERARCHY_READWRITE_LABEL);
        }
        this.displayInfoLabel.setText(displayInfo);
        this.displayInfoLabel.setManaged(item.hasDisplayInfo(option));
        this.displayInfoLabel.setVisible(item.hasDisplayInfo(option));
    }

    private List<ErrorReportEntry> getErrorReportEntries(HierarchyItem item) {
        if (item == null || item.isEmpty()) {
            return null;
        }
        EditorController editorController = this.panelController.getEditorController();
        ErrorReport errorReport = editorController.getErrorReport();
        FXOMObject fxomObject = item.getFxomObject();
        assert (fxomObject != null);
        return errorReport.query(fxomObject, !this.getTreeItem().isExpanded());
    }

    public String getErrorReport(ErrorReportEntry entry) {
        StringBuilder result = new StringBuilder();
        FXOMNode fxomNode = entry.getFxomNode();
        switch (entry.getType()) {
            case UNRESOLVED_CLASS: {
                result.append(I18N.getString("hierarchy.unresolved.class"));
                break;
            }
            case UNRESOLVED_LOCATION: {
                result.append(I18N.getString("hierarchy.unresolved.location"));
                break;
            }
            case UNRESOLVED_RESOURCE: {
                result.append(I18N.getString("hierarchy.unresolved.resource"));
                break;
            }
            case INVALID_CSS_CONTENT: {
                assert (entry.getCssParsingReport() != null);
                result.append(this.makeCssParsingErrorString(entry.getCssParsingReport()));
                break;
            }
            case UNSUPPORTED_EXPRESSION: {
                result.append(I18N.getString("hierarchy.unsupported.expression"));
            }
        }
        result.append(" ");
        if (fxomNode instanceof FXOMPropertyT) {
            FXOMPropertyT fxomProperty = (FXOMPropertyT)fxomNode;
            result.append(fxomProperty.getValue());
        } else if (fxomNode instanceof FXOMIntrinsic) {
            FXOMIntrinsic fxomIntrinsic = (FXOMIntrinsic)fxomNode;
            result.append(fxomIntrinsic.getSource());
        } else if (fxomNode instanceof FXOMObject) {
            FXOMObject fxomObject = (FXOMObject)fxomNode;
            DesignHierarchyMask mask = new DesignHierarchyMask(fxomObject);
            result.append(mask.getClassNameInfo());
        }
        return result.toString();
    }

    private void updateInsertLineIndicator(TreeCell<?> startTreeCell, TreeCell<?> stopTreeCell) {
        double endY;
        double startY;
        double startX;
        if (startTreeCell != null) {
            Node disclosureNode = startTreeCell.getDisclosureNode();
            Bounds startBounds = startTreeCell.getLayoutBounds();
            Point2D startCellPoint = startTreeCell.localToParent(startBounds.getMinX(), startBounds.getMinY());
            Bounds disclosureNodeBounds = disclosureNode.getLayoutBounds();
            Point2D disclosureNodePoint = disclosureNode.localToParent(disclosureNodeBounds.getMinX(), disclosureNodeBounds.getMinY());
            startX = startCellPoint.getX() + disclosureNodePoint.getX() + disclosureNodeBounds.getWidth() / 2.0 + 1.0;
            startY = startCellPoint.getY() + disclosureNodePoint.getY() + disclosureNodeBounds.getHeight() - 6.0;
        } else {
            Bounds graphicBounds = this.getGraphic().getLayoutBounds();
            Point2D graphicPoint = this.getGraphic().localToParent(graphicBounds.getMinX(), graphicBounds.getMinY());
            startX = graphicPoint.getX();
            startY = this.panelController.getContentTopY();
        }
        double endX = startX;
        if (stopTreeCell != null) {
            Bounds stopBounds = stopTreeCell.getLayoutBounds();
            Point2D stopCellPoint = stopTreeCell.localToParent(stopBounds.getMinX(), stopBounds.getMinY());
            endY = stopCellPoint.getY() + stopBounds.getHeight() - 1.0;
        } else {
            endY = this.panelController.getContentBottomY();
        }
        this.insertLineIndicator.setStartX(startX);
        this.insertLineIndicator.setStartY(startY);
        this.insertLineIndicator.setEndX(endX);
        this.insertLineIndicator.setEndY(endY);
    }

    private HierarchyDNDController.DroppingMouseLocation getDroppingMouseLocation(DragEvent event) {
        HierarchyDNDController.DroppingMouseLocation location = this.getTreeItem() != null ? (this.getHeight() * 0.25 > event.getY() ? HierarchyDNDController.DroppingMouseLocation.TOP : (this.getHeight() * 0.75 < event.getY() ? HierarchyDNDController.DroppingMouseLocation.BOTTOM : HierarchyDNDController.DroppingMouseLocation.CENTER)) : HierarchyDNDController.DroppingMouseLocation.BOTTOM;
        return location;
    }

    private String makeCssParsingErrorString(CSSParsingReport r) {
        StringBuilder result = new StringBuilder();
        if (r.getIOException() != null) {
            result.append(r.getIOException());
        } else {
            assert (!r.getParseErrors().isEmpty());
            int errorCount = 0;
            for (CssParser.ParseError e : r.getParseErrors()) {
                result.append(e.getMessage());
                if (++errorCount < 5) {
                    result.append('\n');
                    continue;
                }
                result.append("...");
                break;
            }
        }
        return result.toString();
    }
}

