/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.info;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ModifyFxControllerJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ToggleFxRootJob;
import com.oracle.javafx.scenebuilder.kit.editor.panel.info.IndexEntry;
import com.oracle.javafx.scenebuilder.kit.editor.panel.info.LeftCell;
import com.oracle.javafx.scenebuilder.kit.editor.panel.info.RightCell;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.ControllerClassEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.glossary.Glossary;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

public class InfoPanelController
extends AbstractFxmlPanelController {
    @FXML
    private TableColumn<IndexEntry, String> leftTableColumn;
    @FXML
    private TableColumn<IndexEntry, FXOMObject> rightTableColumn;
    @FXML
    private Label bottomLabel;
    @FXML
    private VBox controllerClassVBox;
    @FXML
    CheckBox fxrootCheckBox;
    @FXML
    HBox controllerAndCogHBox;
    private IndexEntry.Type entryType = IndexEntry.Type.FX_ID;
    private ControllerClassEditor controllerClassEditor;
    private boolean controllerDidLoadFxmlOver = false;
    private static final String IGNORED = "ignored";
    private final ListChangeListener<IndexEntry> tableViewSelectionListener = change -> this.tableSelectionDidChange();
    private final ChangeListener<Boolean> checkBoxListener = (ov, t, t1) -> this.toggleFxRoot();

    public InfoPanelController(EditorController editorController) {
        super(InfoPanelController.class.getResource("InfoPanel.fxml"), I18N.getBundle(), editorController);
    }

    public IndexEntry.Type getEntryType() {
        return this.entryType;
    }

    public void setEntryType(IndexEntry.Type entryType) {
        this.entryType = entryType;
        this.updateEntriesNow();
    }

    @Override
    protected void fxomDocumentDidChange(FXOMDocument oldDocument) {
        this.requestEntriesUpdate();
        this.updateAsPerRootNodeStatus();
        this.updateControllerAndControllerClassEditor();
        if (this.fxrootCheckBox != null) {
            this.fxrootCheckBox.selectedProperty().removeListener(this.checkBoxListener);
            this.fxrootCheckBox.setSelected(this.isFxRoot());
            this.fxrootCheckBox.selectedProperty().addListener(this.checkBoxListener);
        }
    }

    @Override
    protected void sceneGraphRevisionDidChange() {
        this.requestEntriesUpdate();
        this.updateAsPerRootNodeStatus();
    }

    @Override
    protected void cssRevisionDidChange() {
    }

    @Override
    protected void jobManagerRevisionDidChange() {
        this.requestEntriesUpdate();
        this.updateAsPerRootNodeStatus();
        this.updateControllerClassEditor();
        this.fxrootCheckBox.selectedProperty().removeListener(this.checkBoxListener);
        this.fxrootCheckBox.setSelected(this.isFxRoot());
        this.fxrootCheckBox.selectedProperty().addListener(this.checkBoxListener);
    }

    @Override
    protected void editorSelectionDidChange() {
        Selection selection = this.getEditorController().getSelection();
        HashSet<IndexEntry> selectedEntries = new HashSet<IndexEntry>();
        if (selection.getGroup() instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
            selectedEntries.addAll(this.searchIndexEntries(osg.getItems()));
        } else if (selection.getGroup() instanceof GridSelectionGroup) {
            GridSelectionGroup gsg = (GridSelectionGroup)selection.getGroup();
            selectedEntries.addAll(this.searchIndexEntries(Collections.singleton(gsg.getParentObject())));
        }
        TableView tableView = this.leftTableColumn.getTableView();
        this.stopListeningToTableViewSelection();
        tableView.getSelectionModel().clearSelection();
        for (IndexEntry e : selectedEntries) {
            tableView.getSelectionModel().select((Object)e);
        }
        this.startListeningToTableViewSelection();
    }

    @Override
    protected void controllerDidLoadFxml() {
        assert (this.leftTableColumn != null);
        assert (this.rightTableColumn != null);
        assert (this.leftTableColumn.getTableView() == this.rightTableColumn.getTableView());
        assert (this.bottomLabel != null);
        assert (this.controllerClassVBox != null);
        assert (this.fxrootCheckBox != null);
        assert (this.controllerAndCogHBox != null);
        this.performInitialization();
    }

    private void performInitialization() {
        if (this.controllerClassEditor != null) {
            this.controllerClassEditor.reset(this.getSuggestedControllerClasses(null));
        } else {
            this.controllerClassEditor = new ControllerClassEditor(this.getSuggestedControllerClasses(null));
        }
        HBox propNameNode = this.controllerClassEditor.getPropNameNode();
        propNameNode.setAlignment(Pos.CENTER_LEFT);
        this.controllerClassVBox.getChildren().add(0, (Object)propNameNode);
        this.controllerAndCogHBox.getChildren().add((Object)this.controllerClassEditor.getValueEditor());
        this.controllerAndCogHBox.getChildren().add((Object)this.controllerClassEditor.getMenu());
        this.controllerClassEditor.valueProperty().addListener((ov, t, t1) -> this.updateControllerAndControllerClassEditor((String)t1));
        this.getEditorController().fxmlLocationProperty().addListener((ov, t, t1) -> {
            if (t1 != null) {
                this.resetSuggestedControllerClasses((URL)t1);
            }
        });
        this.controllerClassEditor.getTextField().focusedProperty().addListener((ov, t, t1) -> {
            if (!t1.booleanValue()) {
                this.updateControllerAndControllerClassEditor(this.controllerClassEditor.getTextField().getText());
            }
        });
        this.leftTableColumn.setCellValueFactory((Callback)new PropertyValueFactory("key"));
        this.rightTableColumn.setCellValueFactory((Callback)new PropertyValueFactory("fxomObject"));
        this.leftTableColumn.setCellFactory((Callback)new LeftCell.Factory());
        this.rightTableColumn.setCellFactory((Callback)new RightCell.Factory());
        this.fxrootCheckBox.setSelected(this.isFxRoot());
        this.fxrootCheckBox.selectedProperty().addListener(this.checkBoxListener);
        this.controllerDidLoadFxmlOver = true;
        this.requestEntriesUpdate();
        this.updateAsPerRootNodeStatus();
        this.updateControllerAndControllerClassEditor();
    }

    private synchronized void updateControllerAndControllerClassEditor() {
        this.updateControllerAndControllerClassEditor(IGNORED);
    }

    private synchronized void updateControllerAndControllerClassEditor(String className) {
        FXOMObject root;
        if (this.getEditorController().getFxomDocument() != null && (root = this.getEditorController().getFxomDocument().getFxomRoot()) != null) {
            String zeClassName = this.computeProperClassName(className, root);
            ModifyFxControllerJob job = new ModifyFxControllerJob(root, zeClassName, this.getEditorController());
            if (job.isExecutable()) {
                this.getEditorController().getJobManager().push(job);
            }
            this.updateControllerClassEditor(zeClassName);
        }
    }

    private void updateControllerClassEditor() {
        this.updateControllerClassEditor(IGNORED);
    }

    private void updateControllerClassEditor(String className) {
        FXOMObject root;
        if (this.getEditorController().getFxomDocument() != null && (root = this.getEditorController().getFxomDocument().getFxomRoot()) != null) {
            String zeClassName = this.computeProperClassName(className, root);
            if (this.controllerClassEditor != null) {
                this.controllerClassEditor.setUpdateFromModel(true);
                this.controllerClassEditor.setValue(zeClassName);
                this.controllerClassEditor.setUpdateFromModel(false);
            }
        }
    }

    private String computeProperClassName(String className, FXOMObject root) {
        String res = className;
        if (className != null && className.equals(IGNORED)) {
            res = root.getFxController();
        }
        if (className != null && className.isEmpty()) {
            res = null;
        }
        return res;
    }

    private void requestEntriesUpdate() {
        this.updateEntriesNow();
    }

    private void updateEntriesNow() {
        if (this.leftTableColumn != null) {
            ObservableList newEntries = FXCollections.observableArrayList();
            FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
            if (fxomDocument != null) {
                switch (this.entryType) {
                    case FX_ID: {
                        Map<String, FXOMObject> fxIds = fxomDocument.collectFxIds();
                        for (Map.Entry<String, FXOMObject> e : fxIds.entrySet()) {
                            String fxId = e.getKey();
                            FXOMObject fxomObject = e.getValue();
                            newEntries.add(new IndexEntry(fxId, this.entryType, fxomObject));
                        }
                        break;
                    }
                    case HANDLER: {
                        break;
                    }
                    case RESOURCE_KEY: {
                        break;
                    }
                    case STYLECLASS: {
                        break;
                    }
                }
            }
            TableView tableView = this.leftTableColumn.getTableView();
            this.stopListeningToTableViewSelection();
            tableView.getItems().clear();
            tableView.getItems().addAll((Collection)newEntries);
            this.startListeningToTableViewSelection();
            int count = newEntries.size();
            this.bottomLabel.setText((String)(switch (count) {
                case 0 -> "";
                case 1 -> "1 " + I18N.getString("info.label.item");
                default -> count + " " + I18N.getString("info.label.items");
            }));
            this.editorSelectionDidChange();
        }
    }

    private void startListeningToTableViewSelection() {
        assert (this.leftTableColumn != null);
        TableView tableView = this.leftTableColumn.getTableView();
        tableView.getSelectionModel().getSelectedItems().addListener(this.tableViewSelectionListener);
    }

    private void stopListeningToTableViewSelection() {
        assert (this.leftTableColumn != null);
        TableView tableView = this.leftTableColumn.getTableView();
        tableView.getSelectionModel().getSelectedItems().removeListener(this.tableViewSelectionListener);
    }

    private void tableSelectionDidChange() {
        TableView tableView = this.leftTableColumn.getTableView();
        ObservableList selectedItems = tableView.getSelectionModel().getSelectedItems();
        HashSet<FXOMObject> selectedFxomObjects = new HashSet<FXOMObject>();
        for (IndexEntry i : selectedItems) {
            selectedFxomObjects.add(i.getFxomObject());
        }
        this.stopListeningToEditorSelection();
        this.getEditorController().getSelection().select(selectedFxomObjects);
        this.startListeningToEditorSelection();
    }

    private Set<IndexEntry> searchIndexEntries(Set<FXOMObject> fxomObjects) {
        assert (fxomObjects != null);
        TableView tableView = this.leftTableColumn.getTableView();
        HashSet<IndexEntry> result = new HashSet<IndexEntry>();
        for (IndexEntry e : tableView.getItems()) {
            if (!fxomObjects.contains(e.getFxomObject())) continue;
            result.add(e);
        }
        return result;
    }

    private List<String> getSuggestedControllerClasses(URL location) {
        Glossary glossary = this.getEditorController().getGlossary();
        if (location == null && this.getEditorController().getFxomDocument() != null) {
            location = this.getEditorController().getFxomDocument().getLocation();
        }
        return glossary.queryControllerClasses(location);
    }

    private void updateAsPerRootNodeStatus() {
        if (this.controllerDidLoadFxmlOver && this.getEditorController().getFxomDocument() != null) {
            if (this.getEditorController().getFxomDocument().getFxomRoot() == null) {
                this.fxrootCheckBox.setDisable(true);
                this.controllerClassEditor.setDisable(true);
                this.controllerClassEditor.setUpdateFromModel(true);
                this.controllerClassEditor.setValue(null);
                this.controllerClassEditor.setUpdateFromModel(false);
            } else {
                this.fxrootCheckBox.setDisable(false);
                String topClassName = this.getEditorController().getFxomDocument().getGlue().getRootElement().getTagName();
                this.fxrootCheckBox.setTooltip(new Tooltip(I18N.getString("info.tooltip.controller", topClassName)));
                this.controllerClassEditor.setDisable(false);
            }
        }
    }

    private void toggleFxRoot() {
        ToggleFxRootJob job;
        FXOMObject root;
        if (this.getEditorController().getFxomDocument() != null && (root = this.getEditorController().getFxomDocument().getFxomRoot()) instanceof FXOMInstance && (job = new ToggleFxRootJob(this.getEditorController())).isExecutable()) {
            this.stopListeningToJobManagerRevision();
            this.getEditorController().getJobManager().push(job);
            this.startListeningToJobManagerRevision();
        }
    }

    private boolean isFxRoot() {
        FXOMObject root;
        if (this.getEditorController().getFxomDocument() != null && (root = this.getEditorController().getFxomDocument().getFxomRoot()) instanceof FXOMInstance) {
            return ((FXOMInstance)root).isFxRoot();
        }
        return false;
    }

    private void resetSuggestedControllerClasses(URL location) {
        if (this.controllerClassEditor != null) {
            Platform.runLater(() -> {
                this.controllerClassEditor.setUpdateFromModel(true);
                this.controllerClassEditor.reset(this.getSuggestedControllerClasses(location));
                this.controllerClassEditor.setUpdateFromModel(false);
            });
        }
    }
}

