/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.DoubleField;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.IntegerField;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.PropertyEditor;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public abstract class AutoSuggestEditor
extends PropertyEditor {
    @FXML
    public ListView<String> suggestedLv;
    @FXML
    public TextField textField;
    @FXML
    public DoubleField doubleField;
    @FXML
    public IntegerField integerField;
    @FXML
    public MenuButton menuButton;
    private Parent root;
    private TextField entryField;
    private List<String> suggestedList;
    private boolean suggest = true;
    private Type type = Type.ALPHA;
    private boolean showMenuButton = true;

    public AutoSuggestEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, List<String> suggestedList) {
        super(propMeta, selectedClasses);
        this.preInit(suggestedList);
    }

    public AutoSuggestEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, List<String> suggestedList, Type type) {
        super(propMeta, selectedClasses);
        this.type = type;
        this.preInit(suggestedList);
    }

    public AutoSuggestEditor(String name, String defaultValue, List<String> suggestedList) {
        this(name, defaultValue, suggestedList, Type.ALPHA, true);
    }

    public AutoSuggestEditor(String name, String defaultValue, List<String> suggestedList, Type type) {
        this(name, defaultValue, suggestedList, type, true);
    }

    public AutoSuggestEditor(String name, String defaultValue, List<String> suggestedList, boolean showMenuButton) {
        this(name, defaultValue, suggestedList, Type.ALPHA, showMenuButton);
    }

    public AutoSuggestEditor(String name, String defaultValue, List<String> suggestedList, Type type, boolean showMenuButton) {
        super(name, defaultValue);
        this.type = type;
        this.showMenuButton = showMenuButton;
        this.preInit(suggestedList);
    }

    private void preInit(List<String> suggestedList) {
        this.setSuggestedList(suggestedList);
        if (this.type == Type.ALPHA) {
            this.root = EditorUtils.loadFxml("StringAutoSuggestEditor.fxml", (Object)this);
            assert (this.textField != null);
            this.textField.setOnMousePressed(event -> this.textField.selectAll());
            this.textField.focusedProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    this.textField.selectAll();
                }
            });
            this.entryField = this.textField;
        } else if (this.type == Type.DOUBLE) {
            this.root = EditorUtils.loadFxml("DoubleAutoSuggestEditor.fxml", (Object)this);
            this.entryField = this.doubleField;
        } else {
            assert (this.type == Type.INTEGER);
            this.root = EditorUtils.loadFxml("IntegerAutoSuggestEditor.fxml", (Object)this);
            this.entryField = this.integerField;
        }
        HBox.setHgrow((Node)this.root, (Priority)Priority.ALWAYS);
        this.initialize();
    }

    private void initialize() {
        this.entryField.focusedProperty().addListener((ov, prevVal, newVal) -> {
            if (newVal.booleanValue()) {
                this.suggest = true;
                this.handleSuggestedPopup();
            } else {
                this.hidePopup();
            }
        });
        this.updateMenuButtonIfNeeded();
    }

    @Override
    public Node getValueEditor() {
        return super.handleGenericModes((Node)this.root);
    }

    @Override
    public Object getValue() {
        String value = this.entryField.getText();
        if (value == null) {
            return null;
        }
        return EditorUtils.getPlainString(value);
    }

    @Override
    public void setValue(Object value) {
        this.setValueGeneric(value);
        if (this.isSetValueDone()) {
            return;
        }
        if (value == null) {
            this.entryField.setText(null);
        } else {
            assert (value instanceof String);
            this.entryField.setText((String)value);
        }
    }

    @Override
    protected void valueIsIndeterminate() {
        AutoSuggestEditor.handleIndeterminate((Node)this.entryField);
    }

    @Override
    public void requestFocus() {
        EditorUtils.doNextFrame(() -> this.entryField.requestFocus());
    }

    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, List<String> suggestedList) {
        super.reset(propMeta, selectedClasses);
        this.resetSuggestedList(suggestedList);
    }

    public void reset(String name, String defaultValue, List<String> suggestedList) {
        super.reset(name, defaultValue);
        this.resetSuggestedList(suggestedList);
    }

    protected void resetSuggestedList(List<String> suggestedList) {
        this.setSuggestedList(suggestedList);
        this.updateMenuButtonIfNeeded();
        this.entryField.setPromptText(null);
    }

    protected List<String> getSuggestedList() {
        return this.suggestedList;
    }

    private void setSuggestedList(List<String> suggestedList) {
        Collections.sort(suggestedList);
        this.suggestedList = suggestedList;
    }

    protected Parent getRoot() {
        return this.root;
    }

    public TextField getTextField() {
        return this.entryField;
    }

    @FXML
    protected void suggestedLvKeyPressed(KeyEvent event) {
        if (event.getCode() == KeyCode.ENTER) {
            this.useSuggested();
        }
        if (event.getCode() == KeyCode.ESCAPE) {
            this.hidePopup();
            this.suggest = false;
        }
    }

    @FXML
    protected void suggestedLvMousePressed(MouseEvent event) {
        this.useSuggested();
    }

    @FXML
    protected void textFieldKeyReleased(KeyEvent event) {
        if (event.getCode() == KeyCode.ENTER || event.getCode() == KeyCode.UP || event.getCode() == KeyCode.ESCAPE) {
            return;
        }
        if (event.getCode() == KeyCode.DOWN) {
            this.suggest = true;
            this.suggestedLv.requestFocus();
        }
        this.handleSuggestedPopup();
    }

    @FXML
    protected void textFieldMouseClicked(MouseEvent event) {
    }

    private void initConstants() {
        if (this.type == Type.DOUBLE) {
            assert (this.entryField instanceof DoubleField);
            ((DoubleField)this.entryField).setConstants(this.suggestedList);
        } else if (this.type == Type.INTEGER) {
            assert (this.entryField instanceof IntegerField);
            ((IntegerField)this.entryField).setConstants(this.suggestedList);
        }
        this.addConstantsInMenuButton();
    }

    private void handleSuggestedPopup() {
        List<String> suggestedItems;
        String value = this.entryField.getText();
        if (!this.suggest) {
            if (value == null || value.isEmpty()) {
                this.suggest = true;
            } else {
                return;
            }
        }
        if ((suggestedItems = this.getSuggestedItems(value, value)).isEmpty() || suggestedItems.size() == 1 && suggestedItems.get(0).equals(value)) {
            this.hidePopup();
        } else {
            this.showPopup(suggestedItems);
        }
    }

    private List<String> getSuggestedItems(String filter, String currentValue) {
        ArrayList<String> suggestedItems = new ArrayList<String>();
        if (filter == null || currentValue == null) {
            return this.suggestedList;
        }
        filter = filter.toLowerCase(Locale.ROOT);
        currentValue = currentValue.toLowerCase(Locale.ROOT);
        for (String suggestItem : this.suggestedList) {
            String suggestItemLower = suggestItem.toLowerCase(Locale.ROOT);
            if (!suggestItemLower.contains(filter) || suggestItemLower.equals(currentValue)) continue;
            suggestedItems.add(suggestItem);
        }
        return suggestedItems;
    }

    private void showPopup(List<String> suggestedItems) {
        if (!this.suggestedLv.getItems().equals(suggestedItems)) {
            this.suggestedLv.setItems(FXCollections.observableArrayList(suggestedItems));
        }
        if (!this.entryField.getContextMenu().isShowing()) {
            this.suggestedLv.getSelectionModel().clearSelection();
            this.entryField.getContextMenu().show((Node)this.entryField, Side.BOTTOM, 0.0, 0.0);
        }
    }

    private void hidePopup() {
        if (this.entryField.getContextMenu().isShowing()) {
            this.entryField.getContextMenu().hide();
        }
    }

    private void useSuggested() {
        if (!this.suggestedLv.getSelectionModel().isEmpty()) {
            String selected = (String)this.suggestedLv.getSelectionModel().getSelectedItem();
            this.entryField.setText(selected);
            this.entryField.requestFocus();
            this.entryField.selectAll();
            if (this.getCommitListener() != null) {
                this.getCommitListener().handle(null);
            }
        }
        this.hidePopup();
    }

    private void updateMenuButtonIfNeeded() {
        assert (this.menuButton != null);
        if (!this.showMenuButton || this.suggestedList.isEmpty()) {
            this.menuButton.setVisible(false);
            this.menuButton.setManaged(false);
        } else {
            this.menuButton.setVisible(true);
            this.menuButton.setManaged(true);
            this.initConstants();
        }
    }

    private void addConstantsInMenuButton() {
        assert (this.menuButton != null);
        this.menuButton.getItems().clear();
        for (String suggestItem : this.suggestedList) {
            MenuItem menuItem = new MenuItem(suggestItem);
            menuItem.setMnemonicParsing(false);
            menuItem.setOnAction(t -> {
                this.entryField.setText(suggestItem);
                if (this.getCommitListener() != null) {
                    this.getCommitListener().handle(null);
                }
            });
            this.menuButton.getItems().add((Object)menuItem);
        }
    }

    public static enum Type {
        ALPHA,
        DOUBLE,
        INTEGER;

    }
}

