/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.AutoSuggestEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Control;

public class CharsetEditor
extends AutoSuggestEditor {
    private final Map<String, Charset> availableCharsets;

    public CharsetEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, Map<String, Charset> availableCharsets) {
        super(propMeta, selectedClasses, new ArrayList<String>(availableCharsets.keySet()), AutoSuggestEditor.Type.ALPHA);
        this.availableCharsets = availableCharsets;
        this.initialize();
    }

    private void initialize() {
        EventHandler onActionListener = event -> {
            if (this.isHandlingError()) {
                return;
            }
            Object value = this.getValue();
            if (value != null && this.isValidValue((String)value)) {
                this.userUpdateValueProperty(value);
                this.getTextField().selectAll();
            } else {
                this.handleInvalidValue(this.getTextField().getText());
            }
        };
        this.setTextEditorBehavior(this, (Control)this.textField, (EventHandler<ActionEvent>)onActionListener);
    }

    @Override
    public Object getValue() {
        String val = this.getTextField().getText();
        if (val.isEmpty()) {
            val = "";
            this.getTextField().setText(val);
            return String.valueOf(val);
        }
        Charset constantValue = this.availableCharsets.get(val.toUpperCase(Locale.ROOT));
        if (constantValue != null) {
            val = EditorUtils.valAsStr(constantValue);
        }
        return String.valueOf(val);
    }

    @Override
    public void setValue(Object value) {
        Object changedValue = value;
        this.setValueGeneric(changedValue);
        if (this.isSetValueDone()) {
            return;
        }
        for (Map.Entry<String, Charset> entry : this.availableCharsets.entrySet()) {
            if (!changedValue.equals(entry.getValue())) continue;
            changedValue = entry.getKey();
        }
        this.getTextField().setText(EditorUtils.valAsStr(changedValue));
    }

    @Override
    public void requestFocus() {
        EditorUtils.doNextFrame(() -> this.getTextField().requestFocus());
    }

    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, Map<String, Charset> constants) {
        super.reset(propMeta, selectedClasses, new ArrayList<String>(constants.keySet()));
    }

    public static Map<String, Charset> getStandardCharsets() {
        HashMap<String, Charset> charsets = new HashMap<String, Charset>();
        charsets.put("UTF-8", StandardCharsets.UTF_8);
        charsets.put("UTF-16", StandardCharsets.UTF_16);
        charsets.put("UTF-16BE", StandardCharsets.UTF_16BE);
        charsets.put("UTF-16LE", StandardCharsets.UTF_16LE);
        charsets.put("US-ASCII", StandardCharsets.US_ASCII);
        charsets.put("ISO-8859-1", StandardCharsets.ISO_8859_1);
        return charsets;
    }

    private boolean isValidValue(String value) {
        boolean valid = false;
        if (this.availableCharsets.containsKey(value)) {
            valid = true;
        }
        return valid;
    }
}

