/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.AutoSuggestEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.util.SBDuration;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

public class DurationEditor
extends AutoSuggestEditor {
    private static final Map<String, SBDuration> constants = new HashMap<String, SBDuration>();
    private static final String MILLISECONDS = I18N.getString("inspector.duration.milliseconds");
    private static final String SECONDS = I18N.getString("inspector.duration.seconds");
    private static final String MINUTES = I18N.getString("inspector.duration.minutes");
    private static final String HOURS = I18N.getString("inspector.duration.hours");
    @FXML
    private StackPane textfieldStackPane;
    @FXML
    private ComboBox unitsComboBox;
    private Parent root;

    public DurationEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super(propMeta, selectedClasses, new ArrayList<String>(constants.keySet()), AutoSuggestEditor.Type.DOUBLE);
        this.initialize();
    }

    private void initialize() {
        this.root = EditorUtils.loadFxml("DurationEditor.fxml", (Object)this);
        EventHandler onActionListener = event -> {
            if (this.isHandlingError()) {
                return;
            }
            if (this.isUpdateFromModel()) {
                return;
            }
            Object value = this.getValue();
            assert (value instanceof SBDuration);
            SBDuration valDuration = (SBDuration)((Object)((Object)value));
            boolean isConstant = constants.get(this.getTextField().getText().toUpperCase(Locale.ROOT)) != null;
            for (Map.Entry<String, SBDuration> entry : constants.entrySet()) {
                if (!value.equals((Object)entry.getValue())) continue;
                isConstant = true;
                break;
            }
            this.getTextField().selectAll();
            this.userUpdateValueProperty((Object)valDuration);
        };
        this.setNumericEditorBehavior(this, (Control)this.getTextField(), (EventHandler<ActionEvent>)onActionListener, false);
        this.localizeComboBox();
        this.unitsComboBox.getSelectionModel().select((Object)MILLISECONDS);
        this.unitsComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            SBDuration value = this.getValue(this.getTextField().getText(), (String)oldValue);
            this.getTextField().setText(this.getNumericValue(value, (String)newValue).toString());
        });
        this.textfieldStackPane.getChildren().add((Object)super.getRoot());
    }

    private void localizeComboBox() {
        ArrayList<String> localizedStrings = new ArrayList<String>();
        for (Object item : this.unitsComboBox.getItems()) {
            String itemString = (String)item;
            if (itemString.charAt(0) == '%') {
                localizedStrings.add(I18N.getString(itemString.substring(1)));
                continue;
            }
            localizedStrings.add(itemString);
        }
        this.unitsComboBox.getItems().clear();
        this.unitsComboBox.getItems().addAll(localizedStrings);
    }

    @Override
    public Node getValueEditor() {
        return super.handleGenericModes((Node)this.root);
    }

    @Override
    public Object getValue() {
        return this.getValue(this.getTextField().getText(), (String)this.unitsComboBox.getSelectionModel().getSelectedItem());
    }

    private SBDuration getValue(String valueString, String units) {
        if (((String)valueString).isEmpty()) {
            valueString = "0";
            this.getTextField().setText((String)valueString);
            return new SBDuration(Duration.ZERO);
        }
        SBDuration constantValue = constants.get(((String)valueString).toUpperCase(Locale.ROOT));
        if (constantValue != null) {
            return constantValue;
        }
        try {
            if (units.equals(MILLISECONDS)) {
                valueString = (String)valueString + "ms";
            } else if (units.equals(SECONDS)) {
                valueString = (String)valueString + "s";
            } else if (units.equals(MINUTES)) {
                valueString = (String)valueString + "m";
            } else if (units.equals(HOURS)) {
                valueString = (String)valueString + "h";
            }
            return SBDuration.valueOf((String)valueString);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public void setValue(Object value) {
        this.setValueGeneric(value);
        if (this.isSetValueDone()) {
            return;
        }
        if (value == null) {
            this.getTextField().setText("");
            return;
        }
        assert (value instanceof SBDuration);
        SBDuration durationValue = (SBDuration)((Object)value);
        for (Map.Entry<String, SBDuration> entry : constants.entrySet()) {
            if (!value.equals((Object)entry.getValue())) continue;
            this.getTextField().setText(entry.getKey());
            return;
        }
        String units = (String)this.unitsComboBox.getSelectionModel().getSelectedItem();
        this.getTextField().setText(this.getNumericValue(durationValue, units).toString());
    }

    private Double getNumericValue(SBDuration durationValue, String units) {
        Double convertedValue = null;
        if (units.equals(MILLISECONDS)) {
            convertedValue = durationValue.toMillis();
        } else if (units.equals(SECONDS)) {
            convertedValue = durationValue.toSeconds();
        } else if (units.equals(MINUTES)) {
            convertedValue = durationValue.toMinutes();
        } else if (units.equals(HOURS)) {
            convertedValue = durationValue.toHours();
        }
        return convertedValue;
    }

    @Override
    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super.reset(propMeta, selectedClasses, new ArrayList<String>(constants.keySet()));
    }

    @Override
    protected void valueIsIndeterminate() {
        DurationEditor.handleIndeterminate((Node)this.getTextField());
    }

    @Override
    public void requestFocus() {
        EditorUtils.doNextFrame(() -> this.getTextField().requestFocus());
    }
}

