/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.DocumentationUrls;
import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.PropertyEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.popupeditors.PopupEditor;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.klass.ComponentClassMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.PropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.animation.AnimationTimer;
import javafx.animation.FadeTransition;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Bounds;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.scene.control.MenuButton;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;

public class EditorUtils {
    static final String[] FXML_RESERVED_KEYWORDS = new String[]{"null"};
    private static final String FXINCLUDE_JAVADOC_URL = "https://openjfx.io/javadoc/11/javafx.fxml/javafx/fxml/doc-files/introduction_to_fxml.html#include_elements";

    EditorUtils() {
    }

    public static void makeWidthStretchable(final Node node) {
        Parent p = node.getParent();
        if (p == null) {
            node.parentProperty().addListener(new InvalidationListener(){

                public void invalidated(Observable valueModel) {
                    if (node.getParent() != null) {
                        EditorUtils.makeWidthStretchable(node, node.getParent());
                        node.parentProperty().removeListener((InvalidationListener)this);
                    }
                }
            });
        } else {
            EditorUtils.makeWidthStretchable(node, p);
        }
    }

    private static void makeWidthStretchable(Node node, Parent p) {
        if (p != null) {
            if (p instanceof HBox) {
                HBox.setHgrow((Node)node, (Priority)Priority.ALWAYS);
            } else if (p instanceof GridPane) {
                GridPane.setHgrow((Node)node, (Priority)Priority.ALWAYS);
            }
        }
        if (node instanceof Region) {
            ((Region)node).setMinWidth(0.0);
            ((Region)node).setMaxWidth(Double.MAX_VALUE);
        }
    }

    public static void makeUnstretchable(Control node, double width, double height) {
        node.setPrefWidth(width);
        node.setMinWidth(width);
        node.setMaxWidth(width);
        node.setPrefHeight(height);
        node.setMinHeight(height);
        node.setMaxHeight(height);
    }

    public static void replaceNode(Node node, Node newNode, PropertyEditor.LayoutFormat layoutFormat) {
        Parent parent = node.getParent();
        boolean hasGridPaneParent = parent instanceof GridPane;
        if (parent instanceof Pane) {
            ObservableList children = ((Pane)parent).getChildren();
            int childIndex = children.indexOf((Object)node);
            int columnIndex = -1;
            int rowIndex = -1;
            if (hasGridPaneParent) {
                columnIndex = GridPane.getColumnIndex((Node)node);
                rowIndex = GridPane.getRowIndex((Node)node);
            }
            children.remove(childIndex);
            if (hasGridPaneParent && layoutFormat != null) {
                ((GridPane)parent).getRowConstraints().remove(rowIndex);
            }
            GridPane.setRowIndex((Node)newNode, (Integer)rowIndex);
            GridPane.setColumnIndex((Node)newNode, (Integer)columnIndex);
            children.add(childIndex, (Object)newNode);
            if (hasGridPaneParent && layoutFormat != null) {
                RowConstraints rowConstraints = new RowConstraints();
                if (layoutFormat == PropertyEditor.LayoutFormat.SIMPLE_LINE_CENTERED) {
                    rowConstraints.setValignment(VPos.CENTER);
                } else if (layoutFormat == PropertyEditor.LayoutFormat.SIMPLE_LINE_TOP) {
                    rowConstraints.setValignment(VPos.TOP);
                } else {
                    throw new UnsupportedOperationException("replaceNode() - GridPane: layout change in double line not supported yet!");
                }
                ((GridPane)parent).getRowConstraints().add(rowIndex, (Object)rowConstraints);
            }
        }
    }

    public static String valAsStr(Object val) {
        if (val == null) {
            return null;
        }
        String str = val.toString();
        if (val instanceof Double && str.endsWith(".0")) {
            str = str.substring(0, str.length() - 2);
        }
        return str;
    }

    public static String toDisplayName(String name) {
        if (name == null) {
            return name;
        }
        name = ((String)name).replace("_", " ");
        if (((String)(name = ((String)name).trim())).length() == 0) {
            return name;
        }
        name = Character.toUpperCase(((String)name).charAt(0)) + ((String)name).substring(1);
        StringBuilder builder = new StringBuilder();
        char ch = ((String)name).charAt(0);
        builder.append(ch);
        boolean previousWasDigit = Character.isDigit(ch);
        boolean previousWasCapital = !previousWasDigit;
        for (int i = 1; i < ((String)name).length(); ++i) {
            ch = ((String)name).charAt(i);
            if (Character.isUpperCase(ch) && !previousWasCapital || Character.isUpperCase(ch) && previousWasDigit) {
                builder.append(" ");
                builder.append(ch);
                previousWasCapital = true;
                previousWasDigit = false;
                continue;
            }
            if (Character.isDigit(ch) && !previousWasDigit || Character.isDigit(ch) && previousWasCapital) {
                builder.append(" ");
                builder.append(ch);
                previousWasCapital = false;
                previousWasDigit = true;
                continue;
            }
            if (Character.isUpperCase(ch) || Character.isDigit(ch)) {
                builder.append(ch);
                continue;
            }
            if (Character.isWhitespace(ch)) {
                builder.append(" ");
                ch = ((String)name).charAt(++i);
                while (Character.isWhitespace(ch)) {
                    ch = ((String)name).charAt(++i);
                }
                builder.append(Character.toUpperCase(ch));
                previousWasDigit = Character.isDigit(ch);
                previousWasCapital = !previousWasDigit;
                continue;
            }
            previousWasCapital = false;
            previousWasDigit = false;
            builder.append(ch);
        }
        return builder.toString();
    }

    private static ComponentClassMetadata getDefiningClass(Class<?> clazz, PropertyName propName) {
        Metadata metadata = Metadata.getMetadata();
        ComponentClassMetadata classMeta = metadata.queryComponentMetadata(clazz);
        while (clazz != null) {
            for (PropertyMetadata propMeta : classMeta.getProperties()) {
                if (propMeta.getName().compareTo(propName) != 0) continue;
                return classMeta;
            }
            classMeta = classMeta.getParentMetadata();
        }
        return null;
    }

    public static AnimationTimer doEndOfFrame(Runnable callback) {
        NextFrameTimer timer = new NextFrameTimer(callback, 0);
        timer.start();
        return timer;
    }

    public static AnimationTimer doNextFrame(Runnable callback) {
        NextFrameTimer timer = new NextFrameTimer(callback);
        timer.start();
        return timer;
    }

    public static double round(double value, int roundingFactor) {
        double doubleRounded = Math.round(value * (double)roundingFactor);
        return doubleRounded / (double)roundingFactor;
    }

    public static double computeLeftAnchor(FXOMObject selectedInstance) {
        Node node = EditorUtils.getFxNode(selectedInstance);
        return EditorUtils.computeLeftAnchor(node, node.getLayoutBounds());
    }

    public static double computeRightAnchor(FXOMObject selectedInstance) {
        Node node = EditorUtils.getFxNode(selectedInstance);
        return EditorUtils.computeRightAnchor(node, node.getLayoutBounds());
    }

    public static double computeTopAnchor(FXOMObject selectedInstance) {
        Node node = EditorUtils.getFxNode(selectedInstance);
        return EditorUtils.computeTopAnchor(node, node.getLayoutBounds());
    }

    public static double computeBottomAnchor(FXOMObject selectedInstance) {
        Node node = EditorUtils.getFxNode(selectedInstance);
        return EditorUtils.computeBottomAnchor(node, node.getLayoutBounds());
    }

    private static double computeLeftAnchor(Node node, Bounds futureLayoutBounds) {
        return node.getLayoutX() + futureLayoutBounds.getMinX() - node.getParent().getLayoutBounds().getMinX();
    }

    private static double computeRightAnchor(Node node, Bounds futureLayoutBounds) {
        return node.getParent().getLayoutBounds().getMaxX() - node.getLayoutX() - futureLayoutBounds.getMaxX();
    }

    private static double computeTopAnchor(Node node, Bounds futureLayoutBounds) {
        return node.getLayoutY() + futureLayoutBounds.getMinY() - node.getParent().getLayoutBounds().getMinY();
    }

    private static double computeBottomAnchor(Node node, Bounds futureLayoutBounds) {
        return node.getParent().getLayoutBounds().getMaxY() - node.getLayoutY() - futureLayoutBounds.getMaxY();
    }

    private static Node getFxNode(FXOMObject selectedInstance) {
        Object selectedObj = selectedInstance.getSceneGraphObject();
        assert (selectedObj instanceof Node);
        return (Node)selectedObj;
    }

    public static void handleFading(FadeTransition fadeTransition, Node fadingSource) {
        EditorUtils.handleFading(fadeTransition, fadingSource, null);
    }

    public static void handleFading(FadeTransition fadeTransition, Node fadingSource, BooleanProperty disableProperty) {
        fadingSource.setOnMouseEntered(arg0 -> {
            Node targetNode = fadeTransition.getNode();
            if (targetNode instanceof MenuButton && ((MenuButton)targetNode).isShowing()) {
                return;
            }
            if (disableProperty != null && disableProperty.getValue().booleanValue()) {
                return;
            }
            EditorUtils.fadeTo(fadeTransition, 1.0);
        });
        fadingSource.setOnMouseExited(arg0 -> {
            Node targetNode = fadeTransition.getNode();
            if (targetNode instanceof MenuButton && ((MenuButton)targetNode).isShowing()) {
                return;
            }
            if (disableProperty != null && disableProperty.getValue().booleanValue()) {
                return;
            }
            EditorUtils.fadeTo(fadeTransition, 0.0);
        });
    }

    public static void fadeTo(FadeTransition fadeTransition, double toValue) {
        fadeTransition.stop();
        fadeTransition.setFromValue(fadeTransition.getNode().getOpacity());
        fadeTransition.setToValue(toValue);
        fadeTransition.play();
    }

    protected static void openUrl(Set<Class<?>> selectedClasses, ValuePropertyMetadata propMeta) throws IOException {
        Class<?> clazz = null;
        if (selectedClasses != null) {
            for (Class<?> cl : selectedClasses) {
                clazz = cl;
            }
        }
        PropertyName propertyName = propMeta.getName();
        clazz = propMeta.isStaticProperty() ? propertyName.getResidenceClass() : EditorUtils.getDefiningClass(clazz, propertyName).getKlass();
        Object propNameStr = propertyName.getName();
        propNameStr = ((String)propNameStr).substring(0, 1).toUpperCase(Locale.ENGLISH) + ((String)propNameStr).substring(1);
        String posfix = EditorPlatform.hasClassFromExternalPlugin(clazz.getName()) ? "--" : "()";
        String methodName = propMeta.getValueClass() == Boolean.class ? "is" + (String)propNameStr + posfix : (propMeta.isStaticProperty() ? "get" + (String)propNameStr + "(" + Node.class.getName() + ")" : "get" + (String)propNameStr + posfix);
        Object url = EditorPlatform.getExternalJavadocURL(clazz.getName()).orElse(String.valueOf((Object)DocumentationUrls.JAVADOC_HOME) + clazz.getModule().getName() + "/");
        url = (String)url + clazz.getName().replaceAll("\\.", "/") + ".html";
        url = (String)url + "#" + methodName;
        EditorPlatform.open((String)url);
    }

    public static void swap(ObservableList<Node> list, int i, int j) {
        ArrayList<Node> children = new ArrayList<Node>((Collection<Node>)list);
        Collections.swap(children, i, j);
        list.clear();
        list.addAll(children);
    }

    public static Parent loadFxml(String fxmlFileName, Object controller) {
        URL fxmlURL = EditorUtils.class.getResource(fxmlFileName);
        return EditorUtils.loadFxml(fxmlURL, controller);
    }

    public static Parent loadPopupFxml(String fxmlFileName, Object controller) {
        URL fxmlURL = PopupEditor.class.getResource(fxmlFileName);
        return EditorUtils.loadFxml(fxmlURL, controller);
    }

    public static Parent loadFxml(URL fxmlURL, Object controller) {
        Parent root;
        FXMLLoader loader = new FXMLLoader();
        loader.setController(controller);
        loader.setLocation(fxmlURL);
        loader.setResources(I18N.getBundle());
        loader.setClassLoader(controller.getClass().getClassLoader());
        try {
            root = (Parent)loader.load();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to load " + fxmlURL.getFile(), ex);
        }
        return root;
    }

    public static String getFileName(String urlStr) {
        URL url;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException ex) {
            System.err.println("Invalid URL: " + urlStr);
            assert (false);
            return null;
        }
        String[] urlParts = url.getPath().split("\\/");
        return urlParts[urlParts.length - 1];
    }

    public static boolean areEqual(Object obj1, Object obj2) {
        return !(obj1 == null || obj2 == null ? obj1 != obj2 : !obj1.equals(obj2));
    }

    public static URL getUrl(String suffix, PrefixedValue.Type type, URL fxmlFileLocation) {
        String prefixedString = suffix.isEmpty() ? "" : new PrefixedValue(type, suffix).toString();
        return EditorUtils.getUrl(prefixedString, fxmlFileLocation);
    }

    public static URL getUrl(String prefixedString, URL fxmlFileLocation) {
        PrefixedValue prefixedValue = new PrefixedValue(prefixedString);
        URL url = null;
        if (prefixedValue.getType() == PrefixedValue.Type.DOCUMENT_RELATIVE_PATH) {
            url = prefixedValue.resolveDocumentRelativePath(fxmlFileLocation);
        } else if (prefixedValue.getType() == PrefixedValue.Type.PLAIN_STRING) {
            try {
                url = new URI(prefixedValue.getSuffix()).toURL();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return url;
    }

    public static String getPlainString(String str) {
        return new PrefixedValue(PrefixedValue.Type.PLAIN_STRING, str).toString();
    }

    public static String getSimpleFileName(String url) {
        File file = new File(url);
        return file.getName();
    }

    public static String toString(Object obj) {
        assert (obj instanceof String);
        return (String)obj;
    }

    private static class NextFrameTimer
    extends AnimationTimer {
        final AtomicInteger count = new AtomicInteger(0);
        final int order;
        Runnable callback;

        public NextFrameTimer(Runnable callback) {
            this(callback, 1);
        }

        public NextFrameTimer(Runnable callback, int order) {
            assert (order >= 0);
            this.callback = callback;
            this.order = order;
        }

        public void handle(long now) {
            if (this.count.getAndIncrement() == this.order) {
                try {
                    this.callback.run();
                }
                finally {
                    this.stop();
                }
            }
        }
    }
}

