/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.PropertyEditor;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.EnumerationPropertyMetadata;
import java.util.Set;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;

public class EnumEditor
extends PropertyEditor {
    private ComboBox<String> comboBox = new ComboBox();

    public EnumEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super(propMeta, selectedClasses);
        this.comboBox.disableProperty().bind((ObservableValue)this.disableProperty());
        EditorUtils.makeWidthStretchable(this.comboBox);
        this.comboBox.getSelectionModel().selectedItemProperty().addListener(o -> {
            if (!this.isUpdateFromModel()) {
                this.userUpdateValueProperty(this.getValue());
            }
        });
        this.initialize();
    }

    private void initialize() {
        this.updateItems();
    }

    @Override
    public Object getValue() {
        return this.comboBox.getSelectionModel().getSelectedItem();
    }

    @Override
    public void setValue(Object value) {
        this.setValueGeneric(value);
        if (this.isSetValueDone()) {
            return;
        }
        if (value != null) {
            this.comboBox.getSelectionModel().select((Object)value.toString());
        } else {
            this.comboBox.getSelectionModel().clearSelection();
        }
    }

    @Override
    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super.reset(propMeta, selectedClasses);
        this.updateItems();
    }

    @Override
    public Node getValueEditor() {
        return super.handleGenericModes((Node)this.comboBox);
    }

    @Override
    protected void valueIsIndeterminate() {
        EnumEditor.handleIndeterminate(this.comboBox);
    }

    protected ComboBox<String> getComboBox() {
        return this.comboBox;
    }

    protected void updateItems() {
        this.updateItems((ObservableList<String>)this.comboBox.getItems());
    }

    protected void updateItems(ObservableList<String> itemsList) {
        assert (this.getPropertyMeta() instanceof EnumerationPropertyMetadata);
        EnumerationPropertyMetadata enumPropMeta = (EnumerationPropertyMetadata)this.getPropertyMeta();
        itemsList.clear();
        for (String val : enumPropMeta.getValidValues()) {
            itemsList.add((Object)val.toString());
        }
    }

    @Override
    public void requestFocus() {
        EditorUtils.doNextFrame(() -> this.comboBox.requestFocus());
    }
}

