/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.PropertyEditor;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignImage;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Set;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.stage.FileChooser;

public class ImageEditor
extends PropertyEditor {
    @FXML
    private Label prefixLb;
    @FXML
    private TextField imagePathTf;
    private Parent root;
    private DesignImage image = null;
    private final MenuItem documentRelativeMenuItem = new MenuItem(I18N.getString("inspector.resource.documentrelative"));
    private final MenuItem classPathRelativeMenuItem = new MenuItem(I18N.getString("inspector.resource.classpathrelative"));
    private final MenuItem absoluteMenuItem = new MenuItem(I18N.getString("inspector.resource.absolute"));
    private PrefixedValue.Type type = PrefixedValue.Type.PLAIN_STRING;
    private URL fxmlFileLocation;

    public ImageEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, URL fxmlFileLocation) {
        super(propMeta, selectedClasses);
        this.initialize(fxmlFileLocation);
    }

    private void initialize(URL fxmlFileLocation) {
        this.fxmlFileLocation = fxmlFileLocation;
        this.root = EditorUtils.loadFxml("ImageEditor.fxml", (Object)this);
        EventHandler valueListener = event -> {
            Image imageObj;
            String prefixedValue = null;
            try {
                String suffix = this.imagePathTf.getText();
                if (suffix == null || suffix.isEmpty()) {
                    this.image = null;
                    this.switchType(PrefixedValue.Type.PLAIN_STRING);
                    this.userUpdateValueProperty(this.image);
                    return;
                }
                prefixedValue = new PrefixedValue(this.type, suffix).toString();
                URL url = EditorUtils.getUrl(suffix, this.type, this.fxmlFileLocation);
                imageObj = new Image(url != null ? url.toExternalForm() : null);
            }
            catch (IllegalArgumentException | NullPointerException ex) {
                imageObj = new Image(DesignImage.getVoidImageUrl().toExternalForm());
            }
            this.image = new DesignImage(imageObj, prefixedValue);
            this.userUpdateValueProperty(this.image);
        };
        this.setTextEditorBehavior(this, (Control)this.imagePathTf, (EventHandler<ActionEvent>)valueListener);
        this.documentRelativeMenuItem.setOnAction(e -> this.switchType(PrefixedValue.Type.DOCUMENT_RELATIVE_PATH));
        this.classPathRelativeMenuItem.setOnAction(e -> this.switchType(PrefixedValue.Type.CLASSLOADER_RELATIVE_PATH));
        this.absoluteMenuItem.setOnAction(e -> this.switchType(PrefixedValue.Type.PLAIN_STRING));
        this.getMenu().getItems().addAll((Object[])new MenuItem[]{this.documentRelativeMenuItem, this.classPathRelativeMenuItem, this.absoluteMenuItem});
        this.removeLabel();
        this.updateMenuItems();
    }

    private void switchType(PrefixedValue.Type newType) {
        String suffix = this.imagePathTf.getText();
        if (suffix == null || suffix.isEmpty()) {
            this.type = newType;
            this.updateMenuItems();
            this.handlePrefix();
            return;
        }
        URL url = EditorUtils.getUrl(suffix, this.type, this.fxmlFileLocation);
        String newSuffix = null;
        if (url == null || newType == PrefixedValue.Type.CLASSLOADER_RELATIVE_PATH) {
            newSuffix = "";
        } else if (newType == PrefixedValue.Type.PLAIN_STRING) {
            newSuffix = url.toExternalForm();
        } else if (newType == PrefixedValue.Type.DOCUMENT_RELATIVE_PATH) {
            newSuffix = PrefixedValue.makePrefixedValue(url, this.fxmlFileLocation).getSuffix();
        }
        assert (newSuffix != null);
        this.imagePathTf.setText(newSuffix);
        this.type = newType;
        if (!newSuffix.isEmpty()) {
            this.getCommitListener().handle(null);
        }
        this.updateMenuItems();
        this.handlePrefix();
    }

    private void updateMenuItems() {
        this.documentRelativeMenuItem.setDisable(false);
        this.classPathRelativeMenuItem.setDisable(false);
        this.absoluteMenuItem.setDisable(false);
        if (this.fxmlFileLocation == null) {
            this.documentRelativeMenuItem.setDisable(true);
        }
        if (this.type == PrefixedValue.Type.DOCUMENT_RELATIVE_PATH) {
            this.documentRelativeMenuItem.setDisable(true);
        } else if (this.type == PrefixedValue.Type.CLASSLOADER_RELATIVE_PATH) {
            this.classPathRelativeMenuItem.setDisable(true);
        } else if (this.type == PrefixedValue.Type.PLAIN_STRING) {
            this.absoluteMenuItem.setDisable(true);
        }
    }

    protected void handlePrefix() {
        if (this.type == PrefixedValue.Type.DOCUMENT_RELATIVE_PATH) {
            this.setPrefix("@");
        } else if (this.type == PrefixedValue.Type.CLASSLOADER_RELATIVE_PATH) {
            this.setPrefix("@/");
        } else {
            this.removeLabel();
        }
    }

    private void setPrefix(String str) {
        if (!this.prefixLb.isVisible()) {
            this.prefixLb.setVisible(true);
            this.prefixLb.setManaged(true);
        }
        this.prefixLb.setText(str);
    }

    private void removeLabel() {
        this.prefixLb.setVisible(false);
        this.prefixLb.setManaged(false);
    }

    @Override
    public Node getValueEditor() {
        return super.handleGenericModes((Node)this.root);
    }

    @Override
    public Object getValue() {
        return this.image;
    }

    @Override
    public void setValue(Object value) {
        this.setValueGeneric(value);
        if (this.isSetValueDone()) {
            return;
        }
        if (value == null) {
            this.image = null;
            this.imagePathTf.setText("");
        } else {
            assert (value instanceof DesignImage);
            this.image = (DesignImage)value;
            PrefixedValue prefixedValue = new PrefixedValue(this.image.getLocation());
            this.imagePathTf.setText(prefixedValue.getSuffix());
            this.type = prefixedValue.getType();
            this.handlePrefix();
            this.updateMenuItems();
        }
    }

    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, URL fxmlFileLocation) {
        super.reset(propMeta, selectedClasses);
        this.fxmlFileLocation = fxmlFileLocation;
        this.imagePathTf.setPromptText(null);
    }

    @Override
    protected void valueIsIndeterminate() {
        ImageEditor.handleIndeterminate((Node)this.imagePathTf);
    }

    @FXML
    void chooseImage(ActionEvent event) {
        String urlStr;
        URL url;
        String[] extensions = new String[]{"*.jpg", "*.jpeg", "*.png", "*.gif"};
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(I18N.getString("inspector.select.image"));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18N.getString("inspector.select.image"), Arrays.asList(extensions)));
        fileChooser.setInitialDirectory(EditorController.getNextInitialDirectory());
        File file = fileChooser.showOpenDialog(this.imagePathTf.getScene().getWindow());
        if (file == null) {
            return;
        }
        EditorController.updateNextInitialDirectory(file);
        try {
            url = file.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("Invalid URL", ex);
        }
        if (this.fxmlFileLocation != null) {
            urlStr = PrefixedValue.makePrefixedValue(url, this.fxmlFileLocation).toString();
            this.switchType(PrefixedValue.Type.DOCUMENT_RELATIVE_PATH);
        } else {
            urlStr = url.toExternalForm();
            this.switchType(PrefixedValue.Type.PLAIN_STRING);
        }
        PrefixedValue prefixedValue = new PrefixedValue(urlStr);
        this.type = prefixedValue.getType();
        String suffix = prefixedValue.getSuffix();
        this.imagePathTf.setText(suffix);
        this.image = new DesignImage(new Image(EditorUtils.getUrl(suffix, this.type, this.fxmlFileLocation).toExternalForm()), prefixedValue.toString());
        this.userUpdateValueProperty(this.getValue());
        this.updateMenuItems();
        this.handlePrefix();
    }

    @Override
    public void requestFocus() {
        EditorUtils.doNextFrame(() -> this.imagePathTf.requestFocus());
    }
}

