/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.InlineListEditor;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;

public class IncludeFxmlEditor
extends InlineListEditor {
    private final StackPane root = new StackPane();
    private EditorController editorController;
    @FXML
    private Button includeFxmlButton;
    @FXML
    private TextField includeFxmlField;

    public IncludeFxmlEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, EditorController editorController) {
        super(propMeta, selectedClasses);
        this.editorController = editorController;
        this.initialize();
    }

    private void initialize() {
        Parent rootInitialBt = EditorUtils.loadFxml("IncludeFXMLButton.fxml", (Object)this);
        Tooltip tooltip = new Tooltip("Include FXML");
        this.includeFxmlButton.setTooltip(tooltip);
        this.root.getChildren().add((Object)rootInitialBt);
        super.disableResetValueMenuItem();
    }

    @Override
    public Node getValueEditor() {
        return super.handleGenericModes((Node)this.root);
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            for (Object obj : collection) {
                this.includeFxmlField.setText(obj.toString());
            }
        }
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public void requestFocus() {
        throw new UnsupportedOperationException();
    }

    @FXML
    public void addIncludeFile() {
        File fxmlFile = this.chooseFxml();
        if (fxmlFile != null) {
            EditorController.updateNextInitialDirectory(fxmlFile);
            this.editorController.performIncludeFxml(fxmlFile);
            this.includeFxmlField.setText(this.getRelativePath(fxmlFile));
        }
    }

    private File chooseFxml() {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter(I18N.getString("file.filter.label.fxml"), new String[]{"*.fxml"});
        fileChooser.getExtensionFilters().add((Object)filter);
        this.setInitialDirectory(fileChooser);
        return fileChooser.showOpenDialog(this.root.getScene().getWindow());
    }

    private void setInitialDirectory(FileChooser fileChooser) {
        if (this.editorController.getIncludedFile() != null) {
            File file = this.editorController.getIncludedFile();
            Path chosenFolder = file.toPath().getParent();
            fileChooser.setInitialDirectory(chosenFolder.toFile());
        } else {
            fileChooser.setInitialDirectory(EditorController.getNextInitialDirectory());
        }
    }

    private String getRelativePath(File includedFile) {
        URL url = null;
        try {
            url = includedFile.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(IncludeFxmlEditor.class.getName()).log(Level.SEVERE, "Path could not be determined.", ex);
        }
        String prefixedValue = PrefixedValue.makePrefixedValue(url, this.editorController.getFxmlLocation()).toString();
        return IncludeFxmlEditor.removeAtSign(prefixedValue);
    }

    private static String removeAtSign(String prefixedValue) {
        String prefixedValueWithNoAt = "";
        if (prefixedValue.contains("@")) {
            prefixedValueWithNoAt = prefixedValue.replace("@", "");
        }
        return prefixedValueWithNoAt;
    }
}

