/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javafx.scene.control.TextField;

public abstract class NumberField
extends TextField {
    List<String> constants = new ArrayList<String>();

    public NumberField() {
        this.setOnMousePressed(event -> this.selectAll());
        this.focusedProperty().addListener((ov, prevVal, newVal) -> {
            if (newVal.booleanValue()) {
                this.selectAll();
            }
        });
    }

    public void setConstants(List<String> constants) {
        this.constants.clear();
        this.constants.addAll(constants);
    }

    public String getNewText(int start, int end, String text) {
        String newText;
        String oldText = this.getText();
        String toReplace = oldText.substring(start, end);
        if (toReplace.isEmpty()) {
            newText = oldText + text;
        } else {
            String headerStr = oldText.substring(0, start);
            String trailerStr = "";
            if (end < oldText.length()) {
                trailerStr = oldText.substring(end, oldText.length());
            }
            newText = headerStr + text + trailerStr;
        }
        return newText;
    }

    protected boolean partOfConstants(String text) {
        text = text.toLowerCase(Locale.ROOT);
        for (String constant : this.constants) {
            if (!constant.toLowerCase(Locale.ROOT).startsWith(text)) continue;
            return true;
        }
        return false;
    }
}

