/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.Editor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.PropertyEditor;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import java.util.List;
import javafx.animation.FadeTransition;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.util.Duration;

public abstract class PropertiesEditor
extends Editor {
    private final HBox nameNode;
    private MenuButton menu;
    private final MenuItem resetvalueMenuItem = new MenuItem(I18N.getString("inspector.editors.resetvalue"));
    private FadeTransition fadeTransition = null;
    private final String name;

    public PropertiesEditor(String name) {
        this.name = name;
        this.nameNode = new HBox();
        this.nameNode.getChildren().add((Object)new Label(name));
    }

    public HBox getNameNode() {
        return this.nameNode;
    }

    public String getPropertyNameText() {
        return this.name;
    }

    public abstract List<PropertyEditor> getPropertyEditors();

    @Override
    public final MenuButton getMenu() {
        if (this.menu == null) {
            this.menu = new MenuButton();
            Region region = new Region();
            this.menu.setGraphic((Node)region);
            region.getStyleClass().add((Object)"cog-shape");
            this.menu.getStyleClass().add((Object)"cog-menubutton");
            this.menu.setOpacity(0.0);
            this.fadeTransition = new FadeTransition(Duration.millis((double)500.0), (Node)this.menu);
            EditorUtils.handleFading(this.fadeTransition, (Node)this.menu);
            EditorUtils.handleFading(this.fadeTransition, this.getValueEditor());
            this.menu.focusedProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    EditorUtils.fadeTo(this.fadeTransition, 1.0);
                } else {
                    EditorUtils.fadeTo(this.fadeTransition, 0.0);
                }
            });
            this.menu.getItems().add((Object)this.resetvalueMenuItem);
            this.resetvalueMenuItem.setOnAction(e -> {
                for (PropertyEditor propertyEditor : this.getPropertyEditors()) {
                    propertyEditor.setValue(propertyEditor.getPropertyMeta().getDefaultValueObject());
                }
            });
        }
        return this.menu;
    }

    @Override
    public void removeAllListeners() {
        for (PropertyEditor propertyEditor : this.getPropertyEditors()) {
            propertyEditor.removeAllListeners();
        }
    }

    protected void propertyChanged() {
        boolean allDefault = true;
        for (PropertyEditor propertyEditor : this.getPropertyEditors()) {
            Object value = propertyEditor.valueProperty().getValue();
            ValuePropertyMetadata propMeta = propertyEditor.getPropertyMeta();
            if (value == null) {
                if (propMeta.getDefaultValueObject() == null) continue;
                allDefault = false;
                break;
            }
            if (value.equals(propMeta.getDefaultValueObject())) continue;
            allDefault = false;
            break;
        }
        if (allDefault) {
            this.resetvalueMenuItem.setDisable(true);
        } else {
            this.resetvalueMenuItem.setDisable(false);
        }
    }
}

