/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.PropertyEditor;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.DoublePropertyMetadata;
import java.util.Set;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;

public class RotateEditor
extends PropertyEditor {
    @FXML
    private TextField rotateTf;
    @FXML
    private Button rotatorDial;
    @FXML
    private Button rotatorHandle;
    private Parent root;
    private int roundingFactor = 10;
    private boolean updateFromRotator = false;

    public RotateEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super(propMeta, selectedClasses);
        this.initialize();
    }

    private void initialize() {
        this.root = EditorUtils.loadFxml("RotateEditor.fxml", (Object)this);
        EventHandler valueListener = event -> {
            double valDouble;
            if (this.isHandlingError()) {
                return;
            }
            String valStr = this.rotateTf.getText();
            try {
                valDouble = Double.parseDouble(valStr);
            }
            catch (NumberFormatException e) {
                this.handleInvalidValue(valStr);
                return;
            }
            if (!((DoublePropertyMetadata)this.getPropertyMeta()).isValidValue(valDouble)) {
                this.handleInvalidValue(valDouble);
                return;
            }
            this.rotate(valDouble);
            this.rotateTf.selectAll();
            this.userUpdateValueProperty(valDouble);
        };
        this.setNumericEditorBehavior(this, (Control)this.rotateTf, (EventHandler<ActionEvent>)valueListener, false);
        this.rotateTf.setOnMousePressed(event -> this.rotateTf.selectAll());
        this.rotateTf.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.rotateTf.selectAll();
            }
        });
    }

    @Override
    public Node getValueEditor() {
        return super.handleGenericModes((Node)this.root);
    }

    @Override
    public Object getValue() {
        return EditorUtils.round(this.rotatorHandle.getRotate(), this.roundingFactor);
    }

    @Override
    public void setValue(Object value) {
        this.setValueGeneric(value);
        if (this.isSetValueDone()) {
            return;
        }
        assert (value instanceof Double);
        this.rotate((Double)value);
    }

    @Override
    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super.reset(propMeta, selectedClasses);
    }

    @Override
    protected void valueIsIndeterminate() {
        RotateEditor.handleIndeterminate((Node)this.rotateTf);
    }

    @FXML
    void rotatorPressed(MouseEvent e) {
        this.rotatorDragged(e);
    }

    @FXML
    void rotatorReleased(MouseEvent e) {
        this.userUpdateValueProperty(this.getValue());
    }

    @FXML
    public void rotatorDragged(MouseEvent e) {
        this.updateFromRotator = true;
        Parent p = this.rotatorDial.getParent();
        Bounds b = this.rotatorDial.getLayoutBounds();
        Double centerX = b.getMinX() + b.getWidth() / 2.0;
        Double centerY = b.getMinY() + b.getHeight() / 2.0;
        Point2D center = p.localToParent(centerX.doubleValue(), centerY.doubleValue());
        Point2D mouse = p.localToParent(e.getX(), e.getY());
        Double deltaX = mouse.getX() - center.getX();
        Double deltaY = mouse.getY() - center.getY();
        Double radians = Math.atan2(deltaY, deltaX);
        this.rotate(Math.toDegrees(radians));
        this.userUpdateTransientValueProperty(this.getValue());
        this.updateFromRotator = false;
    }

    private void rotate(Double degrees) {
        this.rotatorHandle.setRotate(degrees.doubleValue());
        if (this.updateFromRotator) {
            this.rotateTf.setText(EditorUtils.valAsStr(this.getValue()));
        } else {
            this.rotateTf.setText(EditorUtils.valAsStr(degrees));
        }
    }

    @Override
    public void requestFocus() {
        EditorUtils.doNextFrame(() -> this.rotateTf.requestFocus());
    }
}

