/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorItem;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorItemDelegate;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.InlineListEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.PropertyEditor;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Pane;

public class StringListEditor
extends InlineListEditor {
    public StringListEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super(propMeta, selectedClasses);
        this.initialize();
    }

    private void initialize() {
        this.setLayoutFormat(PropertyEditor.LayoutFormat.DOUBLE_LINE);
        this.addItem(this.getNewStringListItem());
    }

    private StringListItem getNewStringListItem() {
        return new StringListItem(this, "");
    }

    @Override
    public Object getValue() {
        ObservableList value = FXCollections.observableArrayList();
        for (EditorItem styleItem : this.getEditorItems()) {
            String itemValue = EditorUtils.toString(styleItem.getValue());
            if (itemValue.isEmpty()) continue;
            value.add(itemValue);
        }
        if (value.isEmpty()) {
            return super.getPropertyMeta().getDefaultValueObject();
        }
        return value;
    }

    @Override
    public void setValue(Object value) {
        this.setValueGeneric(value);
        if (value == null) {
            this.reset();
            return;
        }
        assert (value instanceof List);
        this.setValueGeneric(value);
        if (this.isSetValueDone()) {
            return;
        }
        Iterator<EditorItem> itemsIter = new ArrayList<EditorItem>(this.getEditorItems()).iterator();
        for (String item : (List)value) {
            EditorItem editorItem = itemsIter.hasNext() ? itemsIter.next() : this.addItem(new StringListItem(this, item));
            editorItem.setValue(item);
        }
        while (itemsIter.hasNext()) {
            EditorItem editorItem = itemsIter.next();
            this.removeItem(editorItem);
        }
    }

    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, Set<FXOMInstance> selectedInstances) {
        super.reset(propMeta, selectedClasses);
        this.addItem(this.getNewStringListItem());
    }

    @Override
    public void requestFocus() {
        EditorItem firstItem = this.getEditorItems().get(0);
        assert (firstItem instanceof StringListItem);
        ((StringListItem)firstItem).requestFocus();
    }

    private class StringListItem
    implements EditorItem {
        @FXML
        private Button plusBt;
        @FXML
        private MenuItem removeMi;
        @FXML
        private MenuItem moveUpMi;
        @FXML
        private MenuItem moveDownMi;
        @FXML
        private Label prefixLb;
        @FXML
        private TextField textTextfield;
        private Pane root;
        private String currentValue;
        private EditorItemDelegate editor;
        private PrefixedValue.Type itemType = PrefixedValue.Type.PLAIN_STRING;

        public StringListItem(EditorItemDelegate editor, String text) {
            this.initialize(editor, text);
        }

        private void initialize(EditorItemDelegate editor, String text) {
            this.editor = editor;
            Parent parentRoot = EditorUtils.loadFxml("StringListEditorItem.fxml", (Object)this);
            assert (parentRoot instanceof Pane);
            this.root = (Pane)parentRoot;
            this.setValue(text);
            EventHandler onActionListener = event -> {
                if (this.getValue().equals(this.currentValue)) {
                    return;
                }
                editor.commit(this);
                if (event != null && event.getSource() instanceof TextField) {
                    ((TextField)event.getSource()).selectAll();
                }
                this.updateButtons();
                this.currentValue = EditorUtils.toString(this.getValue());
            };
            ChangeListener textPropertyChange = (ov, prevText, newText) -> {
                if (prevText.isEmpty() || newText.isEmpty()) {
                    this.updateButtons();
                }
            };
            this.textTextfield.textProperty().addListener(textPropertyChange);
            this.updateButtons();
            StringListEditor.this.setTextEditorBehavior((Control)this.textTextfield, (EventHandler<ActionEvent>)onActionListener);
            this.removeMi.setText(I18N.getString("inspector.list.remove"));
            this.moveUpMi.setText(I18N.getString("inspector.list.moveup"));
            this.moveDownMi.setText(I18N.getString("inspector.list.movedown"));
            this.textTextfield.setOnMousePressed(event -> this.textTextfield.selectAll());
            this.textTextfield.focusedProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    this.textTextfield.selectAll();
                }
            });
        }

        @Override
        public final Node getNode() {
            return this.root;
        }

        @Override
        public Object getValue() {
            if (this.textTextfield.getText().isEmpty()) {
                return "";
            }
            String suffix = this.textTextfield.getText().trim();
            return new PrefixedValue(this.itemType, suffix).toString();
        }

        @Override
        public void setValue(Object text) {
            PrefixedValue prefixedValue = new PrefixedValue(EditorUtils.toString(text));
            this.itemType = prefixedValue.getType();
            this.handlePrefix(this.itemType);
            if (prefixedValue.getSuffix() != null) {
                this.textTextfield.setText(prefixedValue.getSuffix().trim());
            } else {
                this.textTextfield.setText("");
            }
            this.updateButtons();
            this.currentValue = EditorUtils.toString(this.getValue());
        }

        @Override
        public void reset() {
            this.textTextfield.setText("");
            this.textTextfield.setPromptText(null);
        }

        @Override
        public void setValueAsIndeterminate() {
            PropertyEditor.handleIndeterminate((Node)this.textTextfield);
        }

        protected void requestFocus() {
            EditorUtils.doNextFrame(() -> this.textTextfield.requestFocus());
        }

        @Override
        public MenuItem getMoveUpMenuItem() {
            return this.moveUpMi;
        }

        @Override
        public MenuItem getMoveDownMenuItem() {
            return this.moveDownMi;
        }

        @Override
        public MenuItem getRemoveMenuItem() {
            return this.removeMi;
        }

        @Override
        public Button getPlusButton() {
            return this.plusBt;
        }

        @Override
        public Button getMinusButton() {
            return null;
        }

        @FXML
        void add(ActionEvent event) {
            StringListItem styleClassItem = StringListEditor.this.getNewStringListItem();
            this.editor.add(this, styleClassItem);
            styleClassItem.requestFocus();
        }

        @FXML
        void remove(ActionEvent event) {
            this.editor.remove(this);
        }

        @FXML
        void up(ActionEvent event) {
            this.editor.up(this);
        }

        @FXML
        void down(ActionEvent event) {
            this.editor.down(this);
        }

        @FXML
        void plusBtTyped(KeyEvent event) {
            if (event.getCode() == KeyCode.ENTER) {
                this.add(null);
            }
        }

        private void updateButtons() {
            if (this.textTextfield.getText().isEmpty()) {
                this.plusBt.setDisable(true);
                this.removeMi.setDisable(false);
            } else {
                this.plusBt.setDisable(false);
                this.removeMi.setDisable(false);
            }
        }

        protected void disablePlusButton(boolean disable) {
            this.plusBt.setDisable(disable);
        }

        protected void disableRemove(boolean disable) {
            this.removeMi.setDisable(disable);
        }

        protected void handlePrefix(PrefixedValue.Type type) {
            this.itemType = type;
            if (type == PrefixedValue.Type.DOCUMENT_RELATIVE_PATH) {
                this.setPrefix("@");
            } else if (type == PrefixedValue.Type.CLASSLOADER_RELATIVE_PATH) {
                this.setPrefix("@/");
            } else {
                this.removeLabel();
            }
        }

        private void setPrefix(String str) {
            if (!this.prefixLb.isVisible()) {
                this.prefixLb.setVisible(true);
                this.prefixLb.setManaged(true);
            }
            this.prefixLb.setText(str);
        }

        private void removeLabel() {
            this.prefixLb.setVisible(false);
            this.prefixLb.setManaged(false);
        }
    }
}

