/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.AutoSuggestEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorItem;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorItemDelegate;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.InlineListEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.PropertyEditor;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.util.CssInternal;
import com.oracle.javafx.scenebuilder.kit.util.URLUtils;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;

public class StyleClassEditor
extends InlineListEditor {
    private Set<FXOMInstance> selectedInstances;
    private Map<String, String> cssClassesMap;
    private List<String> themeClasses;
    private EditorController editorController;

    public StyleClassEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, Set<FXOMInstance> selectedInstances, EditorController editorController) {
        super(propMeta, selectedClasses);
        this.initialize(selectedInstances, editorController);
    }

    private void initialize(Set<FXOMInstance> selectedInstances, EditorController editorController) {
        this.selectedInstances = selectedInstances;
        this.editorController = editorController;
        this.setLayoutFormat(PropertyEditor.LayoutFormat.DOUBLE_LINE);
        this.themeClasses = CssInternal.getThemeStyleClasses(editorController.getTheme());
        this.addItem(this.getNewStyleClassItem());
        editorController.themeProperty().addListener((ov, t, t1) -> {
            this.themeClasses = CssInternal.getThemeStyleClasses(this.editorController.getTheme());
        });
    }

    private StyleClassItem getNewStyleClassItem() {
        if (this.cssClassesMap == null) {
            this.cssClassesMap = CssInternal.getStyleClassesMap(this.editorController, this.selectedInstances);
            for (String themeClass : this.themeClasses) {
                this.cssClassesMap.remove(themeClass);
            }
        }
        return new StyleClassItem(this, this.cssClassesMap);
    }

    @Override
    public Object getValue() {
        ObservableList value = FXCollections.observableArrayList();
        for (EditorItem styleItem : this.getEditorItems()) {
            String itemValue = EditorUtils.toString(styleItem.getValue());
            if (itemValue.isEmpty()) continue;
            value.add(itemValue);
        }
        if (value.isEmpty()) {
            return super.getPropertyMeta().getDefaultValueObject();
        }
        return value;
    }

    @Override
    public void setValue(Object value) {
        this.setValueGeneric(value);
        if (value == null) {
            this.reset();
            return;
        }
        assert (value instanceof List);
        this.setValueGeneric(value);
        if (this.isSetValueDone()) {
            return;
        }
        Iterator<EditorItem> itemsIter = new ArrayList<EditorItem>(this.getEditorItems()).iterator();
        for (String item : (List)value) {
            if ((item = item.trim()).isEmpty()) continue;
            Object defaultValue = this.getPropertyMeta().getDefaultValueObject();
            assert (defaultValue instanceof List);
            List defaultClasses = (List)defaultValue;
            if (defaultClasses.contains(item)) continue;
            EditorItem editorItem = itemsIter.hasNext() ? itemsIter.next() : this.addItem(this.getNewStyleClassItem());
            editorItem.setValue(item);
        }
        while (itemsIter.hasNext()) {
            EditorItem editorItem = itemsIter.next();
            this.removeItem(editorItem);
        }
    }

    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, Set<FXOMInstance> selectedInstances, EditorController editorController) {
        super.reset(propMeta, selectedClasses);
        this.selectedInstances = selectedInstances;
        this.editorController = editorController;
        this.cssClassesMap = null;
        this.addItem(this.getNewStyleClassItem());
    }

    @Override
    public void requestFocus() {
        EditorItem firstItem = this.getEditorItems().get(0);
        assert (firstItem instanceof StyleClassItem);
        ((StyleClassItem)firstItem).requestFocus();
    }

    private class StyleClassItem
    extends AutoSuggestEditor
    implements EditorItem {
        @FXML
        private Button plusBt;
        @FXML
        private MenuButton actionMb;
        @FXML
        private MenuItem removeMi;
        @FXML
        private MenuItem moveUpMi;
        @FXML
        private MenuItem moveDownMi;
        @FXML
        private MenuItem openMi;
        @FXML
        private MenuItem revealMi;
        @FXML
        private StackPane styleClassSp;
        private Parent root;
        private TextField styleClassTf;
        private String currentValue;
        private Map<String, String> cssClassesMap;
        private EditorItemDelegate editor;

        public StyleClassItem(EditorItemDelegate editor, Map<String, String> cssClassesMap) {
            super("", "", new ArrayList<String>(cssClassesMap.keySet()), false);
            this.initialize(editor, cssClassesMap);
        }

        private void initialize(EditorItemDelegate editor, Map<String, String> cssClassesMap) {
            this.editor = editor;
            this.cssClassesMap = cssClassesMap;
            this.root = EditorUtils.loadFxml("StyleClassEditorItem.fxml", (Object)this);
            this.styleClassSp.getChildren().add((Object)super.getRoot());
            this.styleClassTf = super.getTextField();
            EventHandler onActionListener = event -> {
                if (this.getValue().equals(this.currentValue)) {
                    return;
                }
                if (this.styleClassTf.getText().isEmpty()) {
                    this.remove(null);
                }
                editor.commit(this);
                if (event != null && event.getSource() instanceof TextField) {
                    ((TextField)event.getSource()).selectAll();
                }
                this.updateButtons();
                this.currentValue = EditorUtils.toString(this.getValue());
            };
            ChangeListener textPropertyChange = (ov, prevText, newText) -> {
                if (prevText.isEmpty() || newText.isEmpty()) {
                    this.updateButtons();
                }
            };
            this.styleClassTf.textProperty().addListener(textPropertyChange);
            this.updateButtons();
            this.setTextEditorBehavior((Control)this.styleClassTf, (EventHandler<ActionEvent>)onActionListener, false);
            ChangeListener focusListener = (observable, oldValue, newValue) -> {
                if (!newValue.booleanValue()) {
                    editor.editing(false, onActionListener);
                } else {
                    editor.editing(true, onActionListener);
                }
            };
            this.styleClassTf.focusedProperty().addListener(focusListener);
            this.removeMi.setText(I18N.getString("inspector.list.remove"));
            this.moveUpMi.setText(I18N.getString("inspector.list.moveup"));
            this.moveDownMi.setText(I18N.getString("inspector.list.movedown"));
            if (!cssClassesMap.isEmpty()) {
                this.actionMb.getItems().add((Object)new SeparatorMenuItem());
            }
            for (String className : cssClassesMap.keySet()) {
                MenuItem menuItem = new MenuItem(className);
                menuItem.setMnemonicParsing(false);
                menuItem.setOnAction(t -> {
                    this.styleClassTf.setText(className);
                    this.getCommitListener().handle(null);
                });
                this.actionMb.getItems().add((Object)menuItem);
            }
        }

        @Override
        public final Node getNode() {
            return this.root;
        }

        @Override
        public Object getValue() {
            return EditorUtils.getPlainString(this.styleClassTf.getText()).trim();
        }

        @Override
        public void setValue(Object styleClass) {
            this.styleClassTf.setText(EditorUtils.toString(styleClass).trim());
            this.updateButtons();
            this.currentValue = EditorUtils.toString(this.getValue());
        }

        @Override
        public void reset() {
            this.styleClassTf.setText("");
        }

        @Override
        public void requestFocus() {
            super.requestFocus();
        }

        @Override
        public void setValueAsIndeterminate() {
            StyleClassItem.handleIndeterminate((Node)this.styleClassTf);
        }

        @Override
        public MenuItem getMoveUpMenuItem() {
            return this.moveUpMi;
        }

        @Override
        public MenuItem getMoveDownMenuItem() {
            return this.moveDownMi;
        }

        @Override
        public MenuItem getRemoveMenuItem() {
            return this.removeMi;
        }

        @Override
        public Button getPlusButton() {
            return this.plusBt;
        }

        @Override
        public Button getMinusButton() {
            return null;
        }

        @FXML
        void add(ActionEvent event) {
            StyleClassItem styleClassItem = StyleClassEditor.this.getNewStyleClassItem();
            this.editor.add(this, styleClassItem);
            styleClassItem.requestFocus();
        }

        @FXML
        void remove(ActionEvent event) {
            this.editor.remove(this);
        }

        @FXML
        void up(ActionEvent event) {
            this.editor.up(this);
        }

        @FXML
        void down(ActionEvent event) {
            this.editor.down(this);
        }

        @FXML
        void plusBtTyped(KeyEvent event) {
            if (event.getCode() == KeyCode.ENTER) {
                this.editor.add(this, StyleClassEditor.this.getNewStyleClassItem());
            }
        }

        @FXML
        void open(ActionEvent event) {
            String urlStr = this.cssClassesMap.get(this.getValue());
            if (urlStr == null) {
                return;
            }
            try {
                EditorPlatform.open(urlStr);
            }
            catch (IOException ex) {
                StyleClassEditor.this.editorController.getMessageLog().logWarningMessage("inspector.stylesheet.cannotopen", urlStr);
            }
        }

        @FXML
        void reveal(ActionEvent event) {
            String urlStr = this.cssClassesMap.get(this.getValue());
            if (urlStr == null) {
                return;
            }
            try {
                File file = URLUtils.getFile(urlStr);
                if (file == null) {
                    return;
                }
                EditorPlatform.revealInFileBrowser(file);
            }
            catch (IOException | URISyntaxException ex) {
                StyleClassEditor.this.editorController.getMessageLog().logWarningMessage("inspector.stylesheet.cannotreveal", urlStr);
            }
        }

        private void updateButtons() {
            if (this.styleClassTf.getText().isEmpty()) {
                this.plusBt.setDisable(true);
                this.removeMi.setDisable(false);
            } else {
                this.plusBt.setDisable(false);
                this.removeMi.setDisable(false);
            }
            String stylesheetUrl = this.cssClassesMap.get(this.getValue());
            if (stylesheetUrl == null) {
                this.openMi.setVisible(false);
                this.revealMi.setVisible(false);
            } else {
                this.openMi.setVisible(true);
                this.revealMi.setVisible(true);
                String stylesheet = EditorUtils.getSimpleFileName(stylesheetUrl);
                this.openMi.setText(I18N.getString("inspector.list.open", stylesheet));
                if (EditorPlatform.IS_MAC) {
                    this.revealMi.setText(I18N.getString("inspector.list.reveal.finder", stylesheet));
                } else {
                    this.revealMi.setText(I18N.getString("inspector.list.reveal.explorer", stylesheet));
                }
            }
        }

        protected void disablePlusButton(boolean disable) {
            this.plusBt.setDisable(disable);
        }

        protected void disableRemove(boolean disable) {
            this.removeMi.setDisable(disable);
        }
    }
}

