/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.util;

import javafx.beans.NamedArg;
import javafx.util.Duration;

public class SBDuration
extends Duration {
    public SBDuration(@NamedArg(value="millis") double millis) {
        super(millis);
    }

    public SBDuration(Duration duration) {
        super(duration.toMillis());
    }

    public String toString() {
        return this.isIndefinite() ? "INDEFINITE" : (this.isUnknown() ? "UNKNOWN" : this.toMillis() + "ms");
    }

    public static SBDuration valueOf(String time) {
        String suffix;
        double value;
        int index = -1;
        for (int i = 0; i < time.length(); ++i) {
            char c = time.charAt(i);
            if (Character.isDigit(c) || c == '.' || c == '-' || c == 'E') continue;
            index = i;
            break;
        }
        if (index == -1) {
            value = Double.parseDouble(time);
            suffix = "ms";
        } else {
            value = Double.parseDouble(time.substring(0, index));
            suffix = time.substring(index);
        }
        if ("ms".equals(suffix)) {
            return new SBDuration(SBDuration.millis((double)value));
        }
        if ("s".equals(suffix)) {
            return new SBDuration(SBDuration.seconds((double)value));
        }
        if ("m".equals(suffix)) {
            return new SBDuration(SBDuration.minutes((double)value));
        }
        if ("h".equals(suffix)) {
            return new SBDuration(SBDuration.hours((double)value));
        }
        throw new IllegalArgumentException("The time parameter must have a suffix of [ms|s|m|h]");
    }
}

